/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.algorithms;

import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.aksw.sparqlify.algebra.sql.exprs.evaluators.SqlExprEvaluator;
import org.aksw.sparqlify.algebra.sql.exprs2.S_ColumnRef;
import org.aksw.sparqlify.algebra.sql.exprs2.S_Constant;
import org.aksw.sparqlify.algebra.sql.exprs2.SqlExpr;
import org.aksw.sparqlify.core.TypeToken;
import org.aksw.sparqlify.core.algorithms.ExprSqlRewrite;
import org.aksw.sparqlify.core.cast.SqlValue;
import org.aksw.sparqlify.core.cast.TypeSystem;
import org.aksw.sparqlify.core.datatypes.SparqlFunction;
import org.aksw.sparqlify.core.interfaces.SqlTranslator;
import org.aksw.sparqlify.expr.util.ExprUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class SqlTranslatorImpl
implements SqlTranslator {
    private static final Logger logger = LoggerFactory.getLogger(SqlTranslatorImpl.class);
    private TypeSystem datatypeSystem;

    public SqlTranslatorImpl(TypeSystem datatypeSystem) {
        this.datatypeSystem = datatypeSystem;
    }

    public static List<TypeToken> getTypes(Collection<SqlExpr> sqlExprs) {
        ArrayList<TypeToken> result = new ArrayList<TypeToken>(sqlExprs.size());
        for (SqlExpr sqlExpr : sqlExprs) {
            TypeToken typeName = sqlExpr.getDatatype();
            result.add(typeName);
        }
        return result;
    }

    public static boolean containsTypeError(Iterable<SqlExpr> exprs) {
        for (SqlExpr expr : exprs) {
            if (!S_Constant.TYPE_ERROR.equals(expr)) continue;
            return true;
        }
        return false;
    }

    public static boolean isConstantsOnly(Iterable<Expr> exprs) {
        for (Expr expr : exprs) {
            if (expr.isConstant()) continue;
            return false;
        }
        return true;
    }

    public static boolean isConstantsOnlySql(Iterable<SqlExpr> exprs) {
        for (SqlExpr expr : exprs) {
            if (expr.isConstant()) continue;
            return false;
        }
        return true;
    }

    public static boolean isConstantArgsOnly(ExprFunction fn) {
        boolean result = SqlTranslatorImpl.isConstantsOnly(fn.getArgs());
        return result;
    }

    public SqlExpr translate(ExprFunction fn, Map<Var, Expr> binding, Map<String, TypeToken> typeMap) {
        SqlExpr tmp;
        ArrayList<SqlExpr> evaledArgs = new ArrayList<SqlExpr>();
        logger.debug("Processing: " + fn);
        for (Expr arg : fn.getArgs()) {
            SqlExpr evaledArg = this.translateX(arg, binding, typeMap);
            evaledArgs.add(evaledArg);
        }
        String functionId = ExprUtils.getFunctionId(fn);
        SparqlFunction sparqlFunction = this.datatypeSystem.getSparqlFunction(functionId);
        if (sparqlFunction == null) {
            throw new RuntimeException("Sparql function not declared: " + functionId);
        }
        SqlExprEvaluator evaluator = sparqlFunction.getEvaluator();
        logger.debug("Evaluator for '" + functionId + "': " + evaluator);
        if (evaluator != null && (tmp = evaluator.eval(evaledArgs)) != null) {
            return tmp;
        }
        throw new RuntimeException("No evaluator found for " + fn);
    }

    public SqlExpr translate(NodeValue expr) {
        SqlValue value = this.datatypeSystem.convertSql(expr);
        S_Constant result = new S_Constant(value);
        return result;
    }

    public SqlExpr translate(ExprVar expr, Map<Var, Expr> binding, Map<String, TypeToken> typeMap) {
        SqlExpr result;
        if (binding != null) {
            Var var = expr.asVar();
            Expr definition = binding.get(var);
            result = this.translateX(definition, null, typeMap);
        } else {
            String varName = expr.getVarName();
            TypeToken datatype = typeMap.get(varName);
            if (datatype == null) {
                throw new RuntimeException("No datatype found for " + varName);
            }
            result = new S_ColumnRef(datatype, varName);
        }
        return result;
    }

    @Override
    public ExprSqlRewrite translate(Expr expr, Map<Var, Expr> binding, Map<String, TypeToken> typeMap) {
        throw new RuntimeException("");
    }

    public SqlExpr translateX(Expr expr, Map<Var, Expr> binding, Map<String, TypeToken> typeMap) {
        if (expr == null) {
            throw new NullPointerException();
        }
        SqlExpr result = null;
        if (expr.isConstant()) {
            result = this.translate(expr.getConstant());
        } else if (expr.isFunction()) {
            ExprFunction fn = expr.getFunction();
            result = this.translate(fn, binding, typeMap);
        } else if (expr.isVariable()) {
            Expr boundExpr;
            result = this.translate(expr.getExprVar(), binding, typeMap);
            if (binding != null && (boundExpr = binding.get(expr.asVar())) != null) {
                result = this.translateX(boundExpr, null, typeMap);
            }
        } else {
            throw new RuntimeException("Unknown expression type encountered: " + expr);
        }
        return result;
    }
}

