/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.algorithms;

import com.hp.hpl.jena.sdb.core.Generator;
import com.hp.hpl.jena.sdb.core.Gensym;
import com.hp.hpl.jena.sdb.core.JoinType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.util.reflect.MultiMethod;
import org.aksw.sparqlify.algebra.sql.exprs2.S_ColumnRef;
import org.aksw.sparqlify.algebra.sql.exprs2.SqlExpr;
import org.aksw.sparqlify.algebra.sql.nodes.Projection;
import org.aksw.sparqlify.algebra.sql.nodes.Schema;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOp;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpDistinct;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpEmpty;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpExtend;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpFilter;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpGroupBy;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpJoin;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpOrder;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpProject;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpQuery;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpRename;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpSelectBlock;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpSlice;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpTable;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpUnionN;
import org.aksw.sparqlify.algebra.sql.nodes.SqlSortCondition;
import org.aksw.sparqlify.core.TypeToken;
import org.aksw.sparqlify.core.algorithms.JoinContext;
import org.aksw.sparqlify.core.algorithms.JoinContextJoin;
import org.aksw.sparqlify.core.algorithms.SqlExprSubstitutor;
import org.aksw.sparqlify.core.algorithms.SqlExprUtils;
import org.aksw.sparqlify.core.algorithms.SqlOps;
import org.aksw.sparqlify.core.interfaces.SqlOpSelectBlockCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlOpSelectBlockCollectorImpl
implements SqlOpSelectBlockCollector {
    private static final Logger logger = LoggerFactory.getLogger(SqlOpSelectBlockCollectorImpl.class);
    private static Generator aliasGenerator = Gensym.create((String)"a");
    private static Generator projectionGenerator = Gensym.create((String)"o");
    static boolean useCodeThatCausesConflictsOnDuplicateNames = true;

    public static SqlOp makeSelect(SqlOp sqlOp) {
        SqlOp result = SqlOpSelectBlockCollectorImpl._makeSelect(sqlOp, null);
        return result;
    }

    public static SqlOp _makeSelect(SqlOp sqlOp, Set<String> refs) {
        SqlOp result;
        SqlOps type = SqlOps.valueOf(sqlOp.getClass().getSimpleName());
        switch (type) {
            case SqlOpOrder: {
                result = SqlOpSelectBlockCollectorImpl.makeSelect((SqlOpOrder)sqlOp, refs);
                break;
            }
            case SqlOpGroupBy: {
                result = SqlOpSelectBlockCollectorImpl.makeSelect((SqlOpGroupBy)sqlOp, refs);
                break;
            }
            case SqlOpEmpty: {
                result = SqlOpSelectBlockCollectorImpl.makeSelect((SqlOpEmpty)sqlOp, refs);
                break;
            }
            case SqlOpTable: {
                result = SqlOpSelectBlockCollectorImpl.makeSelect((SqlOpTable)sqlOp, refs);
                break;
            }
            case SqlOpQuery: {
                result = SqlOpSelectBlockCollectorImpl.makeSelect((SqlOpQuery)sqlOp, refs);
                break;
            }
            case SqlOpFilter: {
                result = SqlOpSelectBlockCollectorImpl.makeSelect((SqlOpFilter)sqlOp, refs);
                break;
            }
            case SqlOpProject: {
                result = SqlOpSelectBlockCollectorImpl.makeSelect((SqlOpProject)sqlOp, refs);
                break;
            }
            case SqlOpExtend: {
                result = SqlOpSelectBlockCollectorImpl.makeSelect((SqlOpExtend)sqlOp, refs);
                break;
            }
            case SqlOpJoin: {
                result = SqlOpSelectBlockCollectorImpl.makeSelect((SqlOpJoin)sqlOp, refs);
                break;
            }
            case SqlOpUnionN: {
                result = SqlOpSelectBlockCollectorImpl.makeSelect((SqlOpUnionN)sqlOp, refs);
                break;
            }
            case SqlOpDistinct: {
                result = SqlOpSelectBlockCollectorImpl.makeSelect((SqlOpDistinct)sqlOp, refs);
                break;
            }
            case SqlOpSlice: {
                result = SqlOpSelectBlockCollectorImpl.makeSelect((SqlOpSlice)sqlOp, refs);
                break;
            }
            default: {
                logger.warn("Should not come here");
                result = (SqlOp)MultiMethod.invokeStatic(SqlOpSelectBlockCollectorImpl.class, (String)"makeSelect", (Object[])new Object[]{sqlOp, refs});
            }
        }
        return result;
    }

    public static SqlOp makeSelect(SqlOpEmpty op, Set<String> refs) {
        SqlOpEmpty result = SqlOpSelectBlockCollectorImpl.makeSelectOrTable(op, refs);
        return result;
    }

    public static SqlOp makeSelect(SqlOpOrder op, Set<String> refs) {
        SqlOp newOp = SqlOpSelectBlockCollectorImpl._makeSelect(op.getSubOp(), refs);
        SqlOpSelectBlock result = SqlOpSelectBlockCollectorImpl.requireSelectBlock(newOp);
        List<SqlSortCondition> newExprs = SqlOpSelectBlockCollectorImpl.adjustSortConditions(op.getSortConditions(), result.getProjection());
        result.getSortConditions().addAll(newExprs);
        return result;
    }

    public static SqlOp makeSelect(SqlOpGroupBy op, Set<String> refs) {
        SqlOp newOp = SqlOpSelectBlockCollectorImpl._makeSelect(op.getSubOp(), refs);
        SqlOpSelectBlock result = SqlOpSelectBlockCollectorImpl.requireSelectBlock(newOp);
        List<SqlExpr> newExprs = SqlOpSelectBlockCollectorImpl.adjustConditions(op.getGroupByExprs(), result.getProjection());
        result.getGroupByExprs().addAll(newExprs);
        return result;
    }

    public static SqlOp makeSelect(SqlOpSlice op, Set<String> refs) {
        SqlOp newOp = SqlOpSelectBlockCollectorImpl._makeSelect(op.getSubOp(), refs);
        SqlOpSelectBlock result = SqlOpSelectBlockCollectorImpl.requireSelectBlock(newOp);
        SqlOpSelectBlock.slice(result, op.getOffset(), op.getLimit());
        return result;
    }

    public static SqlOp makeSelect(SqlOpDistinct op, Set<String> refs) {
        SqlOp newOp = SqlOpSelectBlockCollectorImpl._makeSelect(op.getSubOp(), refs);
        SqlOpSelectBlock result = SqlOpSelectBlockCollectorImpl.requireSelectBlock(newOp);
        result.setDistinct(true);
        for (SqlSortCondition cond : result.getSortConditions()) {
            String colName = projectionGenerator.next();
            SqlExpr expr = cond.getExpression();
            result.getProjection().put(colName, expr);
        }
        return result;
    }

    public static SqlOpUnionN makeSelect(SqlOpUnionN op, Set<String> refs) {
        ArrayList<SqlOp> newMembers = new ArrayList<SqlOp>();
        for (SqlOp member : op.getSubOps()) {
            SqlOp subOp = SqlOpSelectBlockCollectorImpl._makeSelect(member, refs);
            newMembers.add(subOp);
        }
        String aliasName = aliasGenerator.next();
        SqlOpUnionN result = new SqlOpUnionN(op.getSchema(), newMembers, aliasName);
        return result;
    }

    public static SqlOp makeSelect(SqlOpTable node, Set<String> refs) {
        SqlOpTable opTable = SqlOpSelectBlockCollectorImpl.makeSelectOrTable(node);
        SqlOpSelectBlock result = SqlOpSelectBlock.create(opTable);
        for (String columnName : opTable.getSchema().getColumnNames()) {
            TypeToken datatype = result.getSchema().getColumnType(columnName);
            result.getProjection().put(columnName, new S_ColumnRef(datatype, columnName, opTable.getAliasName()));
        }
        return result;
    }

    public static SqlOp makeSelect(SqlOpQuery node, Set<String> refs) {
        SqlOpQuery result = SqlOpSelectBlockCollectorImpl.makeSelectOrTable(node);
        return result;
    }

    public static SqlOpSelectBlock requireSelectBlock(SqlOp op) {
        SqlOpSelectBlock result;
        if (op instanceof SqlOpSelectBlock) {
            result = (SqlOpSelectBlock)op;
        } else {
            result = SqlOpSelectBlock.create(op);
            SqlOpSelectBlockCollectorImpl.initProjection(result.getProjection(), op.getSchema(), result.getAliasName());
        }
        return result;
    }

    public static SqlExpr transformToAliasedReferences(SqlExpr expr, Projection projection) {
        Map<String, SqlExpr> map = projection.getNameToExpr();
        SqlExprSubstitutor substitutor = SqlExprSubstitutor.create(map);
        SqlExpr result = substitutor.substitute(expr);
        return result;
    }

    public static List<SqlSortCondition> adjustSortConditions(List<SqlSortCondition> sqlConds, Projection projection) {
        int n = sqlConds.size();
        ArrayList<SqlExpr> exprs = new ArrayList<SqlExpr>(n);
        for (SqlSortCondition sqlCond : sqlConds) {
            SqlExpr expr = sqlCond.getExpression();
            exprs.add(expr);
        }
        List<SqlExpr> adjusteds = SqlOpSelectBlockCollectorImpl.adjustConditions(exprs, projection);
        ArrayList<SqlSortCondition> result = new ArrayList<SqlSortCondition>(n);
        for (int i = 0; i < n; ++i) {
            SqlSortCondition sqlCond = sqlConds.get(i);
            SqlExpr adjusted = adjusteds.get(i);
            int direction = sqlCond.getDirection();
            SqlSortCondition newSqlCond = new SqlSortCondition(adjusted, direction);
            result.add(newSqlCond);
        }
        return result;
    }

    public static List<SqlExpr> adjustConditions(List<SqlExpr> exprs, Projection projection) {
        Map<String, SqlExpr> map = projection.getNameToExpr();
        SqlExprSubstitutor substitutor = SqlExprSubstitutor.create(map);
        List<SqlExpr> result = substitutor.substitute(exprs);
        return result;
    }

    public static SqlOp makeSelect(SqlOpFilter op, Set<String> refs) {
        SqlOp subOp = SqlOpSelectBlockCollectorImpl._makeSelect(op.getSubOp(), refs);
        SqlOpSelectBlock result = SqlOpSelectBlockCollectorImpl.requireSelectBlock(subOp);
        result.setSchema(op.getSchema());
        List<SqlExpr> transformed = SqlOpSelectBlockCollectorImpl.adjustConditions(op.getExprs(), result.getProjection());
        result.getConditions().addAll(transformed);
        return result;
    }

    public static SqlOpSelectBlock makeSelect(SqlOpExtend op, Set<String> refs) {
        SqlOp subOp = SqlOpSelectBlockCollectorImpl._makeSelect(op.getSubOp(), refs);
        SqlOpSelectBlock result = SqlOpSelectBlockCollectorImpl.requireSelectBlock(subOp);
        result.setSchema(op.getSchema());
        Projection subProj = result.getProjection();
        Projection extendedProj = new Projection();
        for (Map.Entry<String, SqlExpr> entry : op.getProjection().getNameToExpr().entrySet()) {
            String columnName = entry.getKey();
            SqlExpr originalExpr = entry.getValue();
            boolean enableRefSubstitution = false;
            if (enableRefSubstitution) {
                Set<S_ColumnRef> colRefs = SqlExprUtils.getColumnReferences(originalExpr);
                HashMap<String, SqlExpr> subst = new HashMap<String, SqlExpr>();
                for (S_ColumnRef colRef : colRefs) {
                    String colAlias = colRef.getRelationAlias();
                    if (colAlias != null) continue;
                    String refName = colRef.getColumnName();
                    SqlExpr subExpr = subProj.getNameToExpr().get(refName);
                    if (subExpr == null) continue;
                    subst.put(refName, subExpr);
                }
                if (!subst.isEmpty()) {
                    originalExpr = SqlExprSubstitutor.create(subst).substitute(originalExpr);
                }
            }
            SqlExpr aliasedExpr = SqlOpSelectBlockCollectorImpl.transformToAliasedReferences(originalExpr, result.getProjection());
            extendedProj.getNames().add(columnName);
            extendedProj.getNameToExpr().put(columnName, aliasedExpr);
        }
        result.getProjection().extend(extendedProj);
        return result;
    }

    public static SqlOp makeSelect(SqlOpProject op, Set<String> refs) {
        SqlOp subOp = SqlOpSelectBlockCollectorImpl._makeSelect(op.getSubOp(), refs);
        SqlOpSelectBlock result = SqlOpSelectBlockCollectorImpl.requireSelectBlock(subOp);
        SqlOp effectiveOp = result.getSubOp();
        if (effectiveOp instanceof SqlOpUnionN) {
            SqlOpSelectBlockCollectorImpl.initProjection(result.getProjection(), effectiveOp.getSchema(), SqlOpSelectBlock.getAliasName(effectiveOp));
        }
        result.setSchema(op.getSchema());
        result.getProjection().project(op.getColumnNames());
        return result;
    }

    public static SqlOpSelectBlock contextToBlock(Schema schema, JoinContext context) {
        SqlOpSelectBlock block = SqlOpSelectBlock.create();
        SqlOp op = context.getOp();
        block.setSubOp(op);
        block.setSchema(schema);
        block.getProjection().add(context.getProjection());
        block.getConditions().addAll(context.getConditions());
        return block;
    }

    public static SqlOp makeSelect(SqlOpJoin op, Set<String> refs) {
        JoinContext context = SqlOpSelectBlockCollectorImpl.collectJoins(op, refs);
        SqlOpSelectBlock block = SqlOpSelectBlockCollectorImpl.contextToBlock(op.getSchema(), context);
        return block;
    }

    public static JoinContext _collectJoins(SqlOp sqlOp, Set<String> refs) {
        JoinContext result;
        SqlOps type = SqlOps.valueOf(sqlOp.getClass().getSimpleName());
        switch (type) {
            case SqlOpEmpty: {
                result = SqlOpSelectBlockCollectorImpl.collectJoins((SqlOpEmpty)sqlOp, refs);
                break;
            }
            case SqlOpTable: {
                result = SqlOpSelectBlockCollectorImpl.collectJoins((SqlOpTable)sqlOp, refs);
                break;
            }
            case SqlOpQuery: {
                result = SqlOpSelectBlockCollectorImpl.collectJoins((SqlOpQuery)sqlOp, refs);
                break;
            }
            case SqlOpFilter: {
                result = SqlOpSelectBlockCollectorImpl.collectJoins((SqlOpFilter)sqlOp, refs);
                break;
            }
            case SqlOpExtend: {
                result = SqlOpSelectBlockCollectorImpl.collectJoins((SqlOpExtend)sqlOp, refs);
                break;
            }
            case SqlOpRename: {
                result = SqlOpSelectBlockCollectorImpl.collectJoins((SqlOpRename)sqlOp, refs);
                break;
            }
            case SqlOpJoin: {
                result = SqlOpSelectBlockCollectorImpl.collectJoins((SqlOpJoin)sqlOp, refs);
                break;
            }
            case SqlOpUnionN: {
                result = SqlOpSelectBlockCollectorImpl.collectJoins((SqlOpUnionN)sqlOp, refs);
                break;
            }
            default: {
                logger.warn("Not sure if we should come here");
                result = (JoinContext)MultiMethod.invokeStatic(SqlOpSelectBlockCollectorImpl.class, (String)"collectJoins", (Object[])new Object[]{sqlOp});
            }
        }
        return result;
    }

    public static JoinContext collectJoins(SqlOpEmpty op, Set<String> refs) {
        SqlOpEmpty table = SqlOpSelectBlockCollectorImpl.makeSelectOrTable(op, refs);
        JoinContextJoin result = new JoinContextJoin(table);
        SqlOpSelectBlockCollectorImpl.initProjection(result.getProjection(), op.getSchema(), table.getAliasName());
        return result;
    }

    public static JoinContext collectJoins(SqlOpJoin op, Set<String> refs) {
        JoinContext left = SqlOpSelectBlockCollectorImpl._collectJoins(op.getLeft(), refs);
        JoinContext right = SqlOpSelectBlockCollectorImpl._collectJoins(op.getRight(), refs);
        if (op.getJoinType().equals((Object)JoinType.LEFT) && left.getOp() instanceof SqlOpJoin) {
            SqlOpSelectBlock subSelect = SqlOpSelectBlockCollectorImpl.contextToBlock(left.getOp().getSchema(), left);
            String aliasName = aliasGenerator.next();
            subSelect.setAliasName(aliasName);
            left = new JoinContextJoin(subSelect);
            Projection p = subSelect.getProjection();
            Projection p2 = SqlOpSelectBlockCollectorImpl.createProjectionWithReplacedAliasReferences(p, aliasName);
            left.getProjection().add(p2);
        }
        SqlOpJoin join = useCodeThatCausesConflictsOnDuplicateNames ? new SqlOpJoin(null, op.getJoinType(), left.getOp(), right.getOp()) : SqlOpJoin.create(op.getJoinType(), left.getOp(), right.getOp());
        JoinContextJoin context = new JoinContextJoin(join);
        context.getProjection().add(left.getProjection());
        context.getProjection().add(right.getProjection());
        context.getConditions().addAll(left.getConditions());
        context.getConditions().addAll(right.getConditions());
        List<SqlExpr> transformed = SqlOpSelectBlockCollectorImpl.adjustConditions(op.getConditions(), context.getProjection());
        join.getConditions().addAll(transformed);
        return context;
    }

    public static JoinContext collectJoins(SqlOpUnionN op, Set<String> refs) {
        SqlOpUnionN newOp;
        SqlOpUnionN resultOp = newOp = SqlOpSelectBlockCollectorImpl.makeSelect(op, refs);
        JoinContextJoin result = new JoinContextJoin(newOp);
        SqlOpSelectBlockCollectorImpl.initProjection(result.getProjection(), op.getSchema(), resultOp.getAliasName());
        return result;
    }

    public static JoinContext collectJoins(SqlOpFilter op, Set<String> refs) {
        JoinContext result = SqlOpSelectBlockCollectorImpl._collectJoins(op.getSubOp(), refs);
        List<SqlExpr> transformed = SqlOpSelectBlockCollectorImpl.adjustConditions(op.getExprs(), result.getProjection());
        result.getConditions().addAll(transformed);
        return result;
    }

    public static JoinContext collectJoins(SqlOpRename op, Set<String> refs) {
        JoinContext result;
        if (useCodeThatCausesConflictsOnDuplicateNames) {
            result = SqlOpSelectBlockCollectorImpl._collectJoins(op.getSubOp(), refs);
            result.getProjection().renameAll((Map<String, String>)op.getRename());
        } else {
            JoinContext context = SqlOpSelectBlockCollectorImpl._collectJoins(op.getSubOp(), refs);
            context.getProjection().renameAll((Map<String, String>)op.getRename());
            SqlOpSelectBlock selectBlock = SqlOpSelectBlockCollectorImpl.contextToBlock(op.getSchema(), context);
            String aliasName = aliasGenerator.next();
            selectBlock.setAliasName(aliasName);
            result = new JoinContextJoin(selectBlock);
        }
        return result;
    }

    public static Projection initNewProjection(Schema schema, String aliasName) {
        Projection result = new Projection();
        SqlOpSelectBlockCollectorImpl.initProjection(result, schema, aliasName);
        return result;
    }

    public static Projection createProjectionWithReplacedAliasReferences(Projection projection, String aliasName) {
        Projection result = new Projection();
        for (Map.Entry<String, SqlExpr> entry : projection.getNameToExpr().entrySet()) {
            SqlExpr newSqlExpr;
            String oldName = entry.getKey();
            SqlExpr sqlExpr = entry.getValue();
            if (sqlExpr instanceof S_ColumnRef) {
                S_ColumnRef oldRef = (S_ColumnRef)sqlExpr;
                newSqlExpr = new S_ColumnRef(oldRef.getDatatype(), oldName, aliasName);
            } else {
                newSqlExpr = sqlExpr;
            }
            result.put(oldName, newSqlExpr);
        }
        return result;
    }

    public static void initProjection(Projection projection, Schema schema, String aliasName) {
        Iterator<String> i$ = schema.getColumnNames().iterator();
        while (i$.hasNext()) {
            String oldName;
            String newName = oldName = i$.next();
            TypeToken datatype = schema.getColumnType(newName);
            assert (datatype != null) : "Datatype must not be null at this point";
            projection.put(newName, new S_ColumnRef(datatype, oldName, aliasName));
        }
    }

    public static JoinContextJoin collectJoins(SqlOpExtend sqlOp, Set<String> refs) {
        SqlOpSelectBlock op = SqlOpSelectBlockCollectorImpl.makeSelect(sqlOp, refs);
        String alias = aliasGenerator.next();
        op.setAliasName(alias);
        JoinContextJoin result = new JoinContextJoin(op);
        SqlOpSelectBlockCollectorImpl.initProjection(result.getProjection(), op.getSchema(), op.getAliasName());
        return result;
    }

    public static JoinContextJoin collectJoins(SqlOpTable op, Set<String> refs) {
        SqlOpTable table = SqlOpSelectBlockCollectorImpl.makeSelectOrTable(op);
        JoinContextJoin result = new JoinContextJoin(table);
        SqlOpSelectBlockCollectorImpl.initProjection(result.getProjection(), op.getSchema(), table.getAliasName());
        return result;
    }

    public static JoinContextJoin collectJoins(SqlOpQuery op, Set<String> refs) {
        SqlOpQuery query = SqlOpSelectBlockCollectorImpl.makeSelectOrTable(op);
        JoinContextJoin result = new JoinContextJoin(query);
        SqlOpSelectBlockCollectorImpl.initProjection(result.getProjection(), op.getSchema(), query.getAliasName());
        return result;
    }

    public static SqlOpEmpty makeSelectOrTable(SqlOpEmpty node, Set<String> refs) {
        String alias = aliasGenerator.next();
        SqlOpEmpty result = new SqlOpEmpty(node.getSchema(), alias);
        return result;
    }

    public static SqlOpTable makeSelectOrTable(SqlOpTable node) {
        String alias = aliasGenerator.next();
        SqlOpTable result = new SqlOpTable(node.getSchema(), node.getTableName(), alias);
        return result;
    }

    public static SqlOpQuery makeSelectOrTable(SqlOpQuery node) {
        String alias = aliasGenerator.next();
        SqlOpQuery result = new SqlOpQuery(node.getSchema(), node.getQueryString(), alias);
        return result;
    }

    @Override
    public SqlOp transform(SqlOp op) {
        return SqlOpSelectBlockCollectorImpl._makeSelect(op, null);
    }
}

