/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core;

import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.XSD;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.collections.MultiMaps;
import org.aksw.commons.collections.multimaps.BiHashMultimap;
import org.aksw.commons.collections.multimaps.IBiSetMultimap;
import org.aksw.commons.factory.Factory1;
import org.aksw.commons.util.reflect.Caster;
import org.aksw.sparqlify.algebra.sql.exprs.SqlExpr;
import org.aksw.sparqlify.core.DatatypeSystemOld;
import org.aksw.sparqlify.core.SqlDatatype;
import org.aksw.sparqlify.core.SqlDatatypeImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatatypeSystemDefault
implements DatatypeSystemOld {
    public static final Logger logger = LoggerFactory.getLogger(DatatypeSystemDefault.class);
    public static final SqlDatatype _BYTE = DatatypeSystemDefault.dt("byte", XSD.xboolean, Byte.class);
    public static final SqlDatatype _SHORT = DatatypeSystemDefault.dt("short", XSD.xshort, Short.class);
    public static final SqlDatatype _INT = DatatypeSystemDefault.dt("int", XSD.xint, Integer.class);
    public static final SqlDatatype _LONG = DatatypeSystemDefault.dt("long", XSD.xlong, Long.class);
    public static final SqlDatatype _INTEGER = DatatypeSystemDefault.dt("integer", XSD.integer, Long.class);
    public static final SqlDatatype _DECIMAL = DatatypeSystemDefault.dt("decimal", XSD.decimal, BigDecimal.class);
    public static final SqlDatatype _UNSIGNED_BYTE = DatatypeSystemDefault.dt("unsigned_byte", XSD.unsignedByte, Short.class);
    public static final SqlDatatype _UNSIGNED_SHORT = DatatypeSystemDefault.dt("unsigned_short", XSD.unsignedShort, Integer.class);
    public static final SqlDatatype _UNSIGNED_INT = DatatypeSystemDefault.dt("unsigned_int", XSD.unsignedInt, Long.class);
    public static final SqlDatatype _UNSIGNED_LONG = DatatypeSystemDefault.dt("unsigned_long", XSD.unsignedLong, BigDecimal.class);
    public static final SqlDatatype _POSITIVE_INTEGER = DatatypeSystemDefault.dt("positive_integer", XSD.positiveInteger);
    public static final SqlDatatype _NON_NEGATIVE_INTEGER = DatatypeSystemDefault.dt("non_negative_integer", XSD.nonNegativeInteger);
    public static final SqlDatatype _NON_POSITIVE_INTEGER = DatatypeSystemDefault.dt("non_positive_integer", XSD.nonPositiveInteger);
    public static final SqlDatatype _NEGATIVE_INTEGER = DatatypeSystemDefault.dt("negative_integer", XSD.negativeInteger);
    public static final SqlDatatype _FLOAT = DatatypeSystemDefault.dt("float", XSD.xfloat, Float.class);
    public static final SqlDatatype _DOUBLE = DatatypeSystemDefault.dt("double", XSD.xdouble, Double.class);
    public static final SqlDatatype _NUMERIC = DatatypeSystemDefault.dt("numeric");
    public static final SqlDatatype _BOOLEAN = DatatypeSystemDefault.dt("boolean", XSD.xboolean, Boolean.class);
    public static final SqlDatatype _DATE = DatatypeSystemDefault.dt("date", XSD.date);
    public static final SqlDatatype _DATE_TIME = DatatypeSystemDefault.dt("datetime", XSD.dateTime, GregorianCalendar.class);
    public static final SqlDatatype _STRING = DatatypeSystemDefault.dt("string", XSD.xstring, String.class);
    public static final SqlDatatype _GEOMETRY = DatatypeSystemDefault.dt("geometry");
    public static final SqlDatatype _GEOGRAPHY = DatatypeSystemDefault.dt("geography");
    public static final IBiSetMultimap<SqlDatatype, SqlDatatype> childToParent = new BiHashMultimap();
    private Map<String, SqlDatatype> nameToDatatype = new HashMap<String, SqlDatatype>();
    private IBiSetMultimap<SqlDatatype, SqlDatatype> typeHierarchy = new BiHashMultimap();

    public static SqlDatatype dt(String name) {
        return new SqlDatatypeImpl(name, null, null);
    }

    public static SqlDatatype dt(String name, Resource resource) {
        return new SqlDatatypeImpl(name, resource.asNode(), null);
    }

    public static SqlDatatype dt(String name, Resource resource, Class<?> clazz) {
        return new SqlDatatypeImpl(name, resource.asNode(), clazz);
    }

    public static List<SqlDatatype> getDefaultDatatypes() {
        ArrayList<SqlDatatype> result = new ArrayList<SqlDatatype>();
        for (Field field : DatatypeSystemDefault.class.getDeclaredFields()) {
            if (!field.getType().equals(SqlDatatype.class)) continue;
            try {
                result.add((SqlDatatype)field.get(null));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    @Override
    public SqlDatatype getByName(String name) {
        return this.nameToDatatype.get(name);
    }

    @Override
    public SqlDatatype requireByName(String name) {
        SqlDatatype result = this.getByName(name);
        if (result == null) {
            throw new RuntimeException("No registered datatype found with name '" + name + "'");
        }
        return result;
    }

    public Set<String> getRegisteredDatatypes() {
        return this.nameToDatatype.keySet();
    }

    public void registerDatatype(String name, SqlDatatype datatype) {
        this.nameToDatatype.put(name, datatype);
    }

    public SqlDatatype getDatatype(String name) {
        return this.nameToDatatype.get(name);
    }

    public DatatypeSystemDefault() {
        for (SqlDatatype item : DatatypeSystemDefault.getDefaultDatatypes()) {
            this.nameToDatatype.put(item.getName(), item);
            if (item.getXsd() == null) continue;
            this.nameToDatatype.put(item.getXsd().getURI(), item);
        }
        for (Map.Entry entry : childToParent.entries()) {
            this.typeHierarchy.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Object cast(Object value, SqlDatatype to) {
        Class<?> targetClazz = to.getCorrespondingClass();
        if (targetClazz == null) {
            logger.warn("No class corresponding to '" + to + "' found.");
            return null;
        }
        return Caster.tryCast((Object)value, targetClazz);
    }

    @Override
    public Factory1<SqlExpr> cast(SqlDatatype from, SqlDatatype to) {
        return null;
    }

    @Override
    public SqlDatatype mostGenericDatatype(SqlDatatype from, SqlDatatype to) {
        throw new RuntimeException("This method does not make sense. We coulde always return object");
    }

    @Override
    public Set<SqlDatatype> supremumDatatypes(SqlDatatype a, SqlDatatype b) {
        return MultiMaps.getCommonParent((Map)childToParent.asMap(), (Object)a, (Object)b);
    }

    @Override
    public Integer compare(SqlDatatype a, SqlDatatype b) {
        return null;
    }

    public static void main(String[] args) {
        DatatypeSystemDefault system = new DatatypeSystemDefault();
    }

    @Override
    public SqlDatatype getByClass(Class<?> clazz) {
        return null;
    }

    static {
        childToParent.put((Object)_BYTE, (Object)_SHORT);
        childToParent.put((Object)_SHORT, (Object)_INT);
        childToParent.put((Object)_INT, (Object)_LONG);
        childToParent.put((Object)_LONG, (Object)_DECIMAL);
        childToParent.put((Object)_DECIMAL, (Object)_INTEGER);
        childToParent.put((Object)_UNSIGNED_BYTE, (Object)_UNSIGNED_SHORT);
        childToParent.put((Object)_UNSIGNED_SHORT, (Object)_UNSIGNED_INT);
        childToParent.put((Object)_UNSIGNED_INT, (Object)_UNSIGNED_LONG);
        childToParent.put((Object)_UNSIGNED_LONG, (Object)_NON_NEGATIVE_INTEGER);
        childToParent.put((Object)_NON_NEGATIVE_INTEGER, (Object)_INTEGER);
        childToParent.put((Object)_NEGATIVE_INTEGER, (Object)_NON_POSITIVE_INTEGER);
        childToParent.put((Object)_NON_POSITIVE_INTEGER, (Object)_INTEGER);
        childToParent.put((Object)_INTEGER, (Object)_NUMERIC);
        childToParent.put((Object)_FLOAT, (Object)_NUMERIC);
        childToParent.put((Object)_DOUBLE, (Object)_NUMERIC);
    }
}

