/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.config.loader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.aksw.sparqlify.config.lang.ConfigParser;
import org.aksw.sparqlify.config.syntax.Config;
import org.aksw.sparqlify.validation.LoggerCount;
import org.antlr.runtime.RecognitionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigFactory {
    private static final Logger logger = LoggerFactory.getLogger(ConfigFactory.class);
    private File configFile;

    public static Config create(File configFile) throws IOException, RecognitionException {
        ConfigFactory factory = new ConfigFactory();
        factory.setConfigFile(configFile);
        Config result = factory.create();
        return result;
    }

    public void setConfigFile(File configFile) {
        this.configFile = configFile;
    }

    public File getConfigFile() {
        return this.configFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Config create() throws IOException, RecognitionException {
        Config config;
        if (!this.configFile.exists()) {
            logger.error("File does not exist: " + this.configFile.getAbsolutePath());
        }
        LoggerCount loggerCount = new LoggerCount(logger);
        ConfigParser parser = new ConfigParser();
        FileInputStream in = new FileInputStream(this.configFile);
        try {
            config = parser.parse(in, (Logger)loggerCount);
        }
        finally {
            ((InputStream)in).close();
        }
        return config;
    }
}

