/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.compile.sparql;

import com.google.common.base.Joiner;
import com.hp.hpl.jena.sdb.core.Generator;
import com.hp.hpl.jena.sdb.core.JoinType;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import org.aksw.commons.factory.Factory1;
import org.aksw.commons.util.reflect.MultiMethod;
import org.aksw.sparqlify.algebra.sparql.expr.E_RdfTerm;
import org.aksw.sparqlify.algebra.sparql.transform.NodeExprSubstitutor;
import org.aksw.sparqlify.algebra.sql.exprs.S_String;
import org.aksw.sparqlify.algebra.sql.exprs.SqlExpr;
import org.aksw.sparqlify.algebra.sql.exprs.SqlExprColumn;
import org.aksw.sparqlify.algebra.sql.exprs.SqlSortCondition;
import org.aksw.sparqlify.algebra.sql.nodes.SqlAlias;
import org.aksw.sparqlify.algebra.sql.nodes.SqlJoin;
import org.aksw.sparqlify.algebra.sql.nodes.SqlNodeEmpty;
import org.aksw.sparqlify.algebra.sql.nodes.SqlNodeOld;
import org.aksw.sparqlify.algebra.sql.nodes.SqlQuery;
import org.aksw.sparqlify.algebra.sql.nodes.SqlSelectBlock;
import org.aksw.sparqlify.algebra.sql.nodes.SqlTable;
import org.aksw.sparqlify.algebra.sql.nodes.SqlUnion;
import org.aksw.sparqlify.algebra.sql.nodes.SqlUnionN;
import org.aksw.sparqlify.algebra.sql.nodes.VarDef;
import org.aksw.sparqlify.compile.sparql.DatatypeToStringPostgres;
import org.aksw.sparqlify.compile.sparql.SqlExprSerializer;
import org.aksw.sparqlify.compile.sparql.SqlExprSerializerPostgres;
import org.aksw.sparqlify.core.DatatypeSystemDefault;
import org.aksw.sparqlify.core.SqlDatatype;
import org.aksw.sparqlify.core.SqlNodeBinding;
import org.apache.jena.atlas.io.IndentedWriter;

public class SqlAlgebraToString {
    private static SqlExprSerializer sqlExprSerializer = new SqlExprSerializerPostgres();
    private static DatatypeToStringPostgres castFactory = new DatatypeToStringPostgres();

    public static String makeString(SqlNodeOld node) {
        SqlAlgebraToString transformer = new SqlAlgebraToString();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IndentedWriter writer = new IndentedWriter((OutputStream)out);
        transformer.asString(node, writer);
        return out.toString();
    }

    public void asString(SqlNodeOld node, IndentedWriter writer) {
        SqlAlgebraToString transformer = new SqlAlgebraToString();
        MultiMethod.invoke((Object)this, (String)"_asString", (Object[])new Object[]{node, writer});
    }

    public static String projection(Map<String, SqlExpr> map) {
        if (map.isEmpty()) {
            return "true";
        }
        String result = "";
        ArrayList<String> strs = new ArrayList<String>();
        TreeSet<String> columnNames = new TreeSet<String>(map.keySet());
        for (String columnName : columnNames) {
            SqlExpr value = map.get(columnName);
            String exprStr = "";
            if (value != null) {
                exprStr = sqlExprSerializer.serialize(value);
            }
            strs.add(exprStr + " " + SqlAlgebraToString.escapeAlias(columnName));
        }
        result = Joiner.on((String)", ").join(strs);
        return result;
    }

    public static String escapeAlias(String columnName) {
        return "\"" + columnName + "\"";
    }

    public void _asString(SqlNodeEmpty node, IndentedWriter writer) {
        writer.print((Object)"EMPTY_SQL_NODE");
    }

    public void _asString(SqlAlias node, IndentedWriter writer) {
        writer.print((Object)"(");
        this.asString(node.getSubNode(), writer);
        writer.print((Object)(") " + node.getAliasName()));
    }

    public void _asString(SqlQuery node, IndentedWriter writer) {
        if (node.getAliasName() == null) {
            writer.print((Object)node.getQueryString());
        } else {
            writer.print((Object)("(" + node.getQueryString() + ") " + node.getAliasName()));
        }
    }

    public static void groupBy(Var var, SqlNodeOld target, SqlNodeOld node, Generator generator) {
        Collection tmp = node.getSparqlVarToExprs().get((Object)var);
        if (tmp.size() <= 1) {
            return;
        }
        ArrayList defs = new ArrayList(tmp);
        Collections.sort(defs, new Comparator<VarDef>(){

            @Override
            public int compare(VarDef arg0, VarDef arg1) {
                return arg1.getExpr().getVarsMentioned().size() - arg1.getExpr().getVarsMentioned().size();
            }
        });
        NodeExprSubstitutor substitutor = SqlNodeBinding.createSubstitutor(node.getAliasToColumn());
        ArrayList<Expr> newArgs = new ArrayList<Expr>();
        for (int i = 0; i < 4; ++i) {
            ArrayList<SqlExpr> columnDeps = new ArrayList<SqlExpr>();
            String datatype = i == 0 ? "::int" : "::text";
            ArrayList<String> exprStrs = new ArrayList<String>();
            for (VarDef def : defs) {
                Expr e = def.getExpr();
                E_RdfTerm args = (E_RdfTerm)e;
                Expr arg = (Expr)args.getArgs().get(i);
                SqlExpr sqlExpr = SqlNodeBinding.forcePushDown(arg, substitutor);
                Factory1<String> formatter = castFactory.formatString(sqlExpr.getDatatype());
                String exprStr = sqlExprSerializer.serialize(sqlExpr);
                exprStr = formatter.create(exprStr);
                exprStrs.add(exprStr);
            }
            String replacement = "";
            String caseStr = "CASE\n";
            String elseStr = "NULL" + datatype;
            for (int j = 0; j < defs.size(); ++j) {
                VarDef def = (VarDef)defs.get(j);
                Expr expr = def.getExpr();
                String exprStr = (String)exprStrs.get(j);
                if (expr.getVarsMentioned().isEmpty()) {
                    elseStr = exprStr;
                    continue;
                }
                ArrayList<String> columnNames = new ArrayList<String>();
                for (Var v : expr.getVarsMentioned()) {
                    String depName = v.getName();
                    SqlExpr depSqlExpr = node.getAliasToColumn().get(depName);
                    SqlDatatype depDatatype = depSqlExpr.getDatatype();
                    columnDeps.add(new SqlExprColumn(target.getAliasName(), depName, depDatatype));
                    columnNames.add(target.getAliasName() + "." + v.getName() + " IS NOT NULL");
                }
                caseStr = caseStr + "    WHEN (" + Joiner.on((String)" AND ").join(columnNames) + ") THEN " + "(" + exprStr + ")" + datatype + "\n";
            }
            caseStr = caseStr + "    ELSE " + elseStr + "\n";
            replacement = caseStr = caseStr + "END ";
            String columnAlias = generator.next();
            newArgs.add((Expr)new ExprVar(columnAlias));
            S_String c = new S_String(replacement, DatatypeSystemDefault._STRING, columnDeps);
            target.getAliasToColumn().put(columnAlias, c);
        }
        E_RdfTerm replacement = new E_RdfTerm(newArgs);
        target.getSparqlVarToExprs().removeAll((Object)var);
        target.getSparqlVarToExprs().put((Object)var, (Object)new VarDef((Expr)replacement));
    }

    public static String getAliasName(SqlNodeOld node) {
        if (node.getAliasName() == null || node.getAliasName().isEmpty()) {
            return "";
        }
        return " " + node.getAliasName();
    }

    public void _asString(SqlSelectBlock node, IndentedWriter writer) {
        boolean isUnion;
        writer.print((Object)"SELECT ");
        if (node.isDistinct()) {
            writer.print((Object)"DISTINCT ");
        }
        writer.println((Object)SqlAlgebraToString.projection(node.getAliasToColumn()));
        writer.println((Object)"FROM");
        boolean bl = isUnion = node.getSubNode() instanceof SqlUnionN || node.getSubNode() instanceof SqlSelectBlock;
        if (isUnion) {
            writer.print((Object)"(");
        }
        writer.incIndent();
        this.asString(node.getSubNode(), writer);
        writer.decIndent();
        if (isUnion) {
            writer.print((Object)(") " + SqlAlgebraToString.getAliasName(node)));
        }
        if (!writer.atLineStart()) {
            writer.println();
        }
        ArrayList<String> strs = new ArrayList<String>();
        for (SqlExpr expr : node.getConditions()) {
            String str = sqlExprSerializer.serialize(expr);
            strs.add(str);
        }
        if (!strs.isEmpty()) {
            writer.print((Object)"WHERE ");
        }
        writer.println((Object)Joiner.on((String)" AND ").join(strs));
        ArrayList<String> sortColumnExprStrs = new ArrayList<String>();
        for (SqlSortCondition condition : node.getSortConditions()) {
            String dirStr = null;
            if (condition.getDirection() == 1) {
                dirStr = "ASC";
            } else if (condition.getDirection() == -1) {
                dirStr = "DESC";
            }
            String exprStr = sqlExprSerializer.serialize(condition.getExpression());
            if (dirStr != null) {
                exprStr = exprStr + " " + dirStr;
            }
            sortColumnExprStrs.add(exprStr);
        }
        String orderStr = "";
        if (!sortColumnExprStrs.isEmpty()) {
            orderStr = "ORDER BY " + Joiner.on((String)", ").join(sortColumnExprStrs);
            writer.println((Object)orderStr);
        }
        if (node.getLimit() != null) {
            writer.println((Object)("LIMIT " + node.getLimit()));
        }
        String offsetStr = "";
        if (node.getOffset() != null) {
            writer.println((Object)("OFFSET " + node.getOffset()));
        }
    }

    public void _asString(SqlUnion node, IndentedWriter writer) {
        throw new RuntimeException("SqlUnion is deprecated. Use SqlUnionN instead.");
    }

    public void _asString(SqlUnionN node, IndentedWriter writer) {
        writer.incIndent();
        ArrayList parts = new ArrayList();
        for (int i = 0; i < node.getArgs().size(); ++i) {
            SqlNodeOld arg = node.getArgs().get(i);
            writer.incIndent();
            this.asString(arg, writer);
            writer.decIndent();
            if (i == node.getArgs().size() - 1) continue;
            writer.println((Object)"UNION ALL");
        }
        writer.decIndent();
    }

    public void asStringJoinU(SqlNodeOld node, String aliasName, IndentedWriter writer) {
        this.asString(node, writer);
    }

    public void _asString(SqlJoin node, IndentedWriter writer) {
        this.asStringJoinU(node.getLeft(), node.getLeft().getAliasName(), writer);
        writer.println();
        String joinOp = "";
        if (node.getJoinType().equals((Object)JoinType.INNER)) {
            joinOp = "JOIN ";
        } else if (node.getJoinType().equals((Object)JoinType.LEFT)) {
            joinOp = "LEFT JOIN ";
        } else {
            throw new RuntimeException("Join type not supported");
        }
        writer.print((Object)joinOp);
        this.asStringJoinU(node.getRight(), node.getRight().getAliasName(), writer);
        String restrictionStr = "";
        ArrayList<String> strs = new ArrayList<String>();
        for (SqlExpr expr : node.getConditions()) {
            strs.add(sqlExprSerializer.serialize(expr));
        }
        restrictionStr = Joiner.on((String)" AND ").join(strs);
        restrictionStr = !restrictionStr.isEmpty() ? " ON (" + restrictionStr + ")" : " ON (TRUE)";
        writer.println((Object)restrictionStr);
    }

    public static void _asString(SqlTable node, IndentedWriter writer) {
        String encTableName = "\"" + node.getTableName() + "\"";
        writer.print((Object)encTableName);
        writer.print((Object)SqlAlgebraToString.getAliasName(node));
    }
}

