/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.algebra.sql.nodes;

import com.hp.hpl.jena.sdb.core.Generator;
import com.hp.hpl.jena.sdb.core.Gensym;
import com.hp.hpl.jena.sdb.core.ScopeBase;
import com.hp.hpl.jena.sdb.shared.SDBInternalError;
import com.hp.hpl.jena.sparql.core.Var;
import java.util.ArrayList;
import java.util.List;
import org.aksw.sparqlify.algebra.sql.exprs.SqlExprList;
import org.aksw.sparqlify.algebra.sql.exprs.SqlSortCondition;
import org.aksw.sparqlify.algebra.sql.nodes.SqlNodeBase1;
import org.aksw.sparqlify.algebra.sql.nodes.SqlNodeOld;
import org.aksw.sparqlify.algebra.sql.nodes.SqlTable;

public class SqlSelectBlock
extends SqlNodeBase1 {
    public static final Long NOT_SET = null;
    private boolean isLocked = false;
    private List<Var> order;
    private SqlExprList conditions = new SqlExprList();
    private Long offset = null;
    private Long limit = null;
    private boolean distinct = false;
    private List<SqlSortCondition> sortConditions = new ArrayList<SqlSortCondition>();
    private SqlTable vTable;

    public void setLock(boolean isLocked) {
        this.isLocked = isLocked;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public SqlSelectBlock(SqlNodeOld node) {
        this(node.getAliasName(), node);
    }

    public SqlSelectBlock(String aliasName, SqlNodeOld sqlNode) {
        super(aliasName, sqlNode);
    }

    public void setAliasName(String name) {
        this.aliasName = name;
    }

    public void setSubNode(SqlNodeOld subNode) {
        if (this.subNode != null) {
            throw new RuntimeException("Child already set");
        }
        this.subNode = subNode;
    }

    public SqlExprList getConditions() {
        return this.conditions;
    }

    public Long getOffset() {
        return this.offset;
    }

    public Long getLimit() {
        return this.limit;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setOffset(Long offset) {
        this.offset = offset;
    }

    public void setLimit(Long limit) {
        this.limit = limit;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public List<SqlSortCondition> getSortConditions() {
        return this.sortConditions;
    }

    @Override
    public SqlSelectBlock copy1(SqlNodeOld subNode) {
        return new SqlSelectBlock(this.getAliasName(), subNode);
    }

    public static SqlNodeOld distinct(Generator generator, SqlNodeOld sqlNode) {
        SqlSelectBlock block = SqlSelectBlock.blockWithView(generator, sqlNode);
        block.setDistinct(true);
        return block;
    }

    public static SqlNodeOld restrict(Generator generator, SqlNodeOld sqlNode, SqlExprList exprs) {
        if (exprs.size() == 0) {
            return sqlNode;
        }
        SqlSelectBlock block = sqlNode instanceof SqlTable ? SqlSelectBlock.blockPlain(generator, sqlNode) : SqlSelectBlock.blockWithView(generator, sqlNode);
        block.getConditions().addAll(exprs);
        return block;
    }

    private static SqlSelectBlock _create(SqlNodeOld sqlNode, Generator generator) {
        String alias = sqlNode.getAliasName();
        alias = generator.next();
        SqlSelectBlock block = new SqlSelectBlock(alias, sqlNode);
        return block;
    }

    public static void order(Generator generator, SqlSelectBlock block, List<SqlSortCondition> conditions) {
        block.getSortConditions().addAll(conditions);
    }

    public static void distinct(Generator generator, SqlSelectBlock block) {
        block.setDistinct(true);
    }

    public static void slice(Generator generator, SqlSelectBlock block, Long start, Long length) {
        if (start != null && start >= 0L) {
            if (block.getOffset() != null && block.getOffset() > 0L) {
                start = start + block.getOffset();
            }
            block.setOffset(start);
        }
        if (length != null && length >= 0L) {
            if (block.getLimit() != null && block.getLimit() >= 0L) {
                length = Math.min(length, block.getLimit());
            }
            block.setLimit(length);
        }
    }

    private static SqlSelectBlock blockPlain(Generator generator, SqlNodeOld sqlNode) {
        if (sqlNode instanceof SqlSelectBlock) {
            return (SqlSelectBlock)sqlNode;
        }
        SqlSelectBlock block = new SqlSelectBlock(sqlNode.getAliasName(), sqlNode);
        return block;
    }

    private static SqlSelectBlock blockWithView(Generator generator, SqlNodeOld sqlNode) {
        if (sqlNode instanceof SqlSelectBlock) {
            SqlSelectBlock block = (SqlSelectBlock)sqlNode;
            if (block.getAliasToColumn().size() == 0) {
                SqlSelectBlock.calcView(block);
            }
            return (SqlSelectBlock)sqlNode;
        }
        SqlSelectBlock block = SqlSelectBlock._create(sqlNode, generator);
        if (block.getAliasToColumn().size() != 0) {
            throw new SDBInternalError("Can't set a view on Select block which is already had columns set");
        }
        SqlSelectBlock.calcView(block);
        return block;
    }

    private static SqlSelectBlock blockNoView(Generator generator, SqlNodeOld sqlNode) {
        if (sqlNode instanceof SqlSelectBlock) {
            return (SqlSelectBlock)sqlNode;
        }
        return SqlSelectBlock._create(sqlNode, generator);
    }

    private static void calcView(SqlSelectBlock block) {
        SqlNodeOld sqlNode = block.getSubNode();
        ScopeBase idScopeRename = new ScopeBase();
        ScopeBase nodeScopeRename = new ScopeBase();
        Gensym gen = Gensym.create((String)"X");
    }
}

