/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.algebra.sql.nodes;

import com.hp.hpl.jena.sdb.core.Generator;
import com.hp.hpl.jena.sdb.core.Gensym;
import com.hp.hpl.jena.sdb.core.ScopeBase;
import com.hp.hpl.jena.sdb.shared.SDBInternalError;
import java.util.ArrayList;
import java.util.List;
import org.aksw.sparqlify.algebra.sql.exprs2.SqlExpr;
import org.aksw.sparqlify.algebra.sql.nodes.Projection;
import org.aksw.sparqlify.algebra.sql.nodes.Schema;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOp;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpBase1;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpQuery;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpTable;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpUnionN;
import org.aksw.sparqlify.algebra.sql.nodes.SqlSortCondition;
import org.aksw.sparqlify.algebra.sql.nodes.SqlTable;
import org.apache.jena.atlas.io.IndentedWriter;

public class SqlOpSelectBlock
extends SqlOpBase1 {
    public static final Long NOT_SET = null;
    private boolean isLocked = false;
    private String aliasName;
    private Projection projection = new Projection();
    private List<SqlExpr> conditions = new ArrayList<SqlExpr>();
    private Long offset = null;
    private Long limit = null;
    private boolean distinct = false;
    private List<SqlExpr> groupByExprs = new ArrayList<SqlExpr>();
    private List<SqlSortCondition> sortConditions = new ArrayList<SqlSortCondition>();
    private SqlTable vTable;

    public void setLock(boolean isLocked) {
        this.isLocked = isLocked;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public SqlOpSelectBlock(SqlOp node) {
        this(node.getSchema(), node);
    }

    public SqlOpSelectBlock(Schema schema, SqlOp sqlOp) {
        super(schema, sqlOp);
    }

    public SqlOpSelectBlock(Schema schema, SqlOp sqlOp, String aliasName) {
        super(schema, sqlOp);
        this.aliasName = aliasName;
    }

    public void setAliasName(String aliasName) {
        this.aliasName = aliasName;
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public void setSubOp(SqlOp subOp) {
        this.subOp = subOp;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public List<SqlExpr> getConditions() {
        return this.conditions;
    }

    public Long getOffset() {
        return this.offset;
    }

    public Long getLimit() {
        return this.limit;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setOffset(Long offset) {
        this.offset = offset;
    }

    public void setLimit(Long limit) {
        this.limit = limit;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public List<SqlExpr> getGroupByExprs() {
        return this.groupByExprs;
    }

    public List<SqlSortCondition> getSortConditions() {
        return this.sortConditions;
    }

    public SqlOpSelectBlock copy1(SqlOp subOp) {
        return SqlOpSelectBlock.create(subOp, this.getAliasName());
    }

    public static SqlOp distinct(Generator generator, SqlOp sqlOp) {
        SqlOpSelectBlock block = SqlOpSelectBlock.blockWithView(generator, sqlOp);
        block.setDistinct(true);
        return block;
    }

    public static SqlOp restrict(Generator generator, SqlOp sqlOp, List<SqlExpr> exprs) {
        if (exprs.size() == 0) {
            return sqlOp;
        }
        SqlOpSelectBlock block = sqlOp instanceof SqlOpTable ? SqlOpSelectBlock.blockPlain(generator, sqlOp) : SqlOpSelectBlock.blockWithView(generator, sqlOp);
        block.getConditions().addAll(exprs);
        return block;
    }

    private static SqlOpSelectBlock _create(SqlOp sqlOp, Generator generator) {
        String alias = SqlOpSelectBlock.getAliasName(sqlOp);
        alias = generator.next();
        SqlOpSelectBlock block = SqlOpSelectBlock.create(sqlOp, alias);
        return block;
    }

    public static void order(Generator generator, SqlOpSelectBlock block, List<SqlSortCondition> conditions) {
        block.getSortConditions().addAll(conditions);
    }

    public static void distinct(Generator generator, SqlOpSelectBlock block) {
        block.setDistinct(true);
    }

    public static void slice(SqlOpSelectBlock block, Long start, Long length) {
        if (start != null && start >= 0L) {
            if (block.getOffset() != null && block.getOffset() > 0L) {
                start = start + block.getOffset();
            }
            block.setOffset(start);
        }
        if (length != null && length >= 0L) {
            if (block.getLimit() != null && block.getLimit() >= 0L) {
                length = Math.min(length, block.getLimit());
            }
            block.setLimit(length);
        }
    }

    public static SqlOpSelectBlock create() {
        return new SqlOpSelectBlock(null, null);
    }

    public static SqlOpSelectBlock create(SqlOp sqlOp) {
        SqlOpSelectBlock result = SqlOpSelectBlock.create(sqlOp, null);
        return result;
    }

    public static SqlOpSelectBlock create(SqlOp sqlOp, String aliasName) {
        SqlOpSelectBlock result = new SqlOpSelectBlock(sqlOp.getSchema(), sqlOp, aliasName);
        return result;
    }

    public static String getAliasName(SqlOp op) {
        if (op instanceof SqlOpTable) {
            return ((SqlOpTable)op).getAliasName();
        }
        if (op instanceof SqlOpQuery) {
            return ((SqlOpQuery)op).getAliasName();
        }
        if (op instanceof SqlOpSelectBlock) {
            return ((SqlOpSelectBlock)op).getAliasName();
        }
        if (op instanceof SqlOpUnionN) {
            return ((SqlOpUnionN)op).getAliasName();
        }
        return null;
    }

    private static SqlOpSelectBlock blockPlain(Generator generator, SqlOp sqlOp) {
        if (sqlOp instanceof SqlOpSelectBlock) {
            return (SqlOpSelectBlock)sqlOp;
        }
        SqlOpSelectBlock block = SqlOpSelectBlock.create(sqlOp, SqlOpSelectBlock.getAliasName(sqlOp));
        return block;
    }

    private static SqlOpSelectBlock blockWithView(Generator generator, SqlOp sqlOp) {
        if (sqlOp instanceof SqlOpSelectBlock) {
            SqlOpSelectBlock block = (SqlOpSelectBlock)sqlOp;
            if (block.getSchema().getColumnCount() == 0) {
                SqlOpSelectBlock.calcView(block);
            }
            return (SqlOpSelectBlock)sqlOp;
        }
        SqlOpSelectBlock blk = SqlOpSelectBlock._create(sqlOp, generator);
        if (blk.getSchema().getColumnCount() != 0) {
            throw new SDBInternalError("Can't set a view on Select block which is already had columns set");
        }
        SqlOpSelectBlock.calcView(blk);
        return blk;
    }

    private static SqlOpSelectBlock blockNoView(Generator generator, SqlOp sqlOp) {
        if (sqlOp instanceof SqlOpSelectBlock) {
            return (SqlOpSelectBlock)sqlOp;
        }
        return SqlOpSelectBlock._create(sqlOp, generator);
    }

    private static void calcView(SqlOpSelectBlock block) {
        SqlOp sqlOp = block.getSubOp();
        ScopeBase idScopeRename = new ScopeBase();
        ScopeBase nodeScopeRename = new ScopeBase();
        Gensym gen = Gensym.create((String)"X");
    }

    @Override
    public void write(IndentedWriter writer) {
        String aliasPart = this.aliasName == null ? " anonymous" : " AS " + this.aliasName;
        String schemaStr = this.schema == null ? "null schema" : "" + this.schema.getColumnNames();
        writer.println((Object)("SqlOpSelectBlock" + aliasPart + "(" + schemaStr));
        writer.incIndent();
        writer.println((Object)("Where: " + this.conditions));
        writer.println((Object)("Limit: " + this.limit + ", Offset: " + this.offset));
        writer.println((Object)"From:");
        writer.incIndent();
        if (this.subOp == null) {
            writer.print((Object)"No SubOp");
        } else {
            this.subOp.write(writer);
        }
        writer.println();
        writer.decIndent();
        writer.print((Object)")");
        writer.decIndent();
    }
}

