/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.algebra.sql.nodes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.aksw.sparqlify.algebra.sql.nodes.Schema;
import org.aksw.sparqlify.algebra.sql.nodes.SchemaImpl;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOp;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpBase1;
import org.aksw.sparqlify.core.TypeToken;
import org.apache.commons.collections15.BidiMap;
import org.apache.commons.collections15.bidimap.DualHashBidiMap;
import org.apache.jena.atlas.io.IndentedWriter;

public class SqlOpRename
extends SqlOpBase1 {
    private BidiMap<String, String> rename;

    public SqlOpRename(Schema schema, SqlOp subOp, BidiMap<String, String> rename) {
        super(schema, subOp);
        this.rename = rename;
    }

    public BidiMap<String, String> getRename() {
        return this.rename;
    }

    public static SqlOpRename create(SqlOp op, Map<String, String> map) {
        DualHashBidiMap rename = new DualHashBidiMap(map);
        Schema oldSchema = op.getSchema();
        ArrayList<String> newNames = new ArrayList<String>();
        HashMap<String, TypeToken> newTypeMap = new HashMap<String, TypeToken>();
        for (String oldName : oldSchema.getColumnNames()) {
            TypeToken datatype = oldSchema.getColumnType(oldName);
            String newName = (String)rename.get((Object)oldName);
            if (newName == null) {
                newName = oldName;
            }
            newNames.add(newName);
            newTypeMap.put(newName, datatype);
        }
        SchemaImpl newSchema = SchemaImpl.create(newNames, newTypeMap);
        SqlOpRename result = new SqlOpRename(newSchema, op, (BidiMap<String, String>)rename);
        return result;
    }

    @Override
    public void write(IndentedWriter writer) {
        writer.println((Object)("SqlOpRename" + this.rename + "("));
        writer.incIndent();
        this.subOp.write(writer);
        writer.println();
        writer.decIndent();
        writer.print((Object)")");
    }
}

