/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.algebra.sql.nodes;

import java.util.List;
import org.aksw.sparqlify.algebra.sql.nodes.Schema;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOp;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpLeaf;
import org.apache.jena.atlas.io.IndentedWriter;

public class SqlOpQuery
extends SqlOpLeaf {
    private String queryString;

    public SqlOpQuery(Schema schema, String queryString) {
        this(schema, queryString, null);
    }

    public SqlOpQuery(Schema schema, String queryString, String aliasName) {
        this(schema, queryString, aliasName, false);
    }

    public SqlOpQuery(Schema schema, String queryString, String aliasName, boolean isEmpty) {
        super(schema, isEmpty, aliasName);
        this.queryString = queryString;
    }

    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public void write(IndentedWriter writer) {
        String aliasPart = this.aliasName == null ? "" : " AS '" + this.aliasName + "'";
        writer.println((Object)("SqlOpQuery[" + this.queryString + aliasPart + "]"));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.aliasName == null ? 0 : this.aliasName.hashCode());
        result = 31 * result + (this.queryString == null ? 0 : this.queryString.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SqlOpQuery other = (SqlOpQuery)obj;
        if (this.aliasName == null ? other.aliasName != null : !this.aliasName.equals(other.aliasName)) {
            return false;
        }
        return !(this.queryString == null ? other.queryString != null : !this.queryString.equals(other.queryString));
    }

    @Override
    public String getId() {
        return this.queryString;
    }

    @Override
    public SqlOp copy(Schema schema, List<SqlOp> newArgs) {
        SqlOpQuery result = new SqlOpQuery(schema, this.queryString, this.aliasName);
        return result;
    }
}

