/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.algebra.sql.nodes;

import java.util.HashMap;
import java.util.Map;
import org.aksw.sparqlify.algebra.sql.exprs2.SqlExpr;
import org.aksw.sparqlify.algebra.sql.nodes.Projection;
import org.aksw.sparqlify.algebra.sql.nodes.Schema;
import org.aksw.sparqlify.algebra.sql.nodes.SchemaImpl;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOp;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpBase1;
import org.aksw.sparqlify.core.TypeToken;
import org.apache.jena.atlas.io.IndentedWriter;

public class SqlOpExtend
extends SqlOpBase1 {
    private Projection projection;

    public SqlOpExtend(Schema schema, SqlOp subOp, Projection projection) {
        super(schema, subOp);
        this.projection = projection;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public static Map<String, TypeToken> extractExtendedTypeMap(Map<String, SqlExpr> nameToExpr, Map<String, TypeToken> baseTypeMap) {
        HashMap<String, TypeToken> result = new HashMap<String, TypeToken>();
        for (Map.Entry<String, SqlExpr> entry : nameToExpr.entrySet()) {
            SqlExpr expr = entry.getValue();
            TypeToken datatype = expr.getDatatype();
            if (datatype == null) {
                System.err.println("Could not determine datatype for: " + expr);
            }
            result.put(entry.getKey(), datatype);
        }
        return result;
    }

    public static Map<String, TypeToken> extractExtendedTypeMap(Map<String, SqlExpr> nameToExpr) {
        HashMap<String, TypeToken> result = new HashMap<String, TypeToken>();
        for (Map.Entry<String, SqlExpr> entry : nameToExpr.entrySet()) {
            TypeToken typeName = entry.getValue().getDatatype();
            result.put(entry.getKey(), typeName);
        }
        return result;
    }

    public static SqlOpExtend create(SqlOp op, Projection projection) {
        SchemaImpl schema = new SchemaImpl();
        schema.getColumnNames().addAll(op.getSchema().getColumnNames());
        schema.getColumnNames().addAll(projection.getNames());
        Map<String, TypeToken> typeMap = SqlOpExtend.extractExtendedTypeMap(projection.getNameToExpr(), op.getSchema().getTypeMap());
        schema.getTypeMap().putAll(op.getSchema().getTypeMap());
        schema.getTypeMap().putAll(typeMap);
        return new SqlOpExtend(schema, op, projection);
    }

    @Override
    public void write(IndentedWriter writer) {
        writer.println((Object)("SqlOpExtend " + this.projection + "("));
        writer.incIndent();
        this.subOp.write(writer);
        writer.println();
        writer.decIndent();
        writer.print((Object)")");
    }
}

