/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.algebra.sql.nodes;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.hp.hpl.jena.sparql.core.Var;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.aksw.sparqlify.algebra.sql.exprs.SqlExpr;
import org.aksw.sparqlify.algebra.sql.nodes.SqlNodeOld;
import org.aksw.sparqlify.algebra.sql.nodes.VarDef;
import org.aksw.sparqlify.core.ConstraintContainer;
import org.apache.jena.atlas.io.IndentedWriter;

public abstract class SqlNodeBase
implements SqlNodeOld {
    protected String aliasName;
    private Multimap<Var, VarDef> sparqlVarToExpr = HashMultimap.create();
    private Map<String, SqlExpr> aliasToColumn = new HashMap<String, SqlExpr>();
    private ConstraintContainer constraints;

    @Override
    public ConstraintContainer getConstraints() {
        return this.constraints;
    }

    @Override
    public Map<String, SqlExpr> getAliasToColumn() {
        return this.aliasToColumn;
    }

    public SqlNodeBase(String aliasName) {
        this.aliasName = aliasName;
    }

    @Override
    public Multimap<Var, VarDef> getSparqlVarToExprs() {
        return this.sparqlVarToExpr;
    }

    @Override
    public Set<Var> getSparqlVarsMentioned() {
        return this.sparqlVarToExpr.keySet();
    }

    @Override
    public String getAliasName() {
        return this.aliasName;
    }

    public String toString() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IndentedWriter writer = new IndentedWriter((OutputStream)out);
        this.write(writer);
        return out.toString();
    }

    @Override
    public void write(IndentedWriter writer) {
        writer.println((Object)("(" + this.getClass().getSimpleName()));
        writer.incIndent();
        for (SqlNodeOld arg : this.getArgs()) {
            arg.write(writer);
        }
        writer.decIndent();
        writer.println((Object)(") " + this.getAliasName()));
    }
}

