/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.algebra.sparql.transform;

import com.google.common.base.Joiner;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.expr.E_Function;
import com.hp.hpl.jena.sparql.expr.E_StrDatatype;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.vocabulary.XSD;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aksw.commons.util.reflect.MultiMethod;
import org.aksw.sparqlify.algebra.sparql.expr.old.E_GenericSqlExpr;
import org.aksw.sparqlify.algebra.sparql.expr.old.E_GeographyFromText;
import org.aksw.sparqlify.algebra.sparql.expr.old.E_GeomFromText;
import org.aksw.sparqlify.algebra.sparql.expr.old.E_Intersects;
import org.aksw.sparqlify.algebra.sparql.transform.GenericSqlFunctionDefinition;
import org.aksw.sparqlify.algebra.sparql.transform.IFactoryN;
import org.aksw.sparqlify.algebra.sparql.transform.SqlFunctionDefinition;
import org.aksw.sparqlify.algebra.sql.exprs.S_Function;
import org.aksw.sparqlify.algebra.sql.exprs.SqlStringTransformer;
import org.aksw.sparqlify.core.DatatypeSystemDefault;
import org.aksw.sparqlify.core.DatatypeSystemOld;
import org.aksw.sparqlify.trash.ExprCopy;

public class FunctionExpander {
    private static Map<String, IFactoryN<Expr>> map = new HashMap<String, IFactoryN<Expr>>();

    public static void registerFunction(DatatypeSystemOld datatypeSystem, String funcName, String sparqlFuncName, SqlStringTransformer transformer, String returnType, boolean isVararg, String ... paramTypes) {
        final GenericSqlFunctionDefinition funcDef = new GenericSqlFunctionDefinition(funcName, datatypeSystem);
        funcDef.add(transformer, returnType, isVararg, paramTypes);
        map.put(sparqlFuncName, new IFactoryN<Expr>(){

            @Override
            public Expr create(ExprList args) {
                return new E_GenericSqlExpr((SqlFunctionDefinition)funcDef, args);
            }
        });
    }

    public static Expr transform(Expr expr) {
        return expr == null ? null : (Expr)MultiMethod.invokeStatic(FunctionExpander.class, (String)"_transform", (Object[])new Object[]{expr});
    }

    public static Expr _transform(E_Function expr) {
        ExprList args = FunctionExpander.transformList(expr.getArgs());
        IFactoryN<Expr> factory = map.get(expr.getFunctionIRI());
        if (factory == null) {
            throw new RuntimeException("No algebra-class factory registered for function '" + expr.getFunctionIRI() + "'");
        }
        Expr result = factory.create(args);
        return result;
    }

    public static Expr _transform(ExprFunction expr) {
        Expr result;
        ExprList args = FunctionExpander.transformList(expr.getArgs());
        if (expr instanceof E_Function) {
            IFactoryN<Expr> factory = map.get(expr.getFunctionIRI());
            if (factory == null) {
                throw new RuntimeException("No algebra-class factory registered for function '" + expr.getFunctionIRI() + "'");
            }
            result = factory.create(args);
        } else {
            result = ExprCopy.getInstance().copy((Expr)expr, args);
        }
        return result;
    }

    protected static ExprList transformList(Iterable<Expr> exprs) {
        ExprList result = new ExprList();
        for (Expr expr : exprs) {
            result.add(FunctionExpander.transform(expr));
        }
        return result;
    }

    public static Expr _transform(Expr expr) {
        return expr;
    }

    static {
        map.put("http://www.opengis.net/ont/geosparql#intersects", new IFactoryN<Expr>(){

            @Override
            public Expr create(ExprList args) {
                return new E_Intersects(args.get(0), args.get(1));
            }
        });
        map.put("http://www.opengis.net/ont/geosparql#geomFromText", new IFactoryN<Expr>(){

            @Override
            public Expr create(ExprList args) {
                return new E_GeomFromText(args.get(0));
            }
        });
        map.put("http://www.opengis.net/ont/geosparql#geographyFromText", new IFactoryN<Expr>(){

            @Override
            public Expr create(ExprList args) {
                return new E_GeographyFromText(args.get(0));
            }
        });
        map.put("http://www.w3.org/2001/XMLSchema#double", new IFactoryN<Expr>(){

            @Override
            public Expr create(ExprList args) {
                return new E_StrDatatype(args.get(0), (Expr)NodeValue.makeNode((Node)XSD.xdouble.asNode()));
            }
        });
        DatatypeSystemDefault datatypeSystem = new DatatypeSystemDefault();
        final GenericSqlFunctionDefinition ST_DWithin = new GenericSqlFunctionDefinition("ST_DWithin", datatypeSystem);
        ST_DWithin.add(new SqlStringTransformer(){

            @Override
            public String transform(S_Function function, List<String> args) {
                ArrayList<String> tmp = new ArrayList<String>(args);
                tmp.set(2, "(" + (String)tmp.get(2) + ")" + " * 1000.0");
                tmp.add("false");
                return function.getFuncName() + "(" + Joiner.on((String)", ").join(tmp) + ")";
            }
        }, "boolean", false, "geography", "geography", "float");
        String bifNs = "http://www.openlinksw.com/schemas/bif#";
        map.put(bifNs + "st_intersects", new IFactoryN<Expr>(){

            @Override
            public Expr create(ExprList args) {
                return new E_GenericSqlExpr((SqlFunctionDefinition)ST_DWithin, args);
            }
        });
        final GenericSqlFunctionDefinition ST_MakePoint = new GenericSqlFunctionDefinition("ST_MakePoint", datatypeSystem);
        ST_MakePoint.add(new SqlStringTransformer(){

            @Override
            public String transform(S_Function function, List<String> args) {
                return function.getFuncName() + "(" + Joiner.on((String)", ").join(args) + ")::geography";
            }
        }, "geography", false, "double", "double");
        map.put(bifNs + "st_point", new IFactoryN<Expr>(){

            @Override
            public Expr create(ExprList args) {
                return new E_GenericSqlExpr((SqlFunctionDefinition)ST_MakePoint, args);
            }
        });
        SqlStringTransformer pointExtractor = new SqlStringTransformer(){

            @Override
            public String transform(S_Function function, List<String> args) {
                return function.getFuncName() + "(" + args.get(0) + "::geometry)";
            }
        };
        FunctionExpander.registerFunction(datatypeSystem, "ST_X", bifNs + "st_x", pointExtractor, "double", false, "geography");
        FunctionExpander.registerFunction(datatypeSystem, "ST_Y", bifNs + "st_y", pointExtractor, "double", false, "geography");
        ST_DWithin = new GenericSqlFunctionDefinition("ST_DWithin", datatypeSystem);
        ST_DWithin.add(new SqlStringTransformer(){

            @Override
            public String transform(S_Function function, List<String> args) {
                ArrayList<String> tmp = new ArrayList<String>(args);
                return function.getFuncName() + "(" + Joiner.on((String)", ").join(tmp) + ")";
            }
        }, "boolean", false, "geometry", "geometry", "float");
        bifNs = "http://www.openlinksw.com/schemas/bif#";
        map.put(bifNs + "st_intersects", new IFactoryN<Expr>(){

            @Override
            public Expr create(ExprList args) {
                return new E_GenericSqlExpr((SqlFunctionDefinition)ST_DWithin, args);
            }
        });
        ST_MakePoint = new GenericSqlFunctionDefinition("ST_MakePoint", datatypeSystem);
        ST_MakePoint.add(new SqlStringTransformer(){

            @Override
            public String transform(S_Function function, List<String> args) {
                return "ST_SetSRID(" + function.getFuncName() + "(" + Joiner.on((String)", ").join(args) + ")::geometry" + ", 4326)";
            }
        }, "geometry", false, "double", "double");
        map.put(bifNs + "st_point", new IFactoryN<Expr>(){

            @Override
            public Expr create(ExprList args) {
                return new E_GenericSqlExpr((SqlFunctionDefinition)ST_MakePoint, args);
            }
        });
        pointExtractor = new SqlStringTransformer(){

            @Override
            public String transform(S_Function function, List<String> args) {
                return function.getFuncName() + "(" + args.get(0) + "::geometry)";
            }
        };
        FunctionExpander.registerFunction(datatypeSystem, "ST_X", bifNs + "st_x", pointExtractor, "double", false, "geometry");
        FunctionExpander.registerFunction(datatypeSystem, "ST_Y", bifNs + "st_y", pointExtractor, "double", false, "geometry");
    }
}

