/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.update;

import com.google.common.base.Joiner;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.resultset.ResultSetMem;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.collections.diff.HashSetDiff;
import org.aksw.jena_sparql_api.utils.QuadUtils;
import org.aksw.update.GraphListener;
import org.aksw.update.ModelSparqlEndpoint;
import org.aksw.update.QuadFilter;
import sparql.DnfUtils;
import sparql.FilterCompiler;
import sparql.FilterUtils;
import sparql.PatternUtils;
import sparql.ViewTable;

public class IncrementalQueryUpdateManager
implements GraphListener {
    Set<QuadFilter> quadFilters = new HashSet<QuadFilter>();
    private ModelSparqlEndpoint sparqlEndpoint;
    private Query query;
    HashSetDiff<Quad> diff = new HashSetDiff();
    HashSetDiff<Binding> aggregatedChanges = new HashSetDiff();

    public boolean isRelevant(Quad quad) {
        for (QuadFilter graph : this.quadFilters) {
            if (!graph.doesAccept(quad)) continue;
            return true;
        }
        return false;
    }

    public boolean doesExist(Quad quad) {
        return this.sparqlEndpoint.createQueryExecution(FilterCompiler.askForQuad(quad)).execAsk();
    }

    public ResultSet processQuads(Iterable<Quad> quads) {
        ArrayList<String> orFilters = new ArrayList<String>();
        for (Quad quad : quads) {
            for (QuadFilter graph : this.quadFilters) {
                if (!graph.doesAccept(quad)) continue;
                Map varMap = QuadUtils.getVarMapping((Quad)graph.getPattern(), (Quad)quad);
                ArrayList<String> andFilters = new ArrayList<String>();
                for (Map.Entry entry : varMap.entrySet()) {
                    String str = FilterCompiler.compileFilter((Node)entry.getValue(), "?" + ((Node)entry.getKey()).getName());
                    andFilters.add(str);
                }
                orFilters.add(Joiner.on((String)" && ").join(andFilters));
            }
        }
        if (orFilters.isEmpty()) {
            return new ResultSetMem();
        }
        String filter = FilterCompiler.wrapFilter("(" + Joiner.on((String)") || (").join(orFilters) + ")");
        String qs = this.query.toString();
        int hackPos = qs.lastIndexOf("}");
        qs = qs.substring(0, hackPos) + filter + "}";
        ResultSet rs = this.sparqlEndpoint.createQueryExecution(qs).execSelect();
        return rs;
    }

    public void removeSeen(Quad quad) {
        if (!this.isRelevant(quad)) {
            return;
        }
    }

    public void add(Quad quad) {
        if (!this.isRelevant(quad)) {
            return;
        }
        this.diff.add((Object)quad);
    }

    public static Set<Binding> resultSetToBindings(ResultSet rs) {
        HashSet<Binding> result = new HashSet<Binding>();
        while (rs.hasNext()) {
            result.add(rs.nextBinding());
        }
        return result;
    }

    public HashSetDiff<Binding> getChanges() {
        HashSetDiff result = new HashSetDiff();
        ((Set)result.getAdded()).addAll((Collection)this.aggregatedChanges.getAdded());
        ((Set)result.getRemoved()).addAll((Collection)this.aggregatedChanges.getRemoved());
        this.aggregatedChanges.clear();
        return result;
    }

    public void computeInserts() {
        System.out.println("#dirty quads: " + ((Set)this.diff.getAdded()).size());
        Set<Binding> added = IncrementalQueryUpdateManager.resultSetToBindings(this.processQuads((Iterable)this.diff.getAdded()));
        ((Set)this.diff.getAdded()).clear();
        for (Binding item : added) {
            this.aggregatedChanges.add((Object)item);
        }
    }

    public void computeDeletions() {
        System.out.println("#deletion dirty quads: " + ((Set)this.diff.getRemoved()).size());
        Set<Binding> removed = IncrementalQueryUpdateManager.resultSetToBindings(this.processQuads((Iterable)this.diff.getRemoved()));
        ((Set)this.diff.getRemoved()).clear();
        for (Binding item : removed) {
            this.aggregatedChanges.remove((Object)item);
        }
    }

    public void remove(Quad quad) {
        if (!this.isRelevant(quad)) {
            return;
        }
        this.diff.remove((Object)quad);
    }

    public IncrementalQueryUpdateManager(String queryString, ModelSparqlEndpoint sparqlEndpoint) throws SQLException {
        boolean isSatisfiable;
        this.sparqlEndpoint = sparqlEndpoint;
        this.query = QueryFactory.create((String)queryString);
        Op op = Algebra.compile((Query)this.query);
        op = Algebra.toQuadForm((Op)op);
        System.out.println(op);
        ExprList exprs = FilterUtils.collectExprs(op, new ExprList());
        Collection<Quad> quads = PatternUtils.collectQuads(op, new ArrayList<Quad>());
        List<ExprList> clauses = DnfUtils.toClauses(exprs);
        System.out.println("DNF = " + clauses);
        Set<Set<Expr>> dnf = FilterUtils.toSets(clauses);
        boolean bl = isSatisfiable = dnf == null || DnfUtils.isSatisfiable(dnf);
        if (!isSatisfiable) {
            throw new RuntimeException("The view definition was detected to not be satisfiable");
        }
        for (Quad quad : quads) {
            Set<Set<Expr>> filter = FilterUtils.determineFilterDnf(quad, dnf);
            System.out.println("For quad " + quad + " got expr " + filter);
            this.quadFilters.add(new QuadFilter(quad, filter));
        }
    }

    public static void sparqlIntoView(ModelSparqlEndpoint sparqlEndpoint, String queryString, ViewTable viewTable) throws SQLException {
        ResultSet rs = sparqlEndpoint.createQueryExecution(queryString).execSelect();
        while (rs.hasNext()) {
            Binding binding = rs.nextBinding();
            viewTable.insert(binding);
        }
    }

    @Override
    public void onPreBatchStart() {
    }

    @Override
    public void onPreInsert(Quad quad) {
        this.add(quad);
    }

    @Override
    public void onPreDelete(Quad quad) {
        this.remove(quad);
    }

    @Override
    public void onPreBatchEnd() {
        this.computeDeletions();
    }

    @Override
    public void onPostBatchStart() {
    }

    @Override
    public void onPostInsert(Quad quad) {
    }

    @Override
    public void onPostDelete(Quad quad) {
    }

    @Override
    public void onPostBatchEnd() {
        this.computeInserts();
    }
}

