/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.util;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.aksw.sparqlify.util.TransformerTrimAndToLowerCase;
import org.apache.commons.collections15.BidiMap;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.bidimap.DualHashBidiMap;

public class NormalizedMap<K, V>
extends AbstractMap<K, V> {
    private Map<K, V> map;
    private BidiMap<K, K> origToNorm;
    private Transformer<K, K> keyNormalizer;

    public NormalizedMap(Transformer<K, K> keyNormalizer) {
        this(new HashMap(), keyNormalizer);
    }

    public NormalizedMap(Map<K, V> map, Transformer<K, K> keyNormalizer) {
        this.map = map;
        this.keyNormalizer = keyNormalizer;
        this.origToNorm = new DualHashBidiMap();
    }

    @Override
    public boolean containsKey(Object key) {
        boolean result;
        try {
            Object k = key;
            Object normKey = this.keyNormalizer.transform(k);
            result = this.map.containsKey(normKey);
        }
        catch (ClassCastException e) {
            result = false;
        }
        return result;
    }

    @Override
    public V put(K key, V value) {
        Object normKey = this.keyNormalizer.transform(key);
        this.origToNorm.put(key, normKey);
        this.map.put(normKey, value);
        return value;
    }

    @Override
    public V get(Object key) {
        V result;
        try {
            Object k = key;
            Object normKey = this.keyNormalizer.transform(k);
            result = this.map.get(normKey);
        }
        catch (ClassCastException e) {
            result = null;
        }
        return result;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    public static <V> Map<String, V> createCaseInsensitiveMap() {
        TransformerTrimAndToLowerCase transformer = new TransformerTrimAndToLowerCase();
        NormalizedMap<String, V> result = new NormalizedMap<String, V>(transformer);
        return result;
    }

    public static void main(String[] args) {
        Map<String, Integer> test = NormalizedMap.createCaseInsensitiveMap();
        test.put("a", 1);
        test.put("B", 2);
        System.out.println(test.get("A"));
        System.out.println(test.get("B"));
        test.put("A", 3);
        System.out.println(test.get("a"));
    }
}

