/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.trash;

import com.hp.hpl.jena.sdb.core.Generator;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.FunctionLabel;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aksw.commons.util.reflect.MultiMethod;
import org.aksw.sparqlify.trash.ExprCopy;

public class ExprCommonFactor {
    private Generator generator;
    private Map<Var, Expr> mapA = new HashMap<Var, Expr>();
    private Map<Var, Expr> mapB = new HashMap<Var, Expr>();

    public ExprCommonFactor(Generator generator) {
        this.generator = generator;
    }

    public Expr transformMM(Expr a, Expr b) {
        return (Expr)MultiMethod.invoke((Object)this, (String)"transform", (Object[])new Object[]{a, b});
    }

    public Expr transform(Expr a, Expr b) {
        return this.transformHelper(a, b);
    }

    public Expr transformHelper(Expr a, Expr b) {
        Var var = Var.alloc((String)this.generator.next());
        ExprVar result = new ExprVar(var);
        this.mapA.put(var, a);
        this.mapB.put(var, b);
        return result;
    }

    public Expr transform(ExprFunction a, ExprFunction b) {
        if (a.getClass().equals(b.getClass()) && a.getFunctionSymbol().equals((Object)b.getFunctionSymbol()) && a.numArgs() == b.numArgs()) {
            ExprList tmp = new ExprList();
            for (int i = 0; i < a.numArgs(); ++i) {
                Expr newExpr = this.transformMM((Expr)a.getArgs().get(i), (Expr)b.getArgs().get(i));
                tmp.add(newExpr);
            }
            return ExprCopy.getInstance().copy((Expr)a, tmp);
        }
        return this.transformHelper((Expr)a, (Expr)b);
    }

    public Expr transformHelper(List<Expr> exprs, List<Map<Var, Expr>> inout) {
        Var var = Var.alloc((String)this.generator.next());
        ExprVar result = new ExprVar(var);
        for (int i = 0; i < exprs.size(); ++i) {
            inout.get(i).put(var, exprs.get(i));
        }
        return result;
    }

    public Expr transform(List<Expr> exprs, List<Map<Var, Expr>> inout) {
        if (inout.isEmpty()) {
            for (int i = 0; i < exprs.size(); ++i) {
                inout.add(new HashMap());
            }
        }
        Object proto = null;
        for (int i = 0; i < exprs.size(); ++i) {
            proto = exprs.get(i);
            if (proto != null) continue;
        }
        Class<?> clazz = proto.getClass();
        for (Expr expr : exprs) {
            if (expr.getClass().equals(clazz)) continue;
            Expr result = this.transformHelper(exprs, inout);
            return result;
        }
        if (proto instanceof ExprFunction) {
            ExprFunction protoFunc = (ExprFunction)proto;
            int numArgs = protoFunc.numArgs();
            FunctionLabel protoName = protoFunc.getFunctionSymbol();
            for (Expr expr : exprs) {
                ExprFunction tmp = (ExprFunction)expr;
                if (numArgs == tmp.numArgs() && protoName.equals((Object)tmp.getFunctionSymbol())) continue;
                Expr result = this.transformHelper(exprs, inout);
                return result;
            }
            ExprList transformedArgs = new ExprList();
            for (int i = 0; i < numArgs; ++i) {
                ArrayList<Expr> args = new ArrayList<Expr>();
                for (Expr expr : exprs) {
                    ExprFunction tmp = (ExprFunction)expr;
                    args.add((Expr)tmp.getArgs().get(i));
                }
                Expr tmp = this.transform(args, inout);
                transformedArgs.add(tmp);
            }
            Expr result = ExprCopy.getInstance().copy((Expr)protoFunc, transformedArgs);
            return result;
        }
        if (proto instanceof NodeValue) {
            for (Expr expr : exprs) {
                if (expr.equals(proto)) continue;
                Expr result = this.transformHelper(exprs, inout);
                return result;
            }
            return proto;
        }
        Expr result = this.transformHelper(exprs, inout);
        return result;
    }
}

