/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.restriction;

import com.hp.hpl.jena.graph.Node;
import com.karneim.util.collection.regex.PatternPro;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import org.aksw.sparqlify.config.lang.PrefixSet;
import org.aksw.sparqlify.restriction.RdfTermType;
import org.aksw.sparqlify.restriction.Restriction;
import org.aksw.sparqlify.restriction.TernaryLogic;
import org.apache.commons.lang.NotImplementedException;

public class RestrictionImpl
implements Restriction {
    private RdfTermType type = RdfTermType.UNKNOWN;
    private Node node;
    private PrefixSet uriPrefixes;
    private Boolean satisfiability = Boolean.TRUE;

    public boolean subsumesOrIsEqual(RestrictionImpl other) {
        if (this.type != other.type) {
            return false;
        }
        if (this.node != null) {
            if (other.node == null) {
                return false;
            }
            if (!this.node.equals((Object)other.node)) {
                return false;
            }
        }
        if (this.uriPrefixes != null) {
            if (other.node != null && this.uriPrefixes.containsPrefixOf(other.node.toString())) {
                return true;
            }
            if (other.getUriPrefixes() == null) {
                return false;
            }
            for (String prefix : other.getUriPrefixes().getSet()) {
                if (this.uriPrefixes.containsPrefixOf(prefix)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public RestrictionImpl clone() {
        return new RestrictionImpl(this);
    }

    public RestrictionImpl() {
        this.satisfiability = Boolean.TRUE;
    }

    public RestrictionImpl(RdfTermType type) {
        this.stateType(type);
    }

    public RestrictionImpl(PrefixSet prefixSet) {
        this.stateUriPrefixes(prefixSet);
    }

    public RestrictionImpl(Node node) {
        this.stateNode(node);
    }

    public RestrictionImpl(RestrictionImpl other) {
        this.type = other.type;
        this.node = other.node;
        if (other.uriPrefixes != null) {
            this.uriPrefixes = new PrefixSet(other.uriPrefixes);
        }
        this.satisfiability = other.satisfiability;
    }

    @Override
    public boolean hasConstant() {
        return this.isConsistent() && this.node != null;
    }

    public boolean hasPrefix() {
        return !this.hasConstant() && this.uriPrefixes != null;
    }

    @Deprecated
    public RdfTermType getType() {
        return this.type;
    }

    @Override
    public EnumSet<RdfTermType> getRdfTermTypes() {
        EnumSet<RdfTermType> result = EnumSet.noneOf(RdfTermType.class);
        result.add(this.type);
        return result;
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public PrefixSet getUriPrefixes() {
        return this.uriPrefixes;
    }

    @Override
    public boolean stateRestriction(Restriction that) {
        RestrictionImpl other = (RestrictionImpl)that;
        if (other.satisfiability == Boolean.TRUE) {
            return false;
        }
        this.satisfiability = TernaryLogic.and(this.satisfiability, other.satisfiability);
        if (this.satisfiability == Boolean.FALSE) {
            return false;
        }
        if (other.node != null) {
            return this.stateNode(other.node);
        }
        if (other.uriPrefixes != null) {
            return this.stateUriPrefixes(other.uriPrefixes);
        }
        if (other.getType() != RdfTermType.UNKNOWN) {
            return this.stateType(other.type);
        }
        throw new RuntimeException("Should not happen");
    }

    @Override
    public boolean stateType(RdfTermType newType) {
        if (this.satisfiability == Boolean.FALSE) {
            return false;
        }
        if (this.type == RdfTermType.UNKNOWN) {
            if (newType != RdfTermType.UNKNOWN) {
                this.type = newType;
                this.satisfiability = null;
                return true;
            }
            return false;
        }
        if (this.type.equals((Object)newType)) {
            return false;
        }
        this.satisfiability = Boolean.FALSE;
        return true;
    }

    public static RdfTermType getNodeType(Node node) {
        if (node == null) {
            return RdfTermType.UNKNOWN;
        }
        if (node.isURI()) {
            return RdfTermType.URI;
        }
        if (node.isLiteral()) {
            return RdfTermType.LITERAL;
        }
        throw new RuntimeException("Should not happen");
    }

    @Override
    public boolean stateNode(Node newNode) {
        boolean change = this.stateType(RestrictionImpl.getNodeType(newNode));
        if (this.satisfiability == Boolean.FALSE) {
            return change;
        }
        if (this.node == null) {
            if (this.uriPrefixes != null && !this.uriPrefixes.containsPrefixOf(newNode.getURI())) {
                this.satisfiability = Boolean.FALSE;
                return true;
            }
            this.node = newNode;
            this.satisfiability = null;
            return true;
        }
        if (!this.node.equals((Object)newNode)) {
            this.satisfiability = Boolean.FALSE;
            return true;
        }
        return false;
    }

    @Override
    public boolean stateUriPrefixes(PrefixSet prefixes) {
        Set<String> ps;
        if (prefixes.isEmpty()) {
            throw new RuntimeException("Should not happen");
        }
        boolean change = this.stateType(RdfTermType.URI);
        if (this.satisfiability == Boolean.FALSE) {
            return change;
        }
        if (this.node != null) {
            if (!this.node.isURI() || !prefixes.containsPrefixOf(this.node.getURI())) {
                this.satisfiability = Boolean.FALSE;
                return true;
            }
            return false;
        }
        if (this.uriPrefixes == null) {
            this.uriPrefixes = new PrefixSet();
            for (String s : prefixes.getSet()) {
                Set<String> ps2 = this.uriPrefixes.getPrefixesOf(s);
                this.uriPrefixes.removeAll(ps2);
                this.uriPrefixes.add(s);
            }
            this.satisfiability = this.uriPrefixes.isEmpty() ? Boolean.valueOf(false) : null;
            return true;
        }
        if (prefixes.isEmpty()) {
            if (this.uriPrefixes.isEmpty()) {
                this.satisfiability = Boolean.FALSE;
                return true;
            }
            return false;
        }
        for (String s : prefixes.getSet()) {
            ps = this.uriPrefixes.getPrefixesOf(s, false);
            if (ps.isEmpty()) continue;
            this.uriPrefixes.removeAll(ps);
            this.uriPrefixes.add(s);
        }
        Iterator<String> it = this.uriPrefixes.getSet().iterator();
        while (it.hasNext()) {
            String s;
            s = it.next();
            ps = prefixes.getPrefixesOf(s);
            if (!ps.isEmpty()) continue;
            it.remove();
        }
        if (this.uriPrefixes.isEmpty()) {
            this.satisfiability = Boolean.FALSE;
            return true;
        }
        return true;
    }

    @Override
    public void statePattern(PatternPro pattern) {
        throw new NotImplementedException();
    }

    public Boolean getSatisfiability() {
        return this.satisfiability;
    }

    public boolean isConsistent() {
        return this.satisfiability != Boolean.FALSE;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.node == null ? 0 : this.node.hashCode());
        result = 31 * result + (this.satisfiability == null ? 0 : this.satisfiability.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.uriPrefixes == null ? 0 : this.uriPrefixes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RestrictionImpl other = (RestrictionImpl)obj;
        if (this.node == null ? other.node != null : !this.node.equals((Object)other.node)) {
            return false;
        }
        if (this.satisfiability == null ? other.satisfiability != null : !this.satisfiability.equals(other.satisfiability)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return !(this.uriPrefixes == null ? other.uriPrefixes != null : !this.uriPrefixes.equals(other.uriPrefixes));
    }

    public String toString() {
        if (this.satisfiability != null) {
            return this.satisfiability.toString();
        }
        if (this.hasConstant()) {
            return "" + this.node;
        }
        if (this.hasPrefix()) {
            return "" + this.uriPrefixes;
        }
        if (this.type != RdfTermType.UNKNOWN) {
            return "" + (Object)((Object)this.type);
        }
        return "Invalid state";
    }

    @Override
    public boolean isUnsatisfiable() {
        return this.satisfiability == Boolean.FALSE;
    }
}

