/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.expr.util;

import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.E_Equals;
import com.hp.hpl.jena.sparql.expr.E_LogicalAnd;
import com.hp.hpl.jena.sparql.expr.E_LogicalOr;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.FunctionLabel;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.aksw.commons.collections.IterableCollection;
import org.aksw.commons.factory.Factory2;
import org.aksw.commons.util.Pair;
import org.aksw.sparqlify.core.SparqlifyConstants;

public class ExprUtils {
    public static boolean isConstantsOnly(Iterable<Expr> exprs) {
        for (Expr expr : exprs) {
            if (expr.isConstant()) continue;
            return false;
        }
        return true;
    }

    public static boolean isConstantArgsOnly(ExprFunction fn) {
        if (fn == null) {
            throw new RuntimeException("Null argument should not happen here");
        }
        boolean result = ExprUtils.isConstantsOnly(fn.getArgs());
        return result;
    }

    public static Expr andifyBalanced(Expr ... exprs) {
        return ExprUtils.andifyBalanced(Arrays.asList(exprs));
    }

    public static Expr orifyBalanced(Expr ... exprs) {
        return ExprUtils.orifyBalanced(Arrays.asList(exprs));
    }

    public static List<String> extractNames(Collection<Var> vars) {
        ArrayList<String> result = new ArrayList<String>();
        for (Var var : vars) {
            result.add(var.getName());
        }
        return result;
    }

    public static Expr andifyBalanced(Iterable<Expr> exprs) {
        return ExprUtils.opifyBalanced(exprs, new Factory2<Expr>(){

            @Override
            public Expr create(Expr a, Expr b) {
                return new E_LogicalAnd(a, b);
            }
        });
    }

    public static <T> T opifyBalanced(Iterable<T> exprs, Factory2<T> exprFactory) {
        if (!exprs.iterator().hasNext()) {
            return null;
        }
        ArrayList current = new ArrayList(IterableCollection.wrap(exprs));
        while (current.size() > 1) {
            ArrayList<Object> next = new ArrayList<Object>();
            Object left = null;
            for (Object expr : current) {
                if (left == null) {
                    left = expr;
                    continue;
                }
                Object newExpr = exprFactory.create(left, expr);
                next.add(newExpr);
                left = null;
            }
            if (left != null) {
                next.add(left);
            }
            current.clear();
            ArrayList tmp = current;
            current = next;
            ArrayList arrayList = tmp;
        }
        return (T)current.get(0);
    }

    public static Expr orifyBalanced(Iterable<Expr> exprs) {
        return ExprUtils.opifyBalanced(exprs, new Factory2<Expr>(){

            @Override
            public Expr create(Expr a, Expr b) {
                return new E_LogicalOr(a, b);
            }
        });
    }

    public static Pair<Var, NodeValue> extractConstantConstraint(Expr expr) {
        if (expr instanceof E_Equals) {
            E_Equals e = (E_Equals)expr;
            return ExprUtils.extractConstantConstraint(e.getArg1(), e.getArg2());
        }
        return null;
    }

    public static Pair<Var, NodeValue> extractConstantConstraint(Expr a, Expr b) {
        Pair<Var, NodeValue> result = ExprUtils.extractConstantConstraintDirected(a, b);
        if (result == null) {
            result = ExprUtils.extractConstantConstraintDirected(b, a);
        }
        return result;
    }

    public static Pair<Var, NodeValue> extractConstantConstraintDirected(Expr a, Expr b) {
        if (!a.isVariable() || !b.isConstant()) {
            return null;
        }
        Var var = a.getExprVar().asVar();
        NodeValue nodeValue = b.getConstant();
        return Pair.create((Object)var, (Object)nodeValue);
    }

    public static Collection<? extends Expr> getSubExpressions(Expr expr, boolean reflexive) {
        HashSet<Expr> result = new HashSet<Expr>();
        if (reflexive) {
            result.add(expr);
        }
        ExprUtils.getSubExpressions(expr, result);
        return result;
    }

    public static void getSubExpressions(Expr expr, Set<Expr> result) {
        if (expr.isFunction()) {
            ExprFunction f = (ExprFunction)expr;
            for (int i = 1; i <= f.numArgs(); ++i) {
                Expr arg = f.getArg(i);
                if (result.contains(arg)) continue;
                result.add(arg);
                ExprUtils.getSubExpressions(arg, result);
            }
        }
    }

    public static String getFunctionId(ExprFunction fn) {
        String result = null;
        result = fn.getOpName();
        if (result != null) {
            return result;
        }
        result = fn.getFunctionIRI();
        if (result != null) {
            return result;
        }
        FunctionLabel label = fn.getFunctionSymbol();
        result = label == null ? null : label.getSymbol();
        return result;
    }

    public static Object getJavaObject(NodeValue expr) {
        Object result;
        if (expr.equals((Object)SparqlifyConstants.nvTypeError)) {
            result = false;
        } else if (expr.isIRI()) {
            result = expr.asNode().getURI();
        } else if (expr.isBoolean()) {
            result = expr.getBoolean();
        } else if (expr.isNumber()) {
            BigDecimal d;
            result = expr.isDecimal() ? (Number)((d = expr.getDecimal()).scale() > 0 ? (Number)d.doubleValue() : (Number)d.intValue()) : (Number)(expr.isDouble() ? (Number)expr.getDouble() : (Number)(expr.isFloat() ? (Number)Float.valueOf(expr.getFloat()) : (Number)expr.getDecimal().longValue()));
        } else if (expr.isString()) {
            result = expr.getString();
        } else if (expr.isDate()) {
            result = expr.getDateTime().toGregorianCalendar();
        } else if (expr.isDateTime()) {
            result = expr.getDateTime().toGregorianCalendar();
        } else {
            throw new RuntimeException("Unknow datatype of constant: " + expr.getClass() + " ," + expr);
        }
        return result;
    }

    public static boolean containsFalse(Iterable<Expr> exprs) {
        for (Expr expr : exprs) {
            if (!NodeValue.FALSE.equals((Object)expr)) continue;
            return true;
        }
        return false;
    }
}

