/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.database;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.aksw.sparqlify.database.Constraint;
import org.aksw.sparqlify.database.EqualsConstraint;
import org.aksw.sparqlify.database.IsPrefixOfConstraint;
import org.aksw.sparqlify.database.MapStoreAccessor;
import org.aksw.sparqlify.database.StartsWithConstraint;
import org.apache.commons.collections15.Transformer;
import org.ardverk.collection.KeyAnalyzer;
import org.ardverk.collection.PatriciaTrie;
import org.ardverk.collection.StringKeyAnalyzer;

public class PatriciaPrefixMapStoreAccessor
implements MapStoreAccessor {
    public static Set<Class<?>> supportedConstraintClasses = new HashSet();
    private int indexColumn;
    private Transformer<Object, Set<String>> prefixExtractor;

    @Override
    public Set<Class<?>> getSupportedConstraintClasses() {
        return supportedConstraintClasses;
    }

    public PatriciaPrefixMapStoreAccessor(int[] indexColumns, Transformer<Object, Set<String>> prefixExtractor) {
        if (indexColumns.length != 1) {
            throw new RuntimeException("Prefix index can only operate on single columns");
        }
        this.indexColumn = indexColumns[0];
        this.prefixExtractor = prefixExtractor;
    }

    @Override
    public void put(Object store, List<?> row, Object value) {
        this.put((PatriciaTrie<String, Object>)((PatriciaTrie)store), row, value);
    }

    public void put(PatriciaTrie<String, Object> map, List<?> row, Object value) {
        map.put((Object)((String)row.get(this.indexColumn)), value);
    }

    @Override
    public Collection<Object> lookup(Object store, Constraint constraint) {
        PatriciaTrie map = (PatriciaTrie)store;
        if (constraint instanceof IsPrefixOfConstraint) {
            return this.lookup((PatriciaTrie<String, Object>)map, (IsPrefixOfConstraint)constraint);
        }
        if (constraint instanceof StartsWithConstraint) {
            return this.lookup((PatriciaTrie<String, Object>)map, (StartsWithConstraint)constraint);
        }
        if (constraint instanceof EqualsConstraint) {
            return this.lookup((PatriciaTrie<String, Object>)map, (EqualsConstraint)constraint);
        }
        throw new RuntimeException("Could not handle constraint " + constraint);
    }

    public Collection<Object> lookup(PatriciaTrie<String, Object> map, EqualsConstraint constraint) {
        return Collections.singleton(map.get(constraint.getValue()));
    }

    public Collection<Object> lookup(PatriciaTrie<String, Object> map, StartsWithConstraint constraint) {
        if (!constraint.isInclusive()) {
            throw new RuntimeException("Patricia tree does not support 'non-inclusive' constraint, and I haven't hacked that in yet");
        }
        return map.prefixMap((Object)constraint.getPrefix()).values();
    }

    public Collection<Object> lookup(PatriciaTrie<String, Object> map, IsPrefixOfConstraint constraint) {
        String lookup = constraint.getValue();
        if (!constraint.isInclusive()) {
            int n = lookup.length();
            if (n == 0) {
                return Collections.emptySet();
            }
            lookup.substring(0, n - 1);
        }
        throw new RuntimeException("Either the patricia tree impl is broken, or I misunderstood something about it..., but the prefix map does not contain all prefixes of a given string");
    }

    @Override
    public Object get(Object store, List<Object> row) {
        return this.get((PatriciaTrie<String, Object>)((PatriciaTrie)store), row);
    }

    public Object get(PatriciaTrie<String, Object> map, List<Object> row) {
        return map.get(row.get(this.indexColumn));
    }

    @Override
    public Collection<Object> list(Object store) {
        return ((PatriciaTrie)store).values();
    }

    public PatriciaTrie<String, Object> createStore() {
        return new PatriciaTrie((KeyAnalyzer)StringKeyAnalyzer.BYTE);
    }

    static {
        supportedConstraintClasses.add(EqualsConstraint.class);
        supportedConstraintClasses.add(StartsWithConstraint.class);
        supportedConstraintClasses.add(IsPrefixOfConstraint.class);
    }
}

