/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.csv;

import com.hp.hpl.jena.graph.Node;
import org.apache.commons.lang.StringUtils;

public class NodeUtils {
    public static String toNTriplesString(Node node) {
        String result;
        if (node.isURI()) {
            result = "<" + node.getURI() + ">";
        } else if (node.isLiteral()) {
            String lex = node.getLiteralLexicalForm();
            String lang = node.getLiteralLanguage();
            String dt = node.getLiteralDatatypeURI();
            String tmp = lex;
            tmp = tmp.replace("\\", "\\\\");
            tmp = tmp.replace("\"", "\\\"");
            tmp = tmp.replace("\n", "\\n");
            tmp = tmp.replace("\t", "\\t");
            String encoded = tmp = tmp.replace("\r", "\\r");
            String quote = "\"";
            result = quote + encoded + quote;
            if (!StringUtils.isEmpty((String)dt)) {
                result = result + "^^<" + dt + ">";
            } else if (!lang.isEmpty()) {
                result = result + "@" + lang;
            }
        } else if (node.isBlank()) {
            result = node.getBlankNodeLabel();
        } else {
            throw new RuntimeException("Cannot serialize [" + node + "] as N-Triples");
        }
        return result;
    }
}

