/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.datatypes;

import java.util.HashMap;
import java.util.Map;
import org.aksw.sparqlify.algebra.sparql.transform.MethodSignature;
import org.aksw.sparqlify.core.datatypes.CoercionSystemOld;
import org.aksw.sparqlify.core.datatypes.XClass;
import org.aksw.sparqlify.core.datatypes.XMethod;

class CoercionSystemImpl
implements CoercionSystemOld {
    private Map<XClass, Map<XClass, XMethod>> sourceToTargetToDecl = new HashMap<XClass, Map<XClass, XMethod>>();

    CoercionSystemImpl() {
    }

    public void register(XMethod decl) {
        XClass target;
        MethodSignature<XClass> signature = decl.getSignature();
        if (signature.getParameterTypes().size() != 1) {
            throw new RuntimeException("Only 1 argument allowed for implicit conversions");
        }
        XClass source = signature.getParameterTypes().get(0);
        if (source.isAssignableFrom(target = signature.getReturnType())) {
            throw new RuntimeException("The return type must not be a subtype of the argument.");
        }
        Map<XClass, XMethod> targetToDecl = this.sourceToTargetToDecl.get(source);
        XMethod priorDecl = null;
        if (targetToDecl == null) {
            targetToDecl = new HashMap<XClass, XMethod>();
            this.sourceToTargetToDecl.put(source, targetToDecl);
        } else {
            priorDecl = targetToDecl.get(target);
        }
        if (priorDecl != null) {
            throw new RuntimeException("Coercion " + decl + " from " + source + " to " + target + " already defined with " + priorDecl);
        }
        targetToDecl.put(target, decl);
    }

    @Override
    public XMethod lookup(XClass source, XClass target) {
        Map<XClass, XMethod> targetToDecl = this.sourceToTargetToDecl.get(source);
        if (targetToDecl == null) {
            return null;
        }
        XMethod result = targetToDecl.get(target);
        return result;
    }
}

