/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.cast;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.vocabulary.XSD;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.collections.MultiMaps;
import org.aksw.commons.collections.multimaps.BiHashMultimap;
import org.aksw.commons.collections.multimaps.IBiSetMultimap;
import org.aksw.commons.factory.Factory1;
import org.aksw.sparqlify.algebra.sql.exprs.evaluators.SqlExprEvaluator;
import org.aksw.sparqlify.algebra.sql.exprs2.SqlExpr;
import org.aksw.sparqlify.core.TypeToken;
import org.aksw.sparqlify.core.cast.CandidateMethod;
import org.aksw.sparqlify.core.cast.CastException;
import org.aksw.sparqlify.core.cast.CoercionSystem;
import org.aksw.sparqlify.core.cast.CoercionSystemImpl3;
import org.aksw.sparqlify.core.cast.DirectSuperTypeProvider;
import org.aksw.sparqlify.core.cast.FunctionModel;
import org.aksw.sparqlify.core.cast.FunctionModelImpl;
import org.aksw.sparqlify.core.cast.FunctionModelMeta;
import org.aksw.sparqlify.core.cast.MethodEntry;
import org.aksw.sparqlify.core.cast.NodeValueTransformer;
import org.aksw.sparqlify.core.cast.SqlDatatype;
import org.aksw.sparqlify.core.cast.SqlFunctionCollection;
import org.aksw.sparqlify.core.cast.SqlLiteralMapper;
import org.aksw.sparqlify.core.cast.SqlTypeMapper;
import org.aksw.sparqlify.core.cast.SqlTypeMapperImpl;
import org.aksw.sparqlify.core.cast.SqlValue;
import org.aksw.sparqlify.core.cast.SqlValueTransformer;
import org.aksw.sparqlify.core.cast.TypeHierarchyProviderImpl;
import org.aksw.sparqlify.core.cast.TypeSystem;
import org.aksw.sparqlify.core.cast.TypeSystemUtils;
import org.aksw.sparqlify.core.cast.XClassImpl2;
import org.aksw.sparqlify.core.datatypes.SparqlFunction;
import org.aksw.sparqlify.core.datatypes.XClass;
import org.aksw.sparqlify.core.datatypes.XMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeSystemImpl
implements TypeSystem {
    private static final Logger logger = LoggerFactory.getLogger(TypeSystemImpl.class);
    private TypeMapper typeMapper;
    private SqlTypeMapper sqlTypeMapper;
    private Map<String, SparqlFunction> nameToSparqlFunction = new HashMap<String, SparqlFunction>();
    private Map<String, SqlLiteralMapper> typeToLiteralMapper = new HashMap<String, SqlLiteralMapper>();
    private IBiSetMultimap<TypeToken, TypeToken> physicalTypeMap = new BiHashMultimap();
    private Map<String, SqlFunctionCollection> nameToSqlFunctions = new HashMap<String, SqlFunctionCollection>();
    private IBiSetMultimap<TypeToken, TypeToken> typeHierarchy = new BiHashMultimap();
    private DirectSuperTypeProvider<TypeToken> typeHierarchyProvider = new TypeHierarchyProviderImpl(this.typeHierarchy);
    private CoercionSystem<TypeToken, SqlValueTransformer> coercionSystem = new CoercionSystemImpl3(this);
    private FunctionModel<TypeToken> functionModel = new FunctionModelImpl<TypeToken>(this.typeHierarchyProvider);
    private Multimap<String, String> sparqlToSqlDecl = HashMultimap.create();
    private Map<String, SqlExprEvaluator> sqlToImpl = new HashMap<String, SqlExprEvaluator>();
    private FunctionModelMeta sqlFunctionMetaModel = new FunctionModelMeta();

    @Override
    public Multimap<String, String> getSparqlSqlDecls() {
        return this.sparqlToSqlDecl;
    }

    @Override
    public FunctionModel<TypeToken> getSqlFunctionModel() {
        return this.functionModel;
    }

    @Override
    public Map<String, SqlExprEvaluator> getSqlImpls() {
        return this.sqlToImpl;
    }

    @Override
    public IBiSetMultimap<TypeToken, TypeToken> getPhysicalTypeMap() {
        return this.physicalTypeMap;
    }

    @Override
    public FunctionModelMeta getSqlFunctionMetaModel() {
        return this.sqlFunctionMetaModel;
    }

    public TypeSystemImpl() {
        this.typeMapper = TypeMapper.getInstance();
        this.sqlTypeMapper = new SqlTypeMapperImpl();
    }

    @Override
    public CoercionSystem<TypeToken, SqlValueTransformer> getCoercionSystem() {
        return this.coercionSystem;
    }

    public IBiSetMultimap<TypeToken, TypeToken> getTypeHierarchy() {
        return this.typeHierarchy;
    }

    @Override
    public void registerSparqlFunction(SparqlFunction sparqlFunction) {
        this.nameToSparqlFunction.put(sparqlFunction.getName(), sparqlFunction);
    }

    @Deprecated
    void registerSqlFunction(String name, SqlFunctionCollection sqlFunctions) {
        this.nameToSqlFunctions.put(name, sqlFunctions);
    }

    @Override
    public void registerLiteralMapper(String typeUri, SqlLiteralMapper mapper) {
        SqlLiteralMapper oldValue = this.typeToLiteralMapper.get(typeUri);
        if (oldValue != null) {
            throw new RuntimeException("Literal Mapper for type " + typeUri + " already registered. Redefinition with " + mapper);
        }
        this.typeToLiteralMapper.put(typeUri, mapper);
    }

    @Override
    public TypeMapper getTypeMapper() {
        return this.typeMapper;
    }

    @Override
    @Deprecated
    public void registerCoercion(XMethod method) {
    }

    @Override
    public SparqlFunction getSparqlFunction(String name) {
        SparqlFunction result = this.nameToSparqlFunction.get(name);
        return result;
    }

    @Override
    public SqlValue convertSql(NodeValue value) {
        SqlDatatype sqlType;
        Node node;
        if (value.hasNode() && (node = value.asNode()).isURI()) {
            logger.warn("FIXME Replacing URI with string - this should be validated when loading views");
            value = NodeValue.makeString((String)node.getURI());
        }
        if (!value.isLiteral()) {
            throw new RuntimeException("Only literals allowed here, got: " + value);
        }
        String datatypeUri = value.asNode().getLiteralDatatypeURI();
        if (datatypeUri == null) {
            datatypeUri = XSD.xstring.toString();
        }
        if ((sqlType = this.sqlTypeMapper.getSqlDatatype(datatypeUri)) == null) {
            throw new RuntimeException("No SQL conversion found for NodeValue: " + value + " ( " + datatypeUri + ")");
        }
        SqlValue result = sqlType.toSqlValue(value);
        return result;
    }

    @Override
    public SqlValue cast(SqlValue value, TypeToken targetTypeToken) {
        SqlValue result;
        TypeToken sourceTypeToken = value.getTypeToken();
        SqlValueTransformer transformer = this.coercionSystem.lookup(sourceTypeToken, targetTypeToken);
        if (transformer == null) {
            logger.warn("No cast found for: " + value + " to " + targetTypeToken + " --- assuming type error");
            return SqlValue.TYPE_ERROR;
        }
        try {
            result = transformer.transform(value);
        }
        catch (CastException e) {
            result = null;
        }
        return result;
    }

    public NodeValue cast(NodeValue value, TypeToken targetTypeToken) {
        NodeValue result;
        if (!value.isLiteral()) {
            throw new RuntimeException("Only literals allowed here, got: " + value);
        }
        String sourceTypeName = value.asNode().getLiteralDatatypeURI();
        TypeToken sourceTypeToken = sourceTypeName == null ? TypeToken.String : TypeToken.alloc(sourceTypeName);
        NodeValueTransformer transformer = null;
        if (transformer == null) {
            throw new RuntimeException("No cast found for: " + value + " ( " + sourceTypeToken + ") to " + targetTypeToken);
        }
        try {
            result = transformer.transform(value);
        }
        catch (CastException e) {
            result = null;
        }
        return result;
    }

    public SqlValueTransformer lookupCast(TypeToken sourceTypeName, TypeToken targetTypeName) {
        SqlValueTransformer result = this.coercionSystem.lookup(sourceTypeName, targetTypeName);
        return result;
    }

    @Override
    public boolean isSuperClassOf(TypeToken a, TypeToken b) {
        boolean result = TypeSystemUtils.isSuperClassOf(a, b, this.typeHierarchyProvider);
        return result;
    }

    @Override
    public XClass resolve(String typeName) {
        XClassImpl2 result = new XClassImpl2(this, this);
        return result;
    }

    @Override
    public Collection<TypeToken> getDirectSuperTypes(TypeToken name) {
        Collection<TypeToken> result = this.typeHierarchyProvider.getDirectSuperTypes(name);
        return result;
    }

    @Override
    public Factory1<SqlExpr> cast(TypeToken fromTypeUri, TypeToken toTypeUri) {
        return null;
    }

    @Override
    public void registerSqlFunction(XMethod sqlFunction) {
    }

    public static IBiSetMultimap<TypeToken, TypeToken> createHierarchyMap(Map<String, String> typeHierarchy) {
        BiHashMultimap subToSuperType = new BiHashMultimap();
        for (Map.Entry<String, String> entry : typeHierarchy.entrySet()) {
            TypeToken subType = TypeToken.alloc(entry.getKey());
            TypeToken superType = TypeToken.alloc(entry.getValue());
            subToSuperType.put((Object)subType, (Object)superType);
        }
        return subToSuperType;
    }

    public static TypeSystemImpl create(Map<String, String> typeHierarchy, Map<String, String> rawPhysicalTypeMap) {
        IBiSetMultimap<TypeToken, TypeToken> subToSuperType = TypeSystemImpl.createHierarchyMap(typeHierarchy);
        IBiSetMultimap<TypeToken, TypeToken> physicalTypeMap = TypeSystemImpl.createHierarchyMap(rawPhysicalTypeMap);
        TypeSystemImpl result = new TypeSystemImpl();
        result.getTypeHierarchy().putAll(subToSuperType);
        result.getPhysicalTypeMap().putAll(physicalTypeMap);
        return result;
    }

    @Override
    public Set<TypeToken> supremumDatatypes(TypeToken from, TypeToken to) {
        Set result = MultiMaps.getCommonParent((Map)this.typeHierarchy.asMap(), (Object)from, (Object)to);
        return result;
    }

    @Override
    public SqlTypeMapper getSqlTypeMapper() {
        return this.sqlTypeMapper;
    }

    public static <T> CandidateMethod<T> lookupSqlCandidate(FunctionModel<T> functionModel, Multimap<String, String> nameToDecls, String sparqlFnName, List<T> argTypes) {
        Collection sqlFnIds = nameToDecls.get((Object)sparqlFnName);
        ArrayList sqlFns = new ArrayList(sqlFnIds.size());
        for (String sqlFnId : sqlFnIds) {
            MethodEntry<T> sqlFn = functionModel.lookupById(sqlFnId);
            if (sqlFn == null) continue;
            sqlFns.add(sqlFn);
        }
        Collection<CandidateMethod<T>> candidates = functionModel.lookup(sqlFns, argTypes);
        if (candidates.size() > 1) {
            throw new RuntimeException("Multiple matching SQL declarations for SPARQL function " + sparqlFnName + " with argument types " + argTypes);
        }
        CandidateMethod<T> result = candidates.isEmpty() ? null : candidates.iterator().next();
        return result;
    }
}

