/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.cast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.aksw.sparqlify.core.TypeToken;
import org.aksw.sparqlify.core.cast.CoercionSystemOld;
import org.aksw.sparqlify.core.cast.DirectSuperTypeProvider;
import org.aksw.sparqlify.core.cast.TypeDistance;
import org.aksw.sparqlify.core.datatypes.TypeSystem;
import org.aksw.sparqlify.core.datatypes.XClass;

public class TypeHierarchyUtils {
    public static <M> Integer getRelation(TypeDistance<M> a, TypeDistance<M> b) {
        int result = a.getCoercion() == null ? (b.getCoercion() == null ? a.getInheritanceDepth() - b.getInheritanceDepth() : -1) : (b.getCoercion() == null ? 1 : b.getInheritanceDepth() - a.getInheritanceDepth());
        return result;
    }

    public static <M> Integer getRelation(TypeDistance<M>[] a, TypeDistance<M>[] b) {
        boolean hasGreater = false;
        boolean hasLess = false;
        for (int i = 0; i < a.length; ++i) {
            TypeDistance<M> x = a[i];
            TypeDistance<M> y = a[i];
            if (x == null || y == null) {
                throw new NullPointerException();
            }
            int d = TypeHierarchyUtils.getRelation(x, y);
            if (d > 0) {
                hasGreater = true;
                continue;
            }
            if (d >= 0) continue;
            hasLess = true;
        }
        if (hasGreater && hasLess) {
            return null;
        }
        if (hasGreater) {
            return 1;
        }
        if (hasLess) {
            return -1;
        }
        return 0;
    }

    public static <T, M> TypeDistance<M>[] getTypeDistance(T[] a, T[] b, CoercionSystemOld<T, M> coercions, DirectSuperTypeProvider<T> DirectSuperTypeProvider2) {
        int n = Math.min(a.length, b.length);
        TypeDistance[] result = (TypeDistance[])new Object[n];
        for (int i = 0; i < n; ++i) {
            T given = a[i];
            result[i] = given == null ? new TypeDistance<Object>(0, null) : TypeHierarchyUtils.getTypeDistance(given, b[i], coercions, DirectSuperTypeProvider2);
        }
        return result;
    }

    public static <T, M> TypeDistance<M> getTypeDistance(T source, T target, CoercionSystemOld<T, M> coercions, DirectSuperTypeProvider<T> DirectSuperTypeProvider2) {
        Integer depth = TypeHierarchyUtils.getDistance(source, target, DirectSuperTypeProvider2);
        TypeDistance<Object> result = depth != null ? new TypeDistance<Object>(depth, null) : TypeHierarchyUtils.findCoercion(source, target, coercions, DirectSuperTypeProvider2);
        return result;
    }

    public static List<XClass> resolve(TypeSystem datatypeSystem, Collection<TypeToken> typeNames) {
        ArrayList<XClass> result = new ArrayList<XClass>(typeNames.size());
        for (TypeToken typeName : typeNames) {
            XClass tmp = datatypeSystem.getByName(typeName);
            if (tmp == null) {
                throw new RuntimeException("Could not resolve: " + typeName);
            }
            result.add(tmp);
        }
        return result;
    }

    public static <T> Integer getDistance(T given, T there, DirectSuperTypeProvider<T> DirectSuperTypeProvider2) {
        Integer result = TypeHierarchyUtils._getDistanceInterface(given, there, 0, DirectSuperTypeProvider2);
        return result == Integer.MAX_VALUE ? null : result;
    }

    public static <T, M> TypeDistance<M> findCoercion(T source, T target, CoercionSystemOld<T, M> coercions, DirectSuperTypeProvider<T> DirectSuperTypeProvider2) {
        ArrayList<T> open = new ArrayList<T>();
        ArrayList<T> next = null;
        open.add(source);
        int depth = 0;
        while (!open.isEmpty()) {
            Object method = null;
            for (Object item : open) {
                M tmp = coercions.lookup(source, target);
                if (tmp != null && method != null) {
                    throw new RuntimeException("Multiple candidates: " + tmp + ", " + item);
                }
                method = tmp;
            }
            if (method != null) {
                TypeDistance<Object> result = new TypeDistance<Object>(depth, method);
                return result;
            }
            ++depth;
            if (next == null) {
                next = new ArrayList<T>();
            } else {
                next.clear();
            }
            for (Object item : open) {
                Collection<T> superTypes = DirectSuperTypeProvider2.getDirectSuperTypes(item);
                next.addAll(superTypes);
            }
            ArrayList<T> swap = open;
            open = next;
            next = swap;
        }
        return null;
    }

    private static <T> int _getDistanceInterface(T given, T there, int depth, DirectSuperTypeProvider<T> DirectSuperTypeProvider2) {
        if (given == there) {
            return depth;
        }
        ++depth;
        int result = Integer.MAX_VALUE;
        Collection<T> superTypes = DirectSuperTypeProvider2.getDirectSuperTypes(given);
        for (T item : superTypes) {
            result = Math.min(result, TypeHierarchyUtils._getDistanceInterface(item, there, depth, DirectSuperTypeProvider2));
        }
        return result;
    }

    public static <T> Integer[] getDistance(T[] a, T[] b, DirectSuperTypeProvider<T> DirectSuperTypeProvider2) {
        int n = Math.min(a.length, b.length);
        Integer[] result = new Integer[n];
        for (int i = 0; i < n; ++i) {
            T given = a[i];
            result[i] = given == null ? Integer.valueOf(0) : TypeHierarchyUtils.getDistance(given, b[i], DirectSuperTypeProvider2);
        }
        return result;
    }

    public static <T> Integer[] getDistance(T ra, T rb, T[] a, T[] b, DirectSuperTypeProvider<T> DirectSuperTypeProvider2) {
        int n = Math.min(a.length, b.length);
        Integer[] result = new Integer[n + 1];
        result[0] = TypeHierarchyUtils.getDistance(rb, ra, DirectSuperTypeProvider2);
        for (int i = 0; i < n; ++i) {
            Integer d;
            result[i + 1] = d = TypeHierarchyUtils.getDistance(a[i], b[i], DirectSuperTypeProvider2);
        }
        return result;
    }
}

