/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.cast;

import com.google.common.collect.Multimap;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.util.ExprUtils;
import com.hp.hpl.jena.vocabulary.XSD;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.aksw.commons.util.MapReader;
import org.aksw.sparqlify.algebra.sparql.expr.E_RdfTerm;
import org.aksw.sparqlify.algebra.sparql.transform.MethodSignature;
import org.aksw.sparqlify.algebra.sql.exprs.evaluators.SqlExprEvaluator;
import org.aksw.sparqlify.algebra.sql.exprs.evaluators.SqlExprEvaluator_Arithmetic;
import org.aksw.sparqlify.algebra.sql.exprs.evaluators.SqlExprEvaluator_Compare;
import org.aksw.sparqlify.algebra.sql.exprs.evaluators.SqlExprEvaluator_LogicalAnd;
import org.aksw.sparqlify.algebra.sql.exprs.evaluators.SqlExprEvaluator_LogicalNot;
import org.aksw.sparqlify.algebra.sql.exprs.evaluators.SqlExprEvaluator_LogicalOr;
import org.aksw.sparqlify.algebra.sql.exprs.evaluators.SqlExprEvaluator_ParseInt;
import org.aksw.sparqlify.algebra.sql.exprs2.ExprSqlBridge;
import org.aksw.sparqlify.algebra.sql.exprs2.SqlExpr;
import org.aksw.sparqlify.core.RdfViewSystemOld;
import org.aksw.sparqlify.core.SparqlifyConstants;
import org.aksw.sparqlify.core.TypeToken;
import org.aksw.sparqlify.core.algorithms.DatatypeToStringPostgres;
import org.aksw.sparqlify.core.algorithms.ExprEvaluator;
import org.aksw.sparqlify.core.algorithms.ExprSqlRewrite;
import org.aksw.sparqlify.core.cast.CoercionSystemImpl3;
import org.aksw.sparqlify.core.cast.ExprBindingSubstitutorImpl;
import org.aksw.sparqlify.core.cast.FunctionModel;
import org.aksw.sparqlify.core.cast.FunctionModelMeta;
import org.aksw.sparqlify.core.cast.NodeValueToObjectDefault;
import org.aksw.sparqlify.core.cast.SqlDatatypeConstant;
import org.aksw.sparqlify.core.cast.SqlDatatypeDefault;
import org.aksw.sparqlify.core.cast.SqlExprFactoryUtils;
import org.aksw.sparqlify.core.cast.SqlExprSerializerSystemImpl;
import org.aksw.sparqlify.core.cast.SqlLiteralMapperDefault;
import org.aksw.sparqlify.core.cast.SqlTypeMapper;
import org.aksw.sparqlify.core.cast.SqlValue;
import org.aksw.sparqlify.core.cast.SqlValueTransformerInteger;
import org.aksw.sparqlify.core.cast.TypeSystem;
import org.aksw.sparqlify.core.cast.TypeSystemImpl;
import org.aksw.sparqlify.core.cast.TypedExprTransformerImpl;
import org.aksw.sparqlify.core.datatypes.SparqlFunctionImpl;
import org.aksw.sparqlify.core.transformations.RdfTermEliminatorImpl;
import org.aksw.sparqlify.core.transformations.SqlTranslationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewWorldTest {
    private static final Logger logger = LoggerFactory.getLogger(NewWorldTest.class);

    public static void registerSqlOperatorBatchNumeric(FunctionModel<TypeToken> sqlModel, String name) {
        sqlModel.registerFunction(name + "@boolean", name, MethodSignature.create(false, TypeToken.Boolean, TypeToken.Boolean, TypeToken.Boolean));
        sqlModel.registerFunction(name + "@int", name, MethodSignature.create(false, TypeToken.Int, TypeToken.Int, TypeToken.Int));
        sqlModel.registerFunction(name + "@float", name, MethodSignature.create(false, TypeToken.Float, TypeToken.Float, TypeToken.Float));
        sqlModel.registerFunction(name + "@double", name, MethodSignature.create(false, TypeToken.Double, TypeToken.Double, TypeToken.Double));
    }

    public static void registerSqlOperatorBatchCompare(FunctionModel<TypeToken> sqlModel, String name) {
        sqlModel.registerFunction(name + "@boolean", name, MethodSignature.create(false, TypeToken.Boolean, TypeToken.Boolean, TypeToken.Boolean));
        sqlModel.registerFunction(name + "@int", name, MethodSignature.create(false, TypeToken.Boolean, TypeToken.Int, TypeToken.Int));
        sqlModel.registerFunction(name + "@float", name, MethodSignature.create(false, TypeToken.Boolean, TypeToken.Float, TypeToken.Float));
        sqlModel.registerFunction(name + "@double", name, MethodSignature.create(false, TypeToken.Boolean, TypeToken.Double, TypeToken.Double));
        sqlModel.registerFunction(name + "@string", name, MethodSignature.create(false, TypeToken.Boolean, TypeToken.String, TypeToken.String));
        sqlModel.registerFunction(name + "@dateTime", name, MethodSignature.create(false, TypeToken.Boolean, TypeToken.Date, TypeToken.Date));
    }

    public static TypeSystem createDefaultDatatypeSystem() {
        try {
            Map typeNameToClass = MapReader.readFromResource((String)"/type-class.tsv");
            Map typeNameToUri = MapReader.readFromResource((String)"/type-uri.tsv");
            Map typeHierarchy = MapReader.readFromResource((String)"/type-hierarchy.default.tsv");
            Map physicalTypeMap = MapReader.readFromResource((String)"/type-map.h2.tsv");
            physicalTypeMap.put("INTEGER", "int");
            TypeSystemImpl result = TypeSystemImpl.create(typeHierarchy, physicalTypeMap);
            NewWorldTest.initSparqlModel(result);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <K, V> void putForAll(Map<K, V> map, Collection<K> keys, V value) {
        for (K key : keys) {
            map.put(key, value);
        }
    }

    public static void initSparqlModel(TypeSystem typeSystem) {
        TypeMapper tm = TypeMapper.getInstance();
        String xxx = "http://mytype.org/foo/bar";
        SqlTypeMapper stm = typeSystem.getSqlTypeMapper();
        stm.register(XSD.xstring.getURI(), new SqlDatatypeDefault(TypeToken.String, new NodeValueToObjectDefault()));
        stm.register(XSD.xboolean.getURI(), new SqlDatatypeDefault(TypeToken.Boolean, new NodeValueToObjectDefault()));
        stm.register(XSD.integer.getURI(), new SqlDatatypeDefault(TypeToken.Int, new NodeValueToObjectDefault()));
        stm.register(XSD.decimal.getURI(), new SqlDatatypeDefault(TypeToken.Int, new NodeValueToObjectDefault()));
        stm.register(XSD.dateTime.getURI(), new SqlDatatypeDefault(TypeToken.Date, new NodeValueToObjectDefault()));
        stm.register(SparqlifyConstants.nvTypeError.asNode().getLiteralDatatypeURI(), new SqlDatatypeConstant(SqlValue.TYPE_ERROR));
        CoercionSystemImpl3 cs = (CoercionSystemImpl3)typeSystem.getCoercionSystem();
        cs.registerCoercion(TypeToken.alloc(XSD.integer.toString()), TypeToken.Int, new SqlValueTransformerInteger());
        cs.registerCoercion(TypeToken.String, TypeToken.alloc("int8"), new SqlValueTransformerInteger());
        cs.registerCoercion(TypeToken.String, TypeToken.alloc("int4"), new SqlValueTransformerInteger());
        cs.registerCoercion(TypeToken.String, TypeToken.alloc("int"), new SqlValueTransformerInteger());
        cs.registerCoercion(TypeToken.String, TypeToken.alloc("INTEGER"), new SqlValueTransformerInteger());
        ExprBindingSubstitutorImpl exprBindingSubstitutor = new ExprBindingSubstitutorImpl();
        ExprEvaluator exprEvaluator = SqlTranslationUtils.createDefaultEvaluator();
        TypedExprTransformerImpl typedExprTransformer = new TypedExprTransformerImpl(typeSystem);
        DatatypeToStringPostgres typeSerializer = new DatatypeToStringPostgres();
        SqlLiteralMapperDefault sqlLiteralMapper = new SqlLiteralMapperDefault(typeSerializer);
        SqlExprSerializerSystemImpl serializerSystem = new SqlExprSerializerSystemImpl(typeSerializer, sqlLiteralMapper);
        FunctionModel<TypeToken> sqlModel = typeSystem.getSqlFunctionModel();
        Multimap<String, String> sparqlSqlDecls = typeSystem.getSparqlSqlDecls();
        Map<String, SqlExprEvaluator> sqlImpls = typeSystem.getSqlImpls();
        NewWorldTest.registerSqlOperatorBatchCompare(sqlModel, "lessThan");
        NewWorldTest.registerSqlOperatorBatchCompare(sqlModel, "lessThanOrEqual");
        NewWorldTest.registerSqlOperatorBatchCompare(sqlModel, "equal");
        NewWorldTest.registerSqlOperatorBatchCompare(sqlModel, "greaterThan");
        NewWorldTest.registerSqlOperatorBatchCompare(sqlModel, "greaterThanOrEqual");
        NewWorldTest.registerSqlOperatorBatchNumeric(sqlModel, "numericPlus");
        NewWorldTest.registerSqlOperatorBatchNumeric(sqlModel, "numericMinus");
        NewWorldTest.registerSqlOperatorBatchNumeric(sqlModel, "numericMultiply");
        NewWorldTest.registerSqlOperatorBatchNumeric(sqlModel, "numericDivide");
        sqlModel.registerFunction("str@str", "str", MethodSignature.create(false, TypeToken.String, TypeToken.String));
        sqlModel.registerFunction("str@double", "str", MethodSignature.create(false, TypeToken.String, TypeToken.Double));
        sqlModel.registerFunction("str@float", "str", MethodSignature.create(false, TypeToken.String, TypeToken.Float));
        sqlModel.registerFunction("str@int", "str", MethodSignature.create(false, TypeToken.String, TypeToken.Int));
        sqlModel.registerFunction("double@str", "double", MethodSignature.create(false, TypeToken.Double, TypeToken.String));
        sqlModel.registerFunction("isNotNull@object", "isNotNull", MethodSignature.create(false, TypeToken.Boolean, TypeToken.Object));
        sparqlSqlDecls.putAll((Object)"<", sqlModel.getIdsByName("lessThan"));
        sparqlSqlDecls.putAll((Object)"<=", sqlModel.getIdsByName("lessThanOrEqual"));
        sparqlSqlDecls.putAll((Object)"=", sqlModel.getIdsByName("equal"));
        sparqlSqlDecls.putAll((Object)">", sqlModel.getIdsByName("greaterThan"));
        sparqlSqlDecls.putAll((Object)">=", sqlModel.getIdsByName("greaterThanOrEqual"));
        sparqlSqlDecls.putAll((Object)"+", sqlModel.getIdsByName("numericPlus"));
        sparqlSqlDecls.putAll((Object)"-", sqlModel.getIdsByName("numericMinus"));
        sparqlSqlDecls.putAll((Object)"/", sqlModel.getIdsByName("numericMultiply"));
        sparqlSqlDecls.putAll((Object)"*", sqlModel.getIdsByName("numericDivide"));
        sparqlSqlDecls.put((Object)"str", (Object)"str@str");
        sparqlSqlDecls.put((Object)"str", (Object)"str@double");
        sparqlSqlDecls.put((Object)"str", (Object)"str@float");
        sparqlSqlDecls.put((Object)"str", (Object)"str@int");
        sparqlSqlDecls.put((Object)XSD.xdouble.getURI(), (Object)"double@str");
        sparqlSqlDecls.put((Object)"bound", (Object)"isNotNull@object");
        NewWorldTest.putForAll(sqlImpls, sqlModel.getIdsByName("lessThan"), new SqlExprEvaluator_Compare(typeSystem, SqlExprFactoryUtils.factoryLessThan));
        NewWorldTest.putForAll(sqlImpls, sqlModel.getIdsByName("lessThanOrEqual"), new SqlExprEvaluator_Compare(typeSystem, SqlExprFactoryUtils.factoryLessThanOrEqual));
        NewWorldTest.putForAll(sqlImpls, sqlModel.getIdsByName("equal"), new SqlExprEvaluator_Compare(typeSystem, SqlExprFactoryUtils.factoryEqual));
        NewWorldTest.putForAll(sqlImpls, sqlModel.getIdsByName("greaterThan"), new SqlExprEvaluator_Compare(typeSystem, SqlExprFactoryUtils.factoryGreaterThan));
        NewWorldTest.putForAll(sqlImpls, sqlModel.getIdsByName("greaterThanOrEqual"), new SqlExprEvaluator_Compare(typeSystem, SqlExprFactoryUtils.factoryGreaterThanOrEqual));
        NewWorldTest.putForAll(sqlImpls, sqlModel.getIdsByName("numericPlus"), new SqlExprEvaluator_Arithmetic());
        NewWorldTest.putForAll(sqlImpls, sqlModel.getIdsByName("+"), new SqlExprEvaluator_Compare(typeSystem, SqlExprFactoryUtils.factoryNumericPlus));
        NewWorldTest.putForAll(sqlImpls, sqlModel.getIdsByName("-"), new SqlExprEvaluator_Compare(typeSystem, SqlExprFactoryUtils.factoryNumericMinus));
        NewWorldTest.putForAll(sqlImpls, sqlModel.getIdsByName("*"), new SqlExprEvaluator_Compare(typeSystem, SqlExprFactoryUtils.factoryNumericMultiply));
        sqlModel.registerFunction("logicalAnd@boolean", "logicalAnd", MethodSignature.create(false, TypeToken.Boolean, TypeToken.Boolean, TypeToken.Boolean));
        sparqlSqlDecls.putAll((Object)"&&", sqlModel.getIdsByName("logicalAnd"));
        NewWorldTest.putForAll(sqlImpls, sqlModel.getIdsByName("logicalAnd"), new SqlExprEvaluator_LogicalAnd());
        sqlModel.registerFunction("logicalOr@boolean", "logicalOr", MethodSignature.create(false, TypeToken.Boolean, TypeToken.Boolean, TypeToken.Boolean));
        sparqlSqlDecls.putAll((Object)"||", sqlModel.getIdsByName("logicalOr"));
        NewWorldTest.putForAll(sqlImpls, sqlModel.getIdsByName("logicalOr"), new SqlExprEvaluator_LogicalOr());
        sqlModel.registerFunction("logicalNot@boolean", "logicalNot", MethodSignature.create(false, TypeToken.Boolean, TypeToken.Boolean));
        sparqlSqlDecls.putAll((Object)"!", sqlModel.getIdsByName("logicalNot"));
        NewWorldTest.putForAll(sqlImpls, sqlModel.getIdsByName("logicalNot"), new SqlExprEvaluator_LogicalNot());
        sqlModel.registerFunction("concat@str", "concat", MethodSignature.create(true, TypeToken.String, TypeToken.String));
        sparqlSqlDecls.put((Object)"concat", (Object)"concat@str");
        sqlModel.registerFunction("parseInt@str", "parseInt", MethodSignature.create(false, TypeToken.Int, TypeToken.String));
        FunctionModelMeta sqlMetaModel = typeSystem.getSqlFunctionMetaModel();
        sqlMetaModel.getInverses().put("str@int", "parseInt@str");
        sqlMetaModel.getComparators().addAll(sqlModel.getIdsByName("lessThan"));
        sqlMetaModel.getComparators().addAll(sqlModel.getIdsByName("lessThanOrEqual"));
        sqlMetaModel.getComparators().addAll(sqlModel.getIdsByName("equal"));
        sqlMetaModel.getComparators().addAll(sqlModel.getIdsByName("greaterThanOrEqual"));
        sqlMetaModel.getComparators().addAll(sqlModel.getIdsByName("greaterThan"));
        sqlImpls.put("parseInt@str", new SqlExprEvaluator_ParseInt());
        MethodSignature<TypeToken> sig = MethodSignature.create(false, TypeToken.String, TypeToken.String);
        SparqlFunctionImpl f = new SparqlFunctionImpl("http://aksw.org/sparqlify/urlEncode", sig, null, null);
        typeSystem.registerSparqlFunction(f);
    }

    public static void testExprRewrite(TypeSystem typeSystem) {
        ExprBindingSubstitutorImpl exprBindingSubstitutor = new ExprBindingSubstitutorImpl();
        ExprEvaluator exprEvaluator = SqlTranslationUtils.createDefaultEvaluator();
        TypedExprTransformerImpl typedExprTransformer = new TypedExprTransformerImpl(typeSystem);
        DatatypeToStringPostgres typeSerializer = new DatatypeToStringPostgres();
        SqlLiteralMapperDefault sqlLiteralMapper = new SqlLiteralMapperDefault(typeSerializer);
        SqlExprSerializerSystemImpl serializerSystem = new SqlExprSerializerSystemImpl(typeSerializer, sqlLiteralMapper);
        Expr e0 = ExprUtils.parse((String)"?f = <http://foobar>");
        Expr a = ExprUtils.parse((String)"<http://aksw.org/sparqlify/uri>(?website)");
        Expr b = ExprUtils.parse((String)"<http://aksw.org/sparqlify/uri>(<http://aksw.org/sparqlify/plainLiteral>(?foo))");
        Expr c = ExprUtils.parse((String)"<http://aksw.org/sparqlify/typedLiteral>(1, 'http://www.w3.org/2001/XMLSchema#int')");
        Expr d = ExprUtils.parse((String)"<http://aksw.org/sparqlify/typedLiteral>(2, 'http://www.w3.org/2001/XMLSchema#int')");
        Expr e = ExprUtils.parse((String)"<http://aksw.org/sparqlify/typedLiteral>(?x, 'http://www.w3.org/2001/XMLSchema#int')");
        Expr f = ExprUtils.parse((String)"<http://aksw.org/sparqlify/uri>('http://foobar')");
        HashMap<Var, Expr> binding = new HashMap<Var, Expr>();
        binding.put(Var.alloc((String)"a"), a);
        binding.put(Var.alloc((String)"b"), b);
        binding.put(Var.alloc((String)"c"), c);
        binding.put(Var.alloc((String)"d"), d);
        binding.put(Var.alloc((String)"e"), e);
        binding.put(Var.alloc((String)"f"), f);
        HashMap<String, TypeToken> typeMap = new HashMap<String, TypeToken>();
        typeMap.put("website", TypeToken.String);
        typeMap.put("foo", TypeToken.String);
        typeMap.put("x", TypeToken.Int);
        logger.debug("[ExprRewrite Phase 0]: " + e0);
        Expr e1 = exprBindingSubstitutor.substitute(e0, binding);
        logger.debug("[ExprRewrite Phase 1]: " + e1);
        RdfTermEliminatorImpl exprTrns = SqlTranslationUtils.createDefaultTransformer();
        E_RdfTerm e2 = exprTrns._transform(e1);
        logger.debug("[ExprRewrite Phase 2]: " + (Object)((Object)e2));
        Expr e3 = exprEvaluator.transform((Expr)e2);
        logger.debug("[ExprRewrite Phase 3]: " + e3);
        ExprSqlRewrite e4 = typedExprTransformer.rewrite(e3, typeMap);
        logger.debug("[ExprRewrite Phase 4]: " + e4);
        Expr et = e4.getExpr();
        if (et instanceof ExprSqlBridge) {
            ExprSqlBridge bridge = (ExprSqlBridge)et;
            SqlExpr ex = bridge.getSqlExpr();
            String e5 = serializerSystem.serialize(ex);
            logger.debug("[ExprRewrite Phase 5]: " + e5);
        } else {
            logger.debug("Done rewriting: ");
            logger.debug("" + et);
            logger.debug("" + e4.getProjection());
        }
    }

    public static void main(String[] args) throws IOException {
        RdfViewSystemOld.initSparqlifyFunctions();
        TypeSystem typeSystem = NewWorldTest.createDefaultDatatypeSystem();
        System.out.println("Yay so far");
    }
}

