/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.cast;

import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.QuadPattern;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.Expr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.jena_sparql_api.utils.QuadUtils;
import org.aksw.sparqlify.algebra.sql.exprs2.S_ColumnRef;
import org.aksw.sparqlify.algebra.sql.exprs2.S_IsNotNull;
import org.aksw.sparqlify.algebra.sql.exprs2.SqlExpr;
import org.aksw.sparqlify.algebra.sql.nodes.Schema;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOp;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpFilter;
import org.aksw.sparqlify.core.TypeToken;
import org.aksw.sparqlify.core.domain.input.Mapping;
import org.aksw.sparqlify.core.domain.input.RestrictedExpr;
import org.aksw.sparqlify.core.domain.input.VarDefinition;
import org.aksw.sparqlify.core.domain.input.ViewDefinition;
import org.aksw.sparqlify.util.QuadPatternUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EffectiveViewGenerator {
    private static final Logger logger = LoggerFactory.getLogger(EffectiveViewGenerator.class);

    public static boolean isNullable(Expr expr, Schema schema) {
        boolean result = false;
        Set exprVars = expr.getVarsMentioned();
        for (Var columnRef : exprVars) {
            String columnName = columnRef.getName();
            boolean isNullable = schema.isNullable(columnName);
            if (!isNullable) continue;
            result = true;
            break;
        }
        return result;
    }

    public List<ViewDefinition> transformDummy(ViewDefinition viewDef) {
        Set<ViewDefinition> tmp = Collections.singleton(viewDef);
        ArrayList<ViewDefinition> result = new ArrayList<ViewDefinition>(tmp);
        return result;
    }

    public static List<ViewDefinition> createQuadMaps(ViewDefinition viewDef) {
        ArrayList<ViewDefinition> result = new ArrayList<ViewDefinition>();
        SqlOp sqlOp = viewDef.getMapping().getSqlOp();
        QuadPattern qp = viewDef.getTemplate();
        for (Quad q : qp.getList()) {
            Set vars = QuadUtils.getVarsMentioned((Quad)q);
            VarDefinition newVarDef = viewDef.getVarDefinition().copyProject(vars);
            SqlOp newSqlOp = EffectiveViewGenerator.createMinimalSchema(sqlOp, newVarDef);
            String newName = viewDef.getName() + "_" + q;
            QuadPattern newTemplate = new QuadPattern();
            newTemplate.add(q);
            Mapping newMapping = new Mapping(newVarDef, newSqlOp);
            ViewDefinition newViewDef = new ViewDefinition(newName, newTemplate, null, newMapping, viewDef);
            result.add(newViewDef);
        }
        return result;
    }

    public static SqlOp createMinimalSchema(SqlOp sqlOp, VarDefinition varDef) {
        Schema newSchema;
        List<String> refs = varDef.getReferencedNames();
        try {
            newSchema = sqlOp.getSchema().createSubSchema(refs);
        }
        catch (Exception e) {
            throw new RuntimeException("Error processing sqlOp " + sqlOp + ", reason: " + e.getMessage(), e);
        }
        SqlOp result = sqlOp.copy(newSchema, null);
        return result;
    }

    public List<ViewDefinition> transform(ViewDefinition viewDef) {
        ArrayList<ViewDefinition> result = new ArrayList<ViewDefinition>();
        List<ViewDefinition> tmp = EffectiveViewGenerator.createQuadMaps(viewDef);
        for (ViewDefinition t : tmp) {
            List<ViewDefinition> x = this.addNullConstraints(t);
            result.addAll(x);
        }
        return result;
    }

    public List<ViewDefinition> addNullConstraints(ViewDefinition viewDef) {
        ArrayList<ViewDefinition> result = new ArrayList<ViewDefinition>();
        boolean disableNullableTransform = false;
        if (disableNullableTransform) {
            result.add(viewDef);
            return result;
        }
        Mapping mapping = viewDef.getMapping();
        VarDefinition varDef = mapping.getVarDefinition();
        SqlOp sqlOp = mapping.getSqlOp();
        Schema schema = sqlOp.getSchema();
        Map map = varDef.getMap().asMap();
        HashSet<Var> nullableVars = new HashSet<Var>();
        HashSet<Expr> nullableExprs = new HashSet<Expr>();
        for (Map.Entry entry : map.entrySet()) {
            Var var = (Var)entry.getKey();
            Collection restExprs = (Collection)entry.getValue();
            boolean areExprsNullable = false;
            for (RestrictedExpr restExpr : restExprs) {
                Expr expr = restExpr.getExpr();
                boolean testNullable = EffectiveViewGenerator.isNullable(expr, schema);
                if (!testNullable) continue;
                nullableExprs.add(expr);
                areExprsNullable = true;
                break;
            }
            if (!areExprsNullable) continue;
            nullableVars.add(var);
        }
        HashMap exprToConds = new HashMap();
        for (Expr nullableExpr : nullableExprs) {
            ArrayList<S_IsNotNull> sqlExprs = new ArrayList<S_IsNotNull>();
            Set columnVars = nullableExpr.getVarsMentioned();
            for (Var columnVar : columnVars) {
                String columnName = columnVar.getName();
                if (!schema.isNullable(columnName)) continue;
                TypeToken typeToken = sqlOp.getSchema().getColumnType(columnName);
                S_ColumnRef columnRef = new S_ColumnRef(typeToken, columnName);
                S_IsNotNull sqlExpr = new S_IsNotNull(columnRef);
                sqlExprs.add(sqlExpr);
            }
            exprToConds.put(nullableExpr, sqlExprs);
        }
        HashMultimap groups = HashMultimap.create();
        QuadPattern template = viewDef.getTemplate();
        for (Quad quad : template) {
            HashSet<Var> groupNullableVars = new HashSet<Var>();
            for (int i = 0; i < 4; ++i) {
                Var var;
                Node node = QuadUtils.getNode((Quad)quad, (int)i);
                if (!node.isVariable() || !nullableVars.contains(var = (Var)node)) continue;
                groupNullableVars.add(var);
            }
            groups.put(groupNullableVars, (Object)quad);
        }
        for (Map.Entry group : groups.asMap().entrySet()) {
            Set nullables = (Set)group.getKey();
            Collection quads = (Collection)group.getValue();
            QuadPattern newTemplate = QuadPatternUtils.create(quads);
            String newName = viewDef.getName() + "?nullables=" + Joiner.on((String)",").join((Iterable)nullables);
            Set templateVars = QuadUtils.getVarsMentioned((QuadPattern)newTemplate);
            HashMultimap newVarDefMap = HashMultimap.create();
            for (Var templateVar : templateVars) {
                Collection<RestrictedExpr> restExprs = varDef.getDefinitions(templateVar);
                newVarDefMap.putAll((Object)templateVar, restExprs);
            }
            VarDefinition newVarDef = new VarDefinition((Multimap<Var, RestrictedExpr>)newVarDefMap);
            HashSet notNullVars = new HashSet();
            HashSet ands = new HashSet();
            for (Var nullVar : nullables) {
                Collection<RestrictedExpr> restExprs = newVarDef.getDefinitions(nullVar);
                for (RestrictedExpr restExpr : restExprs) {
                    Expr expr = restExpr.getExpr();
                    List conds = (List)exprToConds.get(expr);
                    ands.addAll(conds);
                }
            }
            ArrayList<SqlExpr> conds = new ArrayList<SqlExpr>(ands);
            SqlOp baseOp = EffectiveViewGenerator.createMinimalSchema(sqlOp, newVarDef);
            SqlOp newSqlOp = !conds.isEmpty() ? SqlOpFilter.createIfNeeded(baseOp, conds) : baseOp;
            Mapping newMapping = new Mapping(newVarDef, newSqlOp);
            ViewDefinition newViewDef = new ViewDefinition(newName, newTemplate, null, newMapping, viewDef);
            result.add(newViewDef);
        }
        for (ViewDefinition viewDefinition : result) {
            logger.debug("Effective View:\n" + viewDefinition);
        }
        return result;
    }
}

