/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.algorithms;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.E_StrConcat;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.aksw.sparqlify.algebra.sparql.expr.E_RdfTerm;
import org.aksw.sparqlify.algebra.sparql.expr.E_StrConcatPermissive;
import org.aksw.sparqlify.config.lang.PrefixSet;
import org.aksw.sparqlify.core.algorithms.ViewDefinitionNormalizer;
import org.aksw.sparqlify.core.domain.input.Mapping;
import org.aksw.sparqlify.core.domain.input.RestrictedExpr;
import org.aksw.sparqlify.core.domain.input.VarDefinition;
import org.aksw.sparqlify.core.domain.input.ViewDefinition;
import org.aksw.sparqlify.core.transformations.SqlTranslationUtils;
import org.aksw.sparqlify.expr.util.NodeValueUtils;
import org.aksw.sparqlify.restriction.RdfTermType;
import org.aksw.sparqlify.restriction.RestrictionImpl;
import org.aksw.sparqlify.restriction.RestrictionManagerImpl;
import org.aksw.sparqlify.restriction.RestrictionSetImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewDefinitionNormalizerImpl
implements ViewDefinitionNormalizer<ViewDefinition> {
    private static final Logger logger = LoggerFactory.getLogger(ViewDefinitionNormalizer.class);

    @Override
    public RestrictedExpr normalize(RestrictedExpr restExpr) {
        RestrictionSetImpl rs = restExpr.getRestrictions();
        rs = rs == null ? new RestrictionSetImpl() : restExpr.getRestrictions().clone();
        Expr expr = restExpr.getExpr();
        RdfTermType type = ViewDefinitionNormalizerImpl.deriveType(expr);
        if (type != null) {
            rs.stateType(type);
        }
        String prefix = ViewDefinitionNormalizerImpl.derivePrefix(expr);
        if (RdfTermType.URI.equals((Object)type) && prefix != null) {
            PrefixSet ps = new PrefixSet(prefix);
            rs.stateUriPrefixes(ps);
        }
        if (rs.isUnsatisfiable()) {
            System.err.println("Unsatisfiable restriction detected: " + restExpr);
            throw new RuntimeException("Unsatisfiable restriction detected: " + restExpr);
        }
        RestrictedExpr result = new RestrictedExpr(expr, rs);
        return result;
    }

    @Override
    public VarDefinition normalize(VarDefinition varDef) {
        HashMultimap resultMap = HashMultimap.create();
        for (Map.Entry entry : varDef.getMap().entries()) {
            Var var = (Var)entry.getKey();
            RestrictedExpr old = (RestrictedExpr)entry.getValue();
            RestrictedExpr newRestExpr = this.normalize(old);
            resultMap.put((Object)var, (Object)newRestExpr);
        }
        VarDefinition result = new VarDefinition((Multimap<Var, RestrictedExpr>)resultMap);
        return result;
    }

    public RestrictionManagerImpl createVarRestrictions(VarDefinition varDef) {
        RestrictionManagerImpl result = new RestrictionManagerImpl();
        for (Map.Entry entry : varDef.getMap().asMap().entrySet()) {
            Var var = (Var)entry.getKey();
            Collection restExprs = (Collection)entry.getValue();
            int m = restExprs.size();
            if (m == 1) {
                RestrictedExpr restExpr = (RestrictedExpr)restExprs.iterator().next();
                RestrictionSetImpl rs = restExpr.getRestrictions();
                int n = rs.getRestrictions().size();
                if (n == 1) {
                    RestrictionImpl r = rs.getRestrictions().iterator().next();
                    result.stateRestriction(var, r);
                    continue;
                }
                if (n <= 1) continue;
                logger.warn("More than 1 restriction found; having to ignore all for now: " + rs);
                continue;
            }
            if (m <= 1) continue;
            logger.warn("More than 1 definition found; can't derive restrictions because of that: " + restExprs);
        }
        return result;
    }

    @Override
    public ViewDefinition normalize(ViewDefinition viewDefinition) {
        VarDefinition normVarDef = this.normalize(viewDefinition.getMapping().getVarDefinition());
        RestrictionManagerImpl restrictionManager = this.createVarRestrictions(normVarDef);
        Mapping newMapping = new Mapping(normVarDef, viewDefinition.getMapping().getSqlOp());
        ViewDefinition result = new ViewDefinition(viewDefinition.getName(), viewDefinition.getTemplate(), viewDefinition.getViewReferences(), newMapping, restrictionManager, viewDefinition);
        return result;
    }

    public static String derivePrefixConcat(ExprFunction concat) {
        Expr arg;
        String prefix = "";
        Iterator i$ = concat.getArgs().iterator();
        while (i$.hasNext() && (arg = (Expr)i$.next()).isConstant()) {
            prefix = prefix + arg.getConstant().asUnquotedString();
        }
        return prefix;
    }

    public static String derivePrefix(E_RdfTerm termCtor) {
        Expr expr = (Expr)termCtor.getArgs().get(1);
        String result = expr instanceof E_StrConcat || expr instanceof E_StrConcatPermissive ? ViewDefinitionNormalizerImpl.derivePrefixConcat(expr.getFunction()) : null;
        return result;
    }

    public static String derivePrefix(ExprFunction fn) {
        E_RdfTerm termCtor = SqlTranslationUtils.expandRdfTerm(fn);
        String result = termCtor != null ? ViewDefinitionNormalizerImpl.derivePrefix(termCtor) : null;
        return result;
    }

    public static String derivePrefix(Node node) {
        String result = node.isURI() ? node.getURI() : null;
        return result;
    }

    public static String derivePrefix(Expr expr) {
        String result = expr.isFunction() ? ViewDefinitionNormalizerImpl.derivePrefix(expr.getFunction()) : (expr.isConstant() ? ViewDefinitionNormalizerImpl.derivePrefix(expr.getConstant().getNode()) : null);
        return result;
    }

    public static RdfTermType deriveType(Node node) {
        if (node.isURI()) {
            return RdfTermType.URI;
        }
        if (node.isLiteral()) {
            return RdfTermType.LITERAL;
        }
        if (node.isBlank()) {
            throw new RuntimeException("Decide on what to return here.");
        }
        return RdfTermType.UNKNOWN;
    }

    public static RdfTermType deriveType(E_RdfTerm termCtor) {
        Expr arg = termCtor.getArg(1);
        if (arg.isConstant()) {
            Object o = NodeValueUtils.getValue(arg.getConstant());
            Number number = (Number)o;
            switch (number.intValue()) {
                case 1: {
                    return RdfTermType.URI;
                }
                case 2: 
                case 3: {
                    return RdfTermType.LITERAL;
                }
            }
        }
        return RdfTermType.UNKNOWN;
    }

    public static RdfTermType deriveType(ExprFunction fn) {
        E_RdfTerm termCtor = SqlTranslationUtils.expandRdfTerm(fn);
        RdfTermType result = termCtor != null ? ViewDefinitionNormalizerImpl.deriveType(termCtor) : RdfTermType.UNKNOWN;
        return result;
    }

    public static RdfTermType deriveType(Expr expr) {
        RdfTermType result = null;
        if (expr.isConstant()) {
            result = ViewDefinitionNormalizerImpl.deriveType(expr.getConstant().asNode());
        } else if (expr.isFunction()) {
            result = ViewDefinitionNormalizerImpl.deriveType(expr.getFunction());
        }
        return result;
    }
}

