/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.algorithms;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.Var;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.collections.multimaps.BiHashMultimap;
import org.aksw.commons.collections.multimaps.IBiSetMultimap;
import org.aksw.jena_sparql_api.utils.QuadUtils;
import org.aksw.sparqlify.core.algorithms.BindingVal;

public class VarBinding {
    private Map<Var, Integer> keyToToken = new HashMap<Var, Integer>();
    private Map<Var, Integer> valueToToken = new HashMap<Var, Integer>();
    private Map<Integer, BindingVal> tokenToSet = new HashMap<Integer, BindingVal>();
    private int nextToken;

    public Map<Var, Node> getQueryVarToConstant() {
        HashMap<Var, Node> result = new HashMap<Var, Node>();
        for (Map.Entry<Var, Integer> entry : this.keyToToken.entrySet()) {
            Var value = entry.getKey();
            Integer token = entry.getValue();
            BindingVal val = this.tokenToSet.get(token);
            Node constant = (Node)val.getValue();
            result.put(value, constant);
        }
        return result;
    }

    public IBiSetMultimap<Var, Var> getQueryVarToViewVars() {
        BiHashMultimap result = new BiHashMultimap();
        for (Map.Entry<Var, Integer> entry : this.keyToToken.entrySet()) {
            Var value = entry.getKey();
            Integer token = entry.getValue();
            BindingVal val = this.tokenToSet.get(token);
            Set keys = val.getKeys();
            result.putAll((Object)value, keys);
        }
        return result;
    }

    public IBiSetMultimap<Var, Var> getViewVarToQueryVars() {
        IBiSetMultimap<Var, Var> tmp = this.getQueryVarToViewVars();
        IBiSetMultimap result = tmp.getInverse();
        return result;
    }

    public Set<Var> getQueryVars() {
        return this.keyToToken.keySet();
    }

    public Set<Var> getViewVars(Var queryVar) {
        BindingVal tmp = this.get(queryVar);
        if (tmp == null) {
            return null;
        }
        return tmp.getKeys();
    }

    public Node getConstant(Var queryVar) {
        BindingVal tmp = this.get(queryVar);
        if (tmp == null) {
            return null;
        }
        return (Node)tmp.getValue();
    }

    public BindingVal get(Var queryVar) {
        Integer token = this.keyToToken.get(queryVar);
        if (token == null) {
            return null;
        }
        BindingVal result = this.tokenToSet.get(token);
        return result;
    }

    public boolean put(Var queryVar, Var viewVar) {
        Integer keyToken = this.keyToToken.get(queryVar);
        Integer valueToken = this.valueToToken.get(viewVar);
        if (valueToken == null) {
            if (keyToken == null) {
                Integer token = this.nextToken++;
                this.valueToToken.put(viewVar, token);
                this.keyToToken.put(queryVar, token);
                BindingVal val = new BindingVal();
                val.getKeys().add(viewVar);
                this.tokenToSet.put(token, val);
            } else {
                this.valueToToken.put(viewVar, keyToken);
                BindingVal val = this.tokenToSet.get(keyToken);
                val.getKeys().add(viewVar);
            }
        } else if (keyToken == null) {
            this.keyToToken.put(queryVar, valueToken);
        } else {
            Node res;
            if (keyToken.equals(valueToken)) {
                return true;
            }
            BindingVal a = this.tokenToSet.get(keyToken);
            BindingVal b = this.tokenToSet.get(valueToken);
            Node valA = (Node)a.getValue();
            Node valB = (Node)b.getValue();
            Node node = res = valA == null ? valB : valB;
            if (valB != null && valB != res) {
                return false;
            }
            a.setValue(res);
            for (Var vv : b.getKeys()) {
                this.valueToToken.put(vv, keyToken);
            }
            this.tokenToSet.remove(valueToken);
            a.getKeys().addAll(b.getKeys());
        }
        return true;
    }

    public boolean put(Var queryVar, Node node) {
        if (node == null) {
            return true;
        }
        if (node.isVariable()) {
            return this.put(queryVar, (Var)node);
        }
        Integer token = this.keyToToken.get(queryVar);
        if (token == null) {
            token = this.nextToken++;
            this.keyToToken.put(queryVar, token);
            BindingVal val = new BindingVal();
            this.tokenToSet.put(token, val);
            val.setValue(node);
            return true;
        }
        BindingVal val = this.tokenToSet.get(token);
        Node existing = (Node)val.getValue();
        if (existing == null) {
            val.setValue(node);
            return true;
        }
        return existing.equals((Object)node);
    }

    public void putAll(VarBinding that) {
        for (Map.Entry entry : that.getQueryVarToViewVars().entries()) {
            this.put((Var)entry.getKey(), (Var)entry.getValue());
        }
        for (Map.Entry entry : that.getQueryVarToConstant().entrySet()) {
            this.put((Var)entry.getKey(), (Node)entry.getValue());
        }
    }

    public static VarBinding create(Quad a, Quad b) {
        VarBinding result = new VarBinding();
        List nAs = QuadUtils.quadToList((Quad)a);
        List nBs = QuadUtils.quadToList((Quad)b);
        for (int i = 0; i < 4; ++i) {
            Node nB;
            Var nA = (Var)nAs.get(i);
            if (result.put(nA, nB = (Node)nBs.get(i))) continue;
            return null;
        }
        return result;
    }

    public String toString() {
        String result = "{";
        boolean isFirst = true;
        for (Map.Entry<Var, Integer> entry : this.keyToToken.entrySet()) {
            Var key = entry.getKey();
            Integer token = entry.getValue();
            BindingVal val = this.tokenToSet.get(token);
            if (isFirst) {
                isFirst = false;
            } else {
                result = result + ", ";
            }
            result = result + key + ": (" + token + ")" + val;
        }
        result = result + "}";
        return result;
    }
}

