/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.algorithms;

import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.Expr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.aksw.commons.collections.CartesianProduct;
import org.aksw.sparqlify.core.TypeToken;
import org.aksw.sparqlify.core.algorithms.ExprDatatypeNorm;
import org.aksw.sparqlify.core.domain.input.Mapping;
import org.aksw.sparqlify.core.domain.input.RestrictedExpr;
import org.aksw.sparqlify.core.domain.input.VarDefinition;

public class MappingRefactor {
    public static ListMultimap<String, Mapping> groupBy(ExprDatatypeNorm exprNormalizer, List<Mapping> ms, List<Var> vars) {
        LinkedListMultimap cluster = LinkedListMultimap.create();
        for (Mapping m : ms) {
            Map<String, TypeToken> tmpTypeMap = m.getSqlOp().getSchema().getTypeMap();
            ArrayList<String> hashes = new ArrayList<String>(vars.size());
            for (Var var : vars) {
                String hash;
                Expr expr;
                Collection<RestrictedExpr> defs = m.getVarDefinition().getDefinitions(var);
                if (defs.size() > 1) {
                    throw new RuntimeException("Encountered multiple variable definitions during group by. Var: " + var + ", Mapping: " + m);
                }
                if (defs.isEmpty()) {
                    expr = null;
                } else {
                    RestrictedExpr restExpr = defs.iterator().next();
                    expr = restExpr.getExpr();
                }
                if (expr == null) {
                    hash = "null";
                } else {
                    Expr datatypeNorm = exprNormalizer.normalize(expr, tmpTypeMap);
                    hash = datatypeNorm.toString();
                }
                hashes.add(hash);
            }
            String key = Joiner.on((String)",").join(hashes);
            cluster.put((Object)key, (Object)m);
        }
        return cluster;
    }

    public static List<Mapping> refactorToUnion(Mapping m, List<Var> tmpVars) {
        ArrayList<Mapping> result = new ArrayList<Mapping>();
        VarDefinition varDef = m.getVarDefinition();
        ArrayList<Var> vars = new ArrayList<Var>(tmpVars.size());
        ArrayList<Collection<RestrictedExpr>> c = new ArrayList<Collection<RestrictedExpr>>(tmpVars.size());
        if (tmpVars.isEmpty()) {
            result.add(m);
            return result;
        }
        for (Var var : tmpVars) {
            Collection<RestrictedExpr> defs = varDef.getDefinitions(var);
            if (defs.isEmpty()) continue;
            vars.add(var);
            c.add(defs);
        }
        HashMultimap baseMap = HashMultimap.create(varDef.getMap());
        baseMap.keySet().removeAll(vars);
        CartesianProduct cart = CartesianProduct.create(c);
        for (List item : cart) {
            HashMultimap map = HashMultimap.create(varDef.getMap());
            for (int i = 0; i < vars.size(); ++i) {
                Var var = (Var)vars.get(i);
                RestrictedExpr restExpr = (RestrictedExpr)item.get(i);
                map.put((Object)var, (Object)restExpr);
            }
            VarDefinition newVd = new VarDefinition((Multimap<Var, RestrictedExpr>)map);
            Mapping newM = new Mapping(newVd, m.getSqlOp());
            result.add(newM);
        }
        return result;
    }
}

