/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.algorithms;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.op.Op1;
import com.hp.hpl.jena.sparql.algebra.op.OpAssign;
import com.hp.hpl.jena.sparql.algebra.op.OpConditional;
import com.hp.hpl.jena.sparql.algebra.op.OpDisjunction;
import com.hp.hpl.jena.sparql.algebra.op.OpDistinct;
import com.hp.hpl.jena.sparql.algebra.op.OpExtend;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpGroup;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpLeftJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpN;
import com.hp.hpl.jena.sparql.algebra.op.OpOrder;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpSequence;
import com.hp.hpl.jena.sparql.algebra.op.OpSlice;
import com.hp.hpl.jena.sparql.algebra.op.OpTopN;
import com.hp.hpl.jena.sparql.algebra.op.OpUnion;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.QuadPattern;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.expr.E_Equals;
import com.hp.hpl.jena.sparql.expr.E_StrConcat;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.aksw.commons.collections.CartesianProduct;
import org.aksw.commons.util.Pair;
import org.aksw.commons.util.strings.StringUtils;
import org.aksw.jena_sparql_api.utils.QuadUtils;
import org.aksw.sparqlify.algebra.sparql.domain.OpRdfViewPattern;
import org.aksw.sparqlify.algebra.sparql.expr.E_StrConcatPermissive;
import org.aksw.sparqlify.config.lang.PrefixSet;
import org.aksw.sparqlify.core.ReplaceConstants;
import org.aksw.sparqlify.core.algorithms.NestedStack;
import org.aksw.sparqlify.core.algorithms.OpMapping;
import org.aksw.sparqlify.core.algorithms.OpViewInstanceJoin;
import org.aksw.sparqlify.core.algorithms.Ops;
import org.aksw.sparqlify.core.algorithms.RecursionResult;
import org.aksw.sparqlify.core.algorithms.UnsatisfiabilityException;
import org.aksw.sparqlify.core.algorithms.VarBinding;
import org.aksw.sparqlify.core.algorithms.ViewInstance;
import org.aksw.sparqlify.core.algorithms.ViewInstanceJoin;
import org.aksw.sparqlify.core.algorithms.ViewQuad;
import org.aksw.sparqlify.core.domain.input.RestrictedExpr;
import org.aksw.sparqlify.core.domain.input.VarDefinition;
import org.aksw.sparqlify.core.interfaces.CandidateViewSelector;
import org.aksw.sparqlify.core.interfaces.IViewDef;
import org.aksw.sparqlify.database.Clause;
import org.aksw.sparqlify.database.Constraint;
import org.aksw.sparqlify.database.EqualsConstraint;
import org.aksw.sparqlify.database.FilterPlacementOptimizer2;
import org.aksw.sparqlify.database.FilterSplit;
import org.aksw.sparqlify.database.IndexMetaNode;
import org.aksw.sparqlify.database.IsPrefixOfConstraint;
import org.aksw.sparqlify.database.MetaIndexFactory;
import org.aksw.sparqlify.database.NestedNormalForm;
import org.aksw.sparqlify.database.OpFilterIndexed;
import org.aksw.sparqlify.database.PrefixIndex;
import org.aksw.sparqlify.database.PrefixIndexMetaFactory;
import org.aksw.sparqlify.database.StartsWithConstraint;
import org.aksw.sparqlify.database.Table;
import org.aksw.sparqlify.database.TableBuilder;
import org.aksw.sparqlify.database.TreeIndex;
import org.aksw.sparqlify.database.VariableConstraint;
import org.aksw.sparqlify.expr.util.NodeValueUtils;
import org.aksw.sparqlify.restriction.RdfTermType;
import org.aksw.sparqlify.restriction.RestrictionImpl;
import org.aksw.sparqlify.restriction.RestrictionManagerImpl;
import org.apache.commons.collections15.Transformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CandidateViewSelectorBase<T extends IViewDef, C>
implements CandidateViewSelector<T> {
    private static Logger logger = LoggerFactory.getLogger(CandidateViewSelectorBase.class);
    private int viewId = 1;
    private Table<Object> table;
    private PrefixIndex<Object> idxTest;
    private List<T> views = new ArrayList<T>();
    private static final String[] columnNames = new String[]{"g_prefix", "s_prefix", "p_prefix", "o_prefix"};

    public CandidateViewSelectorBase() {
        TableBuilder<Object> builder = new TableBuilder<Object>();
        builder.addColumn("g_prefix", String.class);
        builder.addColumn("s_prefix", String.class);
        builder.addColumn("p_prefix", String.class);
        builder.addColumn("o_type", Integer.class);
        builder.addColumn("o_prefix", String.class);
        builder.addColumn("view", ViewQuad.class);
        this.table = builder.create();
        Transformer<Object, Set<String>> prefixExtractor = new Transformer<Object, Set<String>>(){

            public Set<String> transform(Object input) {
                return Collections.singleton(input.toString());
            }
        };
        PrefixIndexMetaFactory factory = new PrefixIndexMetaFactory(prefixExtractor);
        IndexMetaNode root = IndexMetaNode.create(this.table, (MetaIndexFactory)factory, "s_prefix");
        IndexMetaNode s = IndexMetaNode.create(root, (MetaIndexFactory)factory, "p_prefix");
        TreeIndex.attach(this.table, root);
        IndexMetaNode root2 = IndexMetaNode.create(this.table, (MetaIndexFactory)factory, "p_prefix");
        IndexMetaNode s2 = IndexMetaNode.create(root2, (MetaIndexFactory)factory, "s_prefix");
        TreeIndex.attach(this.table, root2);
    }

    public abstract Op createOp(OpQuadPattern var1, List<RecursionResult<T, C>> var2);

    public C createContext(C baseContext, ViewInstance<T> viewInstance) throws UnsatisfiabilityException {
        return baseContext;
    }

    @Override
    public void addView(T viewDef) {
        ++this.viewId;
        Set vars = QuadUtils.getVarsMentioned((QuadPattern)viewDef.getTemplate());
        HashMap<Var, Var> oldToNew = new HashMap<Var, Var>();
        for (Var var : vars) {
            oldToNew.put(var, Var.alloc((String)("view" + this.viewId + "_" + var.getName())));
        }
        IViewDef copy = viewDef.copyRenameVars(oldToNew);
        this.index(copy);
    }

    public static Constraint deriveConstraint(Expr expr) {
        if (expr instanceof E_StrConcat || expr instanceof E_StrConcatPermissive) {
            return CandidateViewSelectorBase.deriveConstraint(expr);
        }
        return null;
    }

    public static StartsWithConstraint deriveConstraint(E_StrConcat expr) {
        return CandidateViewSelectorBase.deriveConstraint(expr);
    }

    public static StartsWithConstraint deriveConstraint(E_StrConcatPermissive expr) {
        return CandidateViewSelectorBase.deriveConstraint(expr);
    }

    public static RdfTermType getType(Node node, RestrictionManagerImpl restrictions) {
        if (node.isVariable()) {
            RestrictionImpl r = restrictions.getRestriction((Var)node);
            if (r != null) {
                return r.getType();
            }
        } else {
            if (node.isURI()) {
                return RdfTermType.URI;
            }
            if (node.isLiteral()) {
                return RdfTermType.LITERAL;
            }
        }
        return RdfTermType.UNKNOWN;
    }

    public T normalizeView(T view) {
        return view;
    }

    private void index(T view) {
        T normalized = this.normalizeView(view);
        RestrictionManagerImpl varRestrictions = normalized.getVarRestrictions();
        this.views.add(normalized);
        for (Quad quad : normalized.getTemplate()) {
            ArrayList<Collection<Object>> collections = new ArrayList<Collection<Object>>();
            for (int i = 0; i < 4; ++i) {
                Node node = QuadUtils.getNode((Quad)quad, (int)i);
                if (i == 3) {
                    RdfTermType type = CandidateViewSelectorBase.getType(node, varRestrictions);
                    switch (type) {
                        case URI: {
                            collections.add(Collections.singleton(1));
                            break;
                        }
                        case LITERAL: {
                            collections.add(Collections.singleton(2));
                            break;
                        }
                        default: {
                            collections.add(Arrays.asList(1, 2));
                        }
                    }
                }
                if (node.isVariable()) {
                    Var var = (Var)node;
                    PrefixSet p = null;
                    VarDefinition varDefinition = normalized.getVarDefinition();
                    if (varDefinition != null) {
                        Collection<RestrictedExpr> restExprs = varDefinition.getDefinitions(var);
                        for (RestrictedExpr restExpr : restExprs) {
                            PrefixSet tmp = restExpr.getRestrictions().getUriPrefixes();
                            if (p == null) {
                                p = tmp;
                                continue;
                            }
                            p.addAll(tmp);
                        }
                    }
                    if (p != null) {
                        collections.add(p.getSet());
                        continue;
                    }
                    collections.add(Collections.singleton(""));
                    continue;
                }
                if (!node.isURI()) continue;
                collections.add(Collections.singleton(node.getURI()));
            }
            ViewQuad<T> viewQuad = new ViewQuad<T>(normalized, quad);
            CartesianProduct cartesian = new CartesianProduct(collections);
            for (List item : cartesian) {
                ArrayList<ViewQuad<T>> row = new ArrayList<ViewQuad<T>>(item);
                row.add(viewQuad);
                this.table.add(row);
            }
        }
    }

    @Override
    public Op getApplicableViews(Query query) {
        Op optimizedFilters;
        Op op = Algebra.compile((Query)query);
        op = Algebra.toQuadForm((Op)op);
        if (query.isSelectType() && query.isQueryResultStar()) {
            List vars = query.getProjectVars();
            op = new OpProject(op, vars);
        }
        logger.warn("JENA'S ALGEBRA OPTIMIZATION DISABLED");
        op = ReplaceConstants.replace(op);
        Op augmented = this._getApplicableViews(op);
        Op result = optimizedFilters = FilterPlacementOptimizer2.optimize(augmented);
        return result;
    }

    public static VariableConstraint deriveIsPrefixOfConstraint(Expr a, Expr b) {
        if (!a.isVariable() || !b.isConstant()) {
            return null;
        }
        Object value = NodeValueUtils.getValue(b.getConstant());
        return new VariableConstraint(a.getVarName(), new IsPrefixOfConstraint(value.toString()));
    }

    public static VariableConstraint deriveViewLookupConstraint(Expr expr) {
        if (expr instanceof E_Equals) {
            E_Equals e = (E_Equals)expr;
            VariableConstraint c = CandidateViewSelectorBase.deriveIsPrefixOfConstraint(e.getArg1(), e.getArg2());
            if (c == null) {
                c = CandidateViewSelectorBase.deriveIsPrefixOfConstraint(e.getArg2(), e.getArg1());
            }
            return c;
        }
        return null;
    }

    public List<RecursionResult<T, C>> getApplicableViewsBase(OpQuadPattern op, RestrictionManagerImpl restrictions) {
        ArrayList<RecursionResult<T, C>> result = new ArrayList<RecursionResult<T, C>>();
        QuadPattern queryQuads = op.getPattern();
        Pair<NavigableMap<Integer, Set<Quad>>, Map<Quad, Set<ViewQuad<T>>>> candidates = this.findQuadWithFewestViewCandidates(queryQuads, restrictions);
        NavigableMap nToQuads = (NavigableMap)candidates.getKey();
        Map quadToCandidates = (Map)candidates.getValue();
        ArrayList<Quad> order = new ArrayList<Quad>();
        for (Set quads : nToQuads.values()) {
            order.addAll(quads);
        }
        Set viewQuads = (Set)quadToCandidates.get(order.get(0));
        this.getApplicableViewsRec2(0, order, viewQuads, quadToCandidates, restrictions, null, result, null);
        return result;
    }

    public Map<String, Constraint> inferColumnConstraints(Quad quad, RestrictionImpl[] termRestriction, Clause clause) {
        HashMap<String, Constraint> result = new HashMap<String, Constraint>();
        boolean isUnsatisfiable = false;
        for (int i = 0; i < 4; ++i) {
            RestrictionImpl r;
            Node n = QuadUtils.getNode((Quad)quad, (int)i);
            Var var = (Var)n;
            RestrictionImpl clauseRest = clause.getRestriction(var);
            RestrictionImpl bindRest = termRestriction[i];
            if (bindRest == null) {
                r = clauseRest;
            } else if (clauseRest != null) {
                r = bindRest.clone();
                r.stateRestriction(clauseRest);
            } else {
                r = null;
            }
            if (r == null) continue;
            if (r.isUnsatisfiable()) {
                isUnsatisfiable = true;
                break;
            }
            termRestriction[i] = r;
            if (!r.getRdfTermTypes().contains((Object)RdfTermType.URI) || !r.hasConstant()) continue;
            String columnName = columnNames[i];
            result.put(columnName, new IsPrefixOfConstraint(r.getNode().getURI()));
        }
        if (isUnsatisfiable) {
            return null;
        }
        RestrictionImpl r = termRestriction[3];
        if (r != null) {
            switch (r.getType()) {
                case URI: {
                    result.put("o_type", new EqualsConstraint(1));
                    break;
                }
                case LITERAL: {
                    result.put("o_type", new EqualsConstraint(2));
                }
            }
        }
        return result;
    }

    public Set<ViewQuad<T>> findCandidates(Quad quad, RestrictionManagerImpl restrictions) {
        HashSet constraints = new HashSet();
        Set quadVars = QuadUtils.getVarsMentioned((Quad)quad);
        Set<Clause> dnf = restrictions.getEffectiveDnf(quadVars);
        if (dnf.isEmpty()) {
            dnf = new HashSet<Clause>();
            dnf.add(new Clause());
        }
        Object[] baseTermRestriction = new RestrictionImpl[4];
        for (int i = 0; i < 4; ++i) {
            Node n = QuadUtils.getNode((Quad)quad, (int)i);
            Var var = (Var)n;
            RestrictionImpl r = restrictions.getRestriction(var);
            baseTermRestriction[i] = r;
        }
        logger.trace("\nTerm restrictions for " + quad + ":\n" + StringUtils.itemPerLine((Object[])baseTermRestriction));
        HashSet<ViewQuad<T>> result = new HashSet<ViewQuad<T>>();
        for (Clause clause : dnf) {
            ViewQuad viewQuad;
            RestrictionImpl[] termRestriction = (RestrictionImpl[])Arrays.copyOf(baseTermRestriction, baseTermRestriction.length);
            Map<String, Constraint> columnConstraints = this.inferColumnConstraints(quad, termRestriction, clause);
            if (columnConstraints == null) continue;
            HashSet<ViewQuad> viewQuads = new HashSet<ViewQuad>();
            if (constraints.isEmpty()) {
                constraints.add(new HashMap());
            }
            Collection<List<Object>> rows = this.table.select(columnConstraints);
            for (List<Object> row : rows) {
                viewQuad = (ViewQuad)row.get(row.size() - 1);
                viewQuads.add(viewQuad);
            }
            int filterCount = 0;
            Iterator itViewQuad = viewQuads.iterator();
            while (itViewQuad.hasNext()) {
                viewQuad = (ViewQuad)itViewQuad.next();
                Quad q = viewQuad.getQuad();
                boolean isUnsatisfiable = false;
                for (int i = 0; i < 4; ++i) {
                    RestrictionImpl viewRest;
                    RestrictionImpl queryRest = termRestriction[i];
                    Node n = QuadUtils.getNode((Quad)q, (int)i);
                    if (n.isVariable()) {
                        Var var = (Var)n;
                        viewRest = viewQuad.getView().getVarRestrictions().getRestriction(var);
                    } else if (n.isURI()) {
                        viewRest = new RestrictionImpl();
                        viewRest.stateNode(n);
                    } else {
                        viewRest = null;
                    }
                    if (viewRest == null || queryRest == null) continue;
                    RestrictionImpl tmp = viewRest.clone();
                    tmp.stateRestriction(queryRest);
                    if (!tmp.isUnsatisfiable()) continue;
                    isUnsatisfiable = true;
                    break;
                }
                if (!isUnsatisfiable) continue;
                ++filterCount;
                itViewQuad.remove();
            }
            int total = viewQuads.size() + filterCount;
            logger.debug(viewQuads.size() + " of " + total + " candidates remaining (" + filterCount + " filtered)");
            result.addAll(viewQuads);
        }
        logger.debug("Total number of candidates after " + dnf.size() + " clauses: " + result.size());
        return result;
    }

    public Pair<NavigableMap<Integer, Set<Quad>>, Map<Quad, Set<ViewQuad<T>>>> findQuadWithFewestViewCandidates(QuadPattern queryQuads, RestrictionManagerImpl restrictions) {
        TreeMap<Integer, HashSet<Quad>> nToQuads = new TreeMap<Integer, HashSet<Quad>>();
        HashMap<Quad, Set<ViewQuad<T>>> quadToCandidates = new HashMap<Quad, Set<ViewQuad<T>>>();
        for (Quad quad : queryQuads) {
            if (quadToCandidates.containsKey(quad)) continue;
            Set<ViewQuad<T>> viewQuads = this.findCandidates(quad, restrictions);
            int n = viewQuads.size();
            HashSet<Quad> nQuads = (HashSet<Quad>)nToQuads.get(n);
            if (nQuads == null) {
                nQuads = new HashSet<Quad>();
                nToQuads.put(n, nQuads);
            }
            nQuads.add(quad);
            quadToCandidates.put(quad, viewQuads);
        }
        return Pair.create(nToQuads, quadToCandidates);
    }

    public static <T extends IViewDef> List<String> getCandidateNames(NestedStack<ViewInstance<T>> instances) {
        ArrayList<String> viewNames = new ArrayList<String>();
        if (instances != null) {
            for (ViewInstance<T> instance : instances.asList()) {
                viewNames.add(instance.getViewDefinition().getName());
            }
        }
        return viewNames;
    }

    public static <T extends IViewDef> ViewInstance<T> createViewInstance(RestrictionManagerImpl subRestrictions, Quad queryQuad, ViewQuad<T> viewQuad) {
        RestrictionManagerImpl viewRestrictions = viewQuad.getView().getVarRestrictions();
        if (viewRestrictions == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < 4; ++i) {
            Var queryVar = (Var)QuadUtils.getNode((Quad)queryQuad, (int)i);
            Node viewNode = QuadUtils.getNode((Quad)viewQuad.getQuad(), (int)i);
            if (viewNode.isVariable()) {
                Var viewVar = (Var)viewNode;
                RestrictionImpl viewRs = viewRestrictions.getRestriction(viewVar);
                if (viewRs != null) {
                    subRestrictions.stateRestriction(queryVar, viewRs);
                }
                if (subRestrictions.isUnsatisfiable() || subRestrictions.isUnsatisfiable()) {
                    break;
                }
            } else {
                subRestrictions.stateNode(queryVar, viewNode);
            }
            if (subRestrictions.isUnsatisfiable()) break;
        }
        if (subRestrictions.isUnsatisfiable()) {
            return null;
        }
        VarBinding binding = VarBinding.create(queryQuad, viewQuad.getQuad());
        if (binding == null) {
            throw new RuntimeException("Null binding");
        }
        ViewInstance<T> instance = new ViewInstance<T>(viewQuad.getView(), binding);
        return instance;
    }

    public void getApplicableViewsRec2(int index, List<Quad> quadOrder, Set<ViewQuad<T>> viewQuads, Map<Quad, Set<ViewQuad<T>>> candidates, RestrictionManagerImpl restrictions, NestedStack<ViewInstance<T>> instances, List<RecursionResult<T, C>> result, C baseContext) {
        ArrayList<String> viewNames = new ArrayList<String>();
        if (instances != null) {
            for (ViewInstance<T> instance : instances.asList()) {
                viewNames.add(instance.getViewDefinition().getName());
            }
        }
        if (index >= quadOrder.size()) {
            throw new RuntimeException("Should not happen");
        }
        int nextIndex = index + 1;
        boolean isRecursionEnd = nextIndex == quadOrder.size();
        Quad queryQuad = quadOrder.get(index);
        Iterator<ViewQuad<T>> i$ = viewQuads.iterator();
        while (i$.hasNext()) {
            C nextContext;
            RestrictionManagerImpl subRestrictions = new RestrictionManagerImpl(restrictions);
            ViewQuad<T> viewQuad = i$.next();
            ViewInstance<T> viewInstance = CandidateViewSelectorBase.createViewInstance(subRestrictions, queryQuad, viewQuad);
            if (viewInstance == null) continue;
            NestedStack<ViewInstance<T>> nextInstances = new NestedStack<ViewInstance<T>>(instances, viewInstance);
            try {
                nextContext = this.createContext(baseContext, viewInstance);
            }
            catch (UnsatisfiabilityException e) {
                continue;
            }
            if (isRecursionEnd) {
                ViewInstanceJoin<T> viewConjunction = new ViewInstanceJoin<T>(nextInstances.asList(), subRestrictions);
                RecursionResult<T, C> recResult = RecursionResult.create(viewConjunction, nextContext);
                result.add(recResult);
                continue;
            }
            Quad nextQuad = quadOrder.get(nextIndex);
            Set<ViewQuad<T>> nextCandidates = this.findCandidates(nextQuad, subRestrictions);
            this.getApplicableViewsRec2(nextIndex, quadOrder, nextCandidates, candidates, subRestrictions, nextInstances, result, nextContext);
        }
    }

    public Op getApplicableViews(OpQuadPattern op, RestrictionManagerImpl restrictions) {
        List<RecursionResult<T, C>> conjuncions = this.getApplicableViewsBase(op, restrictions);
        Op result = this.createOp(op, conjuncions);
        return result;
    }

    public static <T extends IViewDef> boolean isSatisfiable(List<ViewInstance<T>> list) {
        return true;
    }

    public Op _getApplicableViews(Op op) {
        return this._getApplicableViews(op, new RestrictionManagerImpl());
    }

    public Op _getApplicableViews(Op op, RestrictionManagerImpl restrictions) {
        Op result;
        Ops type = Ops.valueOf(op.getClass().getSimpleName());
        switch (type) {
            case OpOrder: {
                result = this.getApplicableViews((OpOrder)op, restrictions);
                break;
            }
            case OpDistinct: {
                result = this.getApplicableViews((OpDistinct)op, restrictions);
                break;
            }
            case OpFilter: {
                result = this.getApplicableViews((OpFilter)op, restrictions);
                break;
            }
            case OpGroup: {
                result = this.getApplicableViews((OpGroup)op, restrictions);
                break;
            }
            case OpJoin: {
                result = this.getApplicableViews((OpJoin)op, restrictions);
                break;
            }
            case OpLeftJoin: {
                result = this.getApplicableViews((OpLeftJoin)op, restrictions);
                break;
            }
            case OpExtend: {
                result = this.getApplicableViews((OpExtend)op, restrictions);
                break;
            }
            case OpQuadPattern: {
                result = this.getApplicableViews((OpQuadPattern)op, restrictions);
                break;
            }
            case OpSlice: {
                result = this.getApplicableViews((OpSlice)op, restrictions);
                break;
            }
            case OpProject: {
                result = this.getApplicableViews((OpProject)op, restrictions);
                break;
            }
            case OpUnion: {
                result = this.getApplicableViews((OpUnion)op, restrictions);
                break;
            }
            default: {
                throw new RuntimeException("Unknown op type: " + op.getClass());
            }
        }
        return result;
    }

    public Op getApplicableViews(OpSequence op, RestrictionManagerImpl restrictions) {
        List members = op.getElements();
        ArrayList<Op> newMembers = new ArrayList<Op>(members.size());
        for (Op member : members) {
            Op newMember = this._getApplicableViews(member, restrictions);
            newMembers.add(newMember);
        }
        OpN result = OpSequence.create().copy(newMembers);
        return result;
    }

    public Op getApplicableViews(OpTopN op, RestrictionManagerImpl restrictions) {
        Op subOp = this._getApplicableViews(op.getSubOp(), restrictions);
        OpTopN result = new OpTopN(subOp, op.getLimit(), op.getConditions());
        return result;
    }

    public Op getApplicableViews(OpDisjunction op, RestrictionManagerImpl restrictions) {
        List members = op.getElements();
        ArrayList<Op> newMembers = new ArrayList<Op>(members.size());
        for (Op member : members) {
            Op newMember = this._getApplicableViews(member, restrictions);
            newMembers.add(newMember);
        }
        OpN result = OpDisjunction.create().copy(newMembers);
        return result;
    }

    public Op getApplicableViews(OpProject op, RestrictionManagerImpl restrictions) {
        return new OpProject(this._getApplicableViews(op.getSubOp(), restrictions), op.getVars());
    }

    public Op getApplicableViews(OpOrder op, RestrictionManagerImpl restrictions) {
        return new OpOrder(this._getApplicableViews(op.getSubOp(), restrictions), op.getConditions());
    }

    public Op getApplicableViews(OpGroup op, RestrictionManagerImpl restrictions) {
        return new OpGroup(this._getApplicableViews(op.getSubOp(), restrictions), op.getGroupVars(), op.getAggregators());
    }

    public Op getApplicableViews(OpExtend op, RestrictionManagerImpl _restrictions) {
        Op result = this.processOpExtend(op.getSubOp(), op.getVarExprList(), _restrictions);
        return result;
    }

    public Op getApplicableViews(OpAssign op, RestrictionManagerImpl _restrictions) {
        Op result = this.processOpExtend(op.getSubOp(), op.getVarExprList(), _restrictions);
        return result;
    }

    public Op processOpExtend(Op subOp, VarExprList varExprs, RestrictionManagerImpl _restrictions) {
        Op newSubOp = this._getApplicableViews(subOp, _restrictions);
        Op result = OpExtend.extend((Op)newSubOp, (VarExprList)varExprs);
        return result;
    }

    public Op getApplicableViews(OpFilter op, RestrictionManagerImpl restrictions) {
        RestrictionManagerImpl combinedRestrictions = new RestrictionManagerImpl(restrictions);
        RestrictionManagerImpl subRestrictions = new RestrictionManagerImpl();
        for (Expr expr : op.getExprs()) {
            subRestrictions.stateExpr(expr);
            combinedRestrictions.stateExpr(expr);
        }
        Op newSubOp = this._getApplicableViews(op.getSubOp(), combinedRestrictions);
        OpFilterIndexed result = OpFilterIndexed.filter(subRestrictions, newSubOp);
        return result;
    }

    public Op getApplicableViews(OpUnion op, RestrictionManagerImpl restrictions) {
        RestrictionManagerImpl subRestrictionsLeft = new RestrictionManagerImpl(restrictions);
        RestrictionManagerImpl subRestrictionsRight = new RestrictionManagerImpl(restrictions);
        return OpDisjunction.create((Op)this._getApplicableViews(op.getLeft(), subRestrictionsLeft), (Op)this._getApplicableViews(op.getRight(), subRestrictionsRight));
    }

    public Op getApplicableViews(OpJoin op, RestrictionManagerImpl restrictions) {
        return OpJoin.create((Op)this._getApplicableViews(op.getLeft(), restrictions), (Op)this._getApplicableViews(op.getRight(), restrictions));
    }

    public static RestrictionManagerImpl filterRestrictionsBound(RestrictionManagerImpl restrictions) {
        RestrictionManagerImpl result = new RestrictionManagerImpl();
        if (restrictions == null || restrictions.getCnf() == null) {
            logger.warn("Restrictions were null here - not sure if this should happen");
        }
        for (Clause clause : restrictions.getCnf()) {
            if (FilterPlacementOptimizer2.doesClauseContainBoundExpr(clause)) continue;
            result.stateCnf(new NestedNormalForm(Collections.singleton(clause)));
        }
        return result;
    }

    public Op getApplicableViews(OpLeftJoin op, RestrictionManagerImpl restrictions) {
        Op result = this.processLeftJoin(op.getLeft(), op.getRight(), (Iterable<Expr>)op.getExprs(), restrictions);
        return result;
    }

    public Op getApplicableViews(OpConditional op, RestrictionManagerImpl restrictions) {
        Op result = this.processLeftJoin(op.getLeft(), op.getRight(), null, restrictions);
        return result;
    }

    public Op processLeftJoin(Op left, Op right, Iterable<Expr> exprs, RestrictionManagerImpl restrictions) {
        Op result = this.processLeftJoinSplitLhs(left, right, exprs, restrictions);
        return result;
    }

    public Op processLeftJoinSplitLhs(Op left, Op right, Iterable<Expr> exprs, RestrictionManagerImpl restrictions) {
        List members;
        FilterSplit filterSplit = FilterPlacementOptimizer2.splitFilter(left, restrictions);
        RestrictionManagerImpl leftRestrictions = filterSplit.getPushable();
        Op newLeft = this._getApplicableViews(left, filterSplit.getPushable());
        if ((newLeft = FilterPlacementOptimizer2.optimize(newLeft, leftRestrictions)) instanceof OpDisjunction) {
            OpDisjunction union = (OpDisjunction)newLeft;
            members = union.getElements();
        } else {
            members = Collections.singletonList(newLeft);
        }
        OpDisjunction newUnion = OpDisjunction.create();
        for (Op member : members) {
            RestrictionManagerImpl subRestrictions = new RestrictionManagerImpl(leftRestrictions);
            RestrictionManagerImpl tmp = CandidateViewSelectorBase.getRestrictions2(member);
            subRestrictions.stateRestriction(tmp);
            if (exprs != null) {
                for (Expr expr : exprs) {
                    subRestrictions.stateExpr(expr);
                }
            }
            FilterSplit rsplit = FilterPlacementOptimizer2.splitFilter(right, subRestrictions);
            RestrictionManagerImpl rclauses = rsplit.getPushable();
            Op newRight = this._getApplicableViews(right, rclauses);
            Object item = (OpLeftJoin)OpLeftJoin.create((Op)member, (Op)newRight, (ExprList)new ExprList());
            if (!filterSplit.getNonPushable().getCnf().isEmpty()) {
                item = new OpFilterIndexed((Op)item, filterSplit.getNonPushable());
            }
            newUnion.add((Op)item);
        }
        List elements = newUnion.getElements();
        Object result = newUnion.size() == 1 ? (Op)elements.iterator().next() : newUnion;
        return result;
    }

    public OpLeftJoin processLeftJoinDirect(Op left, Op right, Iterable<Expr> exprs, RestrictionManagerImpl restrictions) {
        Op newLeft = this._getApplicableViews(left, restrictions);
        RestrictionManagerImpl subRestrictions = CandidateViewSelectorBase.filterRestrictionsBound(restrictions);
        RestrictionManagerImpl moreRestrictions = CandidateViewSelectorBase.filterRestrictionsBound(CandidateViewSelectorBase.getRestrictions2(newLeft));
        if (moreRestrictions != null) {
            subRestrictions.stateRestriction(moreRestrictions);
        }
        if (exprs != null) {
            for (Expr expr : exprs) {
                subRestrictions.stateExpr(expr);
            }
        }
        Op newRight = this._getApplicableViews(right, subRestrictions);
        OpLeftJoin result = (OpLeftJoin)OpLeftJoin.create((Op)newLeft, (Op)newRight, (ExprList)new ExprList());
        return result;
    }

    public Op getApplicableViews(OpSlice op, RestrictionManagerImpl restrictions) {
        return new OpSlice(this._getApplicableViews(op.getSubOp(), restrictions), op.getStart(), op.getLength());
    }

    public Op getApplicableViews(OpDistinct op, RestrictionManagerImpl restrictions) {
        return new OpDistinct(this._getApplicableViews(op.getSubOp(), restrictions));
    }

    public static RestrictionManagerImpl getRestrictions2(Op op) {
        if (op instanceof OpFilterIndexed) {
            OpFilterIndexed opFilter = (OpFilterIndexed)op;
            RestrictionManagerImpl filterRestrictions = opFilter.getRestrictions();
            RestrictionManagerImpl subRestrictions = CandidateViewSelectorBase.getRestrictions2(opFilter.getSubOp());
            RestrictionManagerImpl result = subRestrictions == null ? new RestrictionManagerImpl() : new RestrictionManagerImpl(subRestrictions);
            result.stateRestriction(filterRestrictions);
            return result;
        }
        if (op instanceof Op1) {
            return CandidateViewSelectorBase.getRestrictions2(((Op1)op).getSubOp());
        }
        if (op instanceof OpJoin) {
            throw new RuntimeException("TODO Merge the restrictions of both sides of the join");
        }
        if (op instanceof OpLeftJoin) {
            return CandidateViewSelectorBase.getRestrictions2(((OpLeftJoin)op).getLeft());
        }
        if (op instanceof OpConditional) {
            return CandidateViewSelectorBase.getRestrictions2(((OpConditional)op).getLeft());
        }
        if (op instanceof OpDisjunction) {
            return null;
        }
        if (op instanceof OpViewInstanceJoin) {
            OpViewInstanceJoin opPattern = (OpViewInstanceJoin)op;
            return opPattern.getJoin().getRestrictions();
        }
        if (op instanceof OpMapping) {
            OpMapping opMapping = (OpMapping)op;
            return opMapping.getRestrictions();
        }
        throw new RuntimeException("Should not happen: Unhandled Op: " + op.getClass() + " --- " + op);
    }

    public static List<RestrictionManagerImpl> getRestrictions(Op op) {
        ArrayList<RestrictionManagerImpl> result = new ArrayList<RestrictionManagerImpl>();
        CandidateViewSelectorBase.getRestrictions(op, result);
        return result;
    }

    public static void getRestrictions(Op op, Collection<RestrictionManagerImpl> result) {
        if (op instanceof Op1) {
            CandidateViewSelectorBase.getRestrictions(((Op1)op).getSubOp(), result);
        } else {
            if (op instanceof OpJoin) {
                throw new RuntimeException("TODO Merge the restrictions of both sides of the join");
            }
            if (op instanceof OpLeftJoin) {
                CandidateViewSelectorBase.getRestrictions(((OpLeftJoin)op).getLeft(), result);
            } else if (op instanceof OpDisjunction) {
                OpDisjunction o = (OpDisjunction)op;
                for (Op subOp : o.getElements()) {
                    CandidateViewSelectorBase.getRestrictions(subOp, result);
                }
            } else if (op instanceof OpRdfViewPattern) {
                OpRdfViewPattern o = (OpRdfViewPattern)op;
                result.add(o.getConjunction().getRestrictions());
            } else {
                throw new RuntimeException("Should not happen");
            }
        }
    }

    @Override
    public Collection<T> getViews() {
        return this.views;
    }
}

