/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Sets;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.op.OpDisjunction;
import com.hp.hpl.jena.sparql.algebra.op.OpDistinct;
import com.hp.hpl.jena.sparql.algebra.op.OpExtend;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpGroup;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpLeftJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpNull;
import com.hp.hpl.jena.sparql.algebra.op.OpOrder;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpSlice;
import com.hp.hpl.jena.sparql.algebra.op.OpUnion;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.QuadPattern;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.E_Equals;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.function.FunctionRegistry;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.sql.DataSource;
import org.aksw.commons.collections.MapUtils;
import org.aksw.commons.collections.MultiMaps;
import org.aksw.commons.collections.iterators.StackCartesianProductIterator;
import org.aksw.commons.collections.multimaps.IBiSetMultimap;
import org.aksw.commons.util.reflect.MultiMethod;
import org.aksw.sparqlify.algebra.sparql.domain.OpRdfUnionViewPattern;
import org.aksw.sparqlify.algebra.sparql.domain.OpRdfViewPattern;
import org.aksw.sparqlify.algebra.sql.nodes.SqlNodeEmpty;
import org.aksw.sparqlify.algebra.sql.nodes.SqlNodeOld;
import org.aksw.sparqlify.algebra.sql.nodes.SqlQuery;
import org.aksw.sparqlify.algebra.sql.nodes.SqlTable;
import org.aksw.sparqlify.compile.sparql.SqlGenerator;
import org.aksw.sparqlify.core.ColRelGenerator;
import org.aksw.sparqlify.core.QuadIndex;
import org.aksw.sparqlify.core.RdfTermPattern;
import org.aksw.sparqlify.core.RdfTermPatternDerivation;
import org.aksw.sparqlify.core.RdfView;
import org.aksw.sparqlify.core.RdfViewConjunction;
import org.aksw.sparqlify.core.RdfViewInstance;
import org.aksw.sparqlify.core.RdfViewSystem;
import org.aksw.sparqlify.core.ReplaceConstants;
import org.aksw.sparqlify.core.SqlDatatype;
import org.aksw.sparqlify.core.jena.functions.BNode;
import org.aksw.sparqlify.core.jena.functions.PlainLiteral;
import org.aksw.sparqlify.core.jena.functions.RdfTerm;
import org.aksw.sparqlify.core.jena.functions.RightPad;
import org.aksw.sparqlify.core.jena.functions.TypedLiteral;
import org.aksw.sparqlify.core.jena.functions.Uri;
import org.aksw.sparqlify.core.jena.functions.UrlDecode;
import org.aksw.sparqlify.core.jena.functions.UrlEncode;
import org.aksw.sparqlify.sparqlview.View;
import org.aksw.sparqlify.trash.RdfViewDatabase;
import org.aksw.sparqlify.views.transform.FilterPlacementOptimizer;
import org.aksw.sparqlify.views.transform.ViewRewriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sparql.DnfUtils;
import sparql.EquiMap;
import sparql.FilterUtils;
import sparql.TwoWayBinding;
import sparql.ValueSet;

public class RdfViewSystemOld
implements RdfViewSystem {
    private static final Logger logger = LoggerFactory.getLogger(RdfViewSystemOld.class);
    private DataSource dataSource;
    private Set<RdfView> views = new HashSet<RdfView>();
    QuadIndex<RdfView> index = new QuadIndex();
    int viewId = 0;

    public static void initSparqlifyFunctions() {
        FunctionRegistry.get().put("http://aksw.org/sparqlify/rdfTerm", RdfTerm.class);
        FunctionRegistry.get().put("http://aksw.org/sparqlify/blankNode", BNode.class);
        FunctionRegistry.get().put("http://aksw.org/sparqlify/uri", Uri.class);
        FunctionRegistry.get().put("http://aksw.org/sparqlify/plainLiteral", PlainLiteral.class);
        FunctionRegistry.get().put("http://aksw.org/sparqlify/typedLiteral", TypedLiteral.class);
        FunctionRegistry.get().put("http://aksw.org/sparqlify/urlDecode", UrlDecode.class);
        FunctionRegistry.get().put("http://aksw.org/sparqlify/urlEncode", UrlEncode.class);
        FunctionRegistry.get().put("http://aksw.org/sparqlify/rightPad", RightPad.class);
    }

    public static BiMap<Node, Node> createVariableMappingInstance(RdfView view, int id) {
        HashBiMap result = HashBiMap.create();
        Set<Var> vars = view.getVarsMentioned();
        for (Var var : vars) {
            result.put((Object)var, (Object)Var.alloc((String)("inst" + id + "_" + var.getName())));
        }
        return result;
    }

    public static RdfView createViewInstance(RdfView view, int id) {
        throw new RuntimeException("outdated");
    }

    @Override
    public void addView(RdfView view) {
        ++this.viewId;
        Set<Var> vars = view.getVarsMentioned();
        HashMap<Var, Var> rename = new HashMap<Var, Var>();
        for (Var var : vars) {
            rename.put(var, Var.alloc((String)("view" + this.viewId + "_" + var.getName())));
        }
        View copy = view.copySubstitute(rename);
        this.views.add((RdfView)copy);
        this.index(view);
    }

    public static SqlQuery getTableOrQueryAsQuery(SqlNodeOld node) {
        if (node instanceof SqlQuery) {
            return (SqlQuery)node;
        }
        if (node instanceof SqlTable) {
            return new SqlQuery("a", "SELECT * FROM " + ((SqlTable)node).getTableName());
        }
        throw new IllegalArgumentException("Query or Table expected, got " + node.getClass());
    }

    public void loadDatatypes(Connection conn) throws Exception {
        RdfViewSystemOld.loadDatatypes(conn, this.views);
    }

    public static void loadDatatypes(Connection conn, Collection<RdfView> views) throws Exception {
        for (RdfView view : views) {
            if (view.getSqlNode() == null || !view.getColumnToDatatype().isEmpty()) continue;
            SqlGenerator generator = new SqlGenerator();
            String queryString = RdfViewSystemOld.getTableOrQueryAsQuery(view.getSqlNode()).getQueryString();
            logger.warn("Using ugly hack for adding a limit");
            if (!queryString.contains("LIMIT")) {
                queryString = queryString + " LIMIT 1";
            }
            logger.debug("Retrieving datatypes for columns of: " + queryString);
            Map<String, SqlDatatype> columnToType = RdfViewDatabase.getTypes(conn, queryString);
            for (Map.Entry<String, SqlDatatype> entry : columnToType.entrySet()) {
                logger.info(entry.getKey() + " -> " + entry.getValue());
            }
            view.getColumnToDatatype().putAll(columnToType);
        }
    }

    private void index(RdfView view) {
        List<ExprList> clauses = DnfUtils.toClauses(view.getFilter());
        System.out.println("DNF = " + clauses);
        Set<Set<Expr>> dnf = FilterUtils.toSets(clauses);
        for (Quad quad : view.getQuadPattern()) {
            Set<Set<Expr>> filter = FilterUtils.determineFilterDnf(quad, dnf);
            Map<Var, ValueSet<NodeValue>> constraints = FilterUtils.extractValueConstraintsDnf(filter);
            System.out.println("For quad " + quad + " got expr " + filter);
            System.out.println("Value const = " + constraints);
        }
    }

    @Override
    public Op getApplicableViews(Query query) {
        Op optimizedFilters;
        Op op = Algebra.compile((Query)query);
        op = Algebra.toQuadForm((Op)op);
        op = ReplaceConstants.replace(op);
        if (query.isSelectType() && query.isQueryResultStar()) {
            List vars = query.getProjectVars();
            op = new OpProject(op, vars);
        }
        Op augmented = this.getApplicableViews(op);
        Op result = optimizedFilters = FilterPlacementOptimizer.optimize(augmented);
        System.out.println(result);
        return result;
    }

    static RdfViewInstance merge(RdfViewInstance a, RdfViewInstance b) {
        if (a.getParent() != b.getParent()) {
            return null;
        }
        HashMultimap backA = HashMultimap.create(a.getParentToQueryBinding());
        HashMultimap backB = HashMultimap.create(b.getParentToQueryBinding());
        for (Var var : backA.keySet()) {
            Set varsA = backA.get((Object)var);
            Set varsB = backB.get((Object)var);
            if (varsB.isEmpty() || !Sets.intersection((Set)varsA, (Set)varsB).isEmpty()) continue;
            return null;
        }
        for (Map.Entry entry : a.getBinding().getEquiMap().getKeyToValue().entrySet()) {
            Var parentVar = (Var)a.getRenamer().inverse().get(entry.getKey());
            Var bVar = (Var)b.getRenamer().get((Object)parentVar);
            Node bValue = b.getBinding().getEquiMap().getKeyToValue().get(bVar);
            if (bValue == null || ((Node)entry.getValue()).equals((Object)bValue)) continue;
            return null;
        }
        RdfViewInstance result = a.copy();
        result.getQueryQuads().addAll(b.getQueryQuads());
        result.getViewQuads().addAll(b.getViewQuads());
        TwoWayBinding twoWayBinding = new TwoWayBinding();
        twoWayBinding.addAll(b.getBinding());
        Map mergeMap = MapUtils.createChainMap((Map)b.getRenamer().inverse(), result.getRenamer());
        TwoWayBinding twoWayBinding2 = twoWayBinding.copySubstitute(mergeMap);
        result.getBinding().addAll(twoWayBinding2);
        return result;
    }

    public static void merge(RdfViewConjunction conjunction) {
        for (int i = 0; i < conjunction.getViewBindings().size(); ++i) {
            RdfViewInstance a = conjunction.getViewBindings().get(i);
            for (int j = i + 1; j < conjunction.getViewBindings().size(); ++j) {
                RdfViewInstance b = conjunction.getViewBindings().get(j);
                RdfViewInstance view = RdfViewSystemOld.merge(a, b);
                if (view == null) continue;
                a = view;
                conjunction.getViewBindings().set(i, view);
                conjunction.getViewBindings().remove(j);
                --j;
            }
        }
    }

    public Op getApplicableViews(Op op) {
        return this.getApplicableViews(op, new ExprList());
    }

    public Op getApplicableViews(Op op, ExprList exprs) {
        return (Op)MultiMethod.invoke((Object)this, (String)"_getApplicableViews", (Object[])new Object[]{op, exprs});
    }

    public Op _getApplicableViews(OpProject op, ExprList exprs) {
        return new OpProject(this.getApplicableViews(op.getSubOp(), exprs), op.getVars());
    }

    public Op _getApplicableViews(OpOrder op, ExprList exprs) {
        return new OpOrder(this.getApplicableViews(op.getSubOp(), exprs), op.getConditions());
    }

    public Op _getApplicableViews(OpGroup op, ExprList exprs) {
        return new OpGroup(this.getApplicableViews(op.getSubOp(), exprs), op.getGroupVars(), op.getAggregators());
    }

    public Op _getApplicableViews(OpExtend op, ExprList _exprs) {
        ExprList exprs = new ExprList(_exprs);
        for (Var var : op.getVarExprList().getVars()) {
            Expr expr = op.getVarExprList().getExpr(var);
            E_Equals item = new E_Equals((Expr)new ExprVar(var), expr);
            exprs.add((Expr)item);
        }
        return this.getApplicableViews(OpFilter.filter((ExprList)exprs, (Op)op.getSubOp()));
    }

    public Op _getApplicableViews(OpFilter op, ExprList exprs) {
        ExprList subExprs = new ExprList(exprs);
        subExprs.addAll(op.getExprs());
        return OpFilter.filter((ExprList)op.getExprs(), (Op)this.getApplicableViews(op.getSubOp(), subExprs));
    }

    public Op _getApplicableViews(OpUnion op, ExprList exprs) {
        ExprList subExprsLeft = new ExprList(exprs);
        ExprList subExprsRight = new ExprList(exprs);
        return OpDisjunction.create((Op)this.getApplicableViews(op.getLeft(), subExprsLeft), (Op)this.getApplicableViews(op.getRight(), subExprsRight));
    }

    public Op _getApplicableViews(OpJoin op, ExprList exprs) {
        return OpJoin.create((Op)this.getApplicableViews(op.getLeft(), exprs), (Op)this.getApplicableViews(op.getRight(), exprs));
    }

    public Op _getApplicableViews(OpLeftJoin op, ExprList exprs) {
        logger.warn("May seed to implement left join properly");
        return OpLeftJoin.create((Op)this.getApplicableViews(op.getLeft(), exprs), (Op)this.getApplicableViews(op.getRight()), (ExprList)new ExprList());
    }

    public Op _getApplicableViews(OpSlice op, ExprList exprs) {
        return new OpSlice(this.getApplicableViews(op.getSubOp(), exprs), op.getStart(), op.getLength());
    }

    public Op _getApplicableViews(OpDistinct op, ExprList exprs) {
        return new OpDistinct(this.getApplicableViews(op.getSubOp(), exprs));
    }

    public Op _getApplicableViews(OpQuadPattern op, ExprList exprs) {
        HashMultimap queryPatternToCandidate = HashMultimap.create();
        int instanceId = 0;
        QuadPattern queryQuads = op.getPattern();
        for (Quad quad : queryQuads) {
            ++instanceId;
            for (RdfView view : this.views) {
                int subId = 0;
                for (Quad cand : view.getQuadPattern().getList()) {
                    ++subId;
                    TwoWayBinding binding = TwoWayBinding.getVarMappingTwoWay(quad, cand);
                    if (binding == null) continue;
                    IBiSetMultimap inverse = binding.getEquiMap().getEquivalences().getInverse();
                    HashSet<Var> keys = new HashSet<Var>(binding.getEquiMap().getKeyToValue().keySet());
                    keys.removeAll(inverse.asMap().keySet());
                    for (Var key : keys) {
                    }
                    queryPatternToCandidate.put((Object)quad, (Object)new RdfViewInstance(quad, cand, instanceId, subId, view, binding));
                }
            }
        }
        logger.debug("Number of view candidates: " + queryPatternToCandidate.size());
        System.out.println("Candidates: " + queryPatternToCandidate);
        TreeMap orderMap = new TreeMap();
        for (Map.Entry entry : queryPatternToCandidate.asMap().entrySet()) {
            MultiMaps.put(orderMap, (Object)((Collection)entry.getValue()).size(), entry.getValue());
        }
        ArrayList order = new ArrayList(MultiMaps.values(orderMap));
        ArrayList<RdfViewConjunction> union = new ArrayList<RdfViewConjunction>();
        StackCartesianProductIterator it = new StackCartesianProductIterator(order);
        ViewRewriter rewriter = new ViewRewriter();
        while (it.hasNext()) {
            ColRelGenerator generator;
            SqlNodeOld sqlNode;
            List current = it.peek();
            ArrayList list = new ArrayList(current);
            String logMessage = "";
            for (RdfViewInstance item : list) {
                logMessage = logMessage + item.getInstanceId() + "\t";
            }
            TwoWayBinding completeBinding = new TwoWayBinding();
            boolean isSatisfiable = true;
            for (RdfViewInstance item : list) {
                if (!completeBinding.isCompatible(item.getBinding())) {
                    isSatisfiable = false;
                    break;
                }
                completeBinding.addAll(item.getBinding());
            }
            if (!isSatisfiable) {
                logger.debug("SKIP: " + logMessage);
                it.next();
                continue;
            }
            boolean isPatternSatisfiable = true;
            EquiMap<Var, Node> equiMap = completeBinding.getEquiMap();
            block8: for (Var var : equiMap.keySet()) {
                RdfTermPattern pattern = new RdfTermPattern();
                Node value = equiMap.getKeyToValue().get(var);
                if (value != null) {
                    NodeValue nv = NodeValue.makeNode((Node)value);
                    pattern = RdfTermPattern.intersect(pattern, RdfTermPatternDerivation.deriveRegex((Expr)nv));
                }
                for (RdfViewInstance inst : list) {
                    Set bs = inst.getQueryToParentBinding().get((Object)var);
                    for (Var b : bs) {
                        RdfTermPattern tmp = inst.getParent().getConstraints().getVarPatternConstraints().get(b);
                        if ((pattern = RdfTermPattern.intersect(pattern, tmp)).isSatisfiable()) continue;
                        isPatternSatisfiable = false;
                        break;
                    }
                    if (isPatternSatisfiable) continue;
                    continue block8;
                }
            }
            if (!isPatternSatisfiable) {
                logger.debug("SKIP: " + logMessage);
                it.next();
                continue;
            }
            RdfViewConjunction rdfViewConjunction = new RdfViewConjunction(new ArrayList<RdfViewInstance>(list), completeBinding);
            RdfViewSystemOld.merge(rdfViewConjunction);
            ExprList applicableExprs = new ExprList();
            Set<Var> boundVars = completeBinding.keySet();
            for (Expr expr : exprs) {
                if (!boundVars.containsAll(expr.getVarsMentioned())) continue;
                applicableExprs.add(expr);
            }
            OpRdfViewPattern testEmptyOp = new OpRdfViewPattern(rdfViewConjunction);
            if (!applicableExprs.isEmpty()) {
                testEmptyOp = OpFilter.filter((ExprList)applicableExprs, (Op)testEmptyOp);
            }
            if ((sqlNode = rewriter.rewriteMM(generator = new ColRelGenerator(), (Op)testEmptyOp)) instanceof SqlNodeEmpty) {
                logger.debug("SKIP: " + logMessage);
                it.next();
                continue;
            }
            logger.debug("CHK : " + logMessage);
            if (!it.canDescend()) {
                logger.debug("ADD : " + logMessage);
                union.add(rdfViewConjunction);
                it.next();
                continue;
            }
            it.descend();
        }
        OpDisjunction result = OpDisjunction.create();
        for (RdfViewConjunction conjunction : union) {
            OpRdfViewPattern item = new OpRdfViewPattern(conjunction);
            ExprList constraints = new ExprList();
            for (RdfViewInstance viewInstance : conjunction.getViewBindings()) {
                for (Map.Entry entry : viewInstance.getBinding().getEquiMap().getKeyToValue().entrySet()) {
                    List<Expr> definingExprs = viewInstance.getInferredDefiningExprs((Var)entry.getKey());
                    for (Expr definingExpr : definingExprs) {
                        E_Equals constraint = new E_Equals((Expr)new ExprVar((Var)entry.getKey()), (Expr)NodeValue.makeNode((Node)((Node)entry.getValue())));
                        constraints.add((Expr)constraint);
                    }
                }
            }
            if (!constraints.isEmpty()) {
                item = OpFilter.filter((ExprList)constraints, (Op)item);
            }
            result.add((Op)item);
            System.out.println("CompleteBinding: " + conjunction.getCompleteBinding());
            for (RdfViewInstance viewBinding : conjunction.getViewBindings()) {
                System.out.println("    : " + viewBinding.getQueryQuad());
            }
        }
        if (result.size() == 0) {
            return OpNull.create();
        }
        if (result.size() == 1) {
            return result.get(0);
        }
        return result;
    }

    public static boolean isSatisfiable(List<RdfViewInstance> list) {
        TwoWayBinding completeBinding = new TwoWayBinding();
        boolean isOk = true;
        for (RdfViewInstance item : list) {
            if (!completeBinding.isCompatible(item.getBinding())) {
                isOk = false;
                break;
            }
            completeBinding.addAll(item.getBinding());
        }
        return isOk;
    }

    public static Set<OpRdfUnionViewPattern> getApplicableViews(Set<RdfView> views, Quad quad, Expr filters, Binding substitution) {
        return null;
    }

    @Override
    public Collection<RdfView> getViews() {
        return this.views;
    }

    static {
        RdfViewSystemOld.initSparqlifyFunctions();
    }
}

