/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.config.v0_2.bridge;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.aksw.sparqlify.algebra.sql.nodes.Schema;
import org.aksw.sparqlify.algebra.sql.nodes.SchemaImpl;
import org.aksw.sparqlify.config.v0_2.bridge.BasicTableInfo;
import org.aksw.sparqlify.config.v0_2.bridge.SchemaProvider;
import org.aksw.sparqlify.core.TypeToken;
import org.aksw.sparqlify.core.cast.TypeSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaProviderImpl
implements SchemaProvider {
    private static final Logger logger = LoggerFactory.getLogger(SchemaProvider.class);
    private Connection conn;
    private TypeSystem datatypeSystem;
    private Map<String, String> aliasMap;

    public SchemaProviderImpl(Connection conn, TypeSystem datatypeSystem, Map<String, String> aliasMap) {
        this.conn = conn;
        this.datatypeSystem = datatypeSystem;
        this.aliasMap = aliasMap;
    }

    @Override
    public Schema createSchemaForRelationName(String tableName) {
        String escTableName = "\"" + tableName + "\"";
        Schema result = this.createSchemaForQueryString("SELECT * FROM " + escTableName);
        return result;
    }

    @Override
    public Schema createSchemaForQueryString(String queryString) {
        BasicTableInfo tableInfo;
        logger.info("Retrieving schema for query: " + queryString);
        logger.warn("Using ugly hack for adding a limit");
        if (!queryString.contains("LIMIT")) {
            queryString = queryString + " LIMIT 1";
        }
        try {
            tableInfo = SchemaProviderImpl.getRawTypes(this.conn, queryString);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Map<String, String> rawTypeMap = tableInfo.getRawTypeMap();
        Set<String> nullableColumns = tableInfo.getNullableColumns();
        Map<String, TypeToken> typeMap = SchemaProviderImpl.getTypes(rawTypeMap, this.datatypeSystem, rawTypeMap);
        for (Map.Entry<String, TypeToken> entry : typeMap.entrySet()) {
            logger.info(entry.getKey() + " -> " + entry.getValue());
        }
        ArrayList<String> columnNames = new ArrayList<String>(typeMap.keySet());
        SchemaImpl result = new SchemaImpl(columnNames, typeMap, nullableColumns);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BasicTableInfo getRawTypes(Connection conn, String queryStr) throws Exception {
        HashMap<String, String> rawTypeMap = new HashMap<String, String>();
        HashSet<String> nullableColumns = new HashSet<String>();
        ResultSet rs = conn.createStatement().executeQuery(queryStr);
        try {
            ResultSetMetaData meta = rs.getMetaData();
            for (int i = 1; i <= meta.getColumnCount(); ++i) {
                String name = meta.getColumnLabel(i);
                int isNullable = meta.isNullable(i);
                if (isNullable != 0) {
                    nullableColumns.add(name);
                }
                String typeName = meta.getColumnTypeName(i);
                rawTypeMap.put(name, typeName);
            }
        }
        finally {
            rs.close();
        }
        BasicTableInfo result = new BasicTableInfo(rawTypeMap, nullableColumns);
        return result;
    }

    public static Map<String, TypeToken> transformRawMap(Map<String, String> map, TypeSystem datatypeSystem, Map<String, String> aliasMap) {
        HashMap<String, TypeToken> result = new HashMap<String, TypeToken>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            TypeToken typeToken = TypeToken.alloc(entry.getValue());
            result.put(entry.getKey(), typeToken);
        }
        return result;
    }

    public static Map<String, TypeToken> getTypes(Map<String, String> rawTypeMap, TypeSystem datatypeSystem, Map<String, String> aliasMap) {
        Map<String, TypeToken> result = SchemaProviderImpl.transformRawMap(rawTypeMap, datatypeSystem, aliasMap);
        return result;
    }

    @Override
    public TypeSystem getDatatypeSystem() {
        return this.datatypeSystem;
    }
}

