/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.algebra.sql.nodes;

import com.hp.hpl.jena.sparql.expr.Expr;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.aksw.sparqlify.algebra.sql.nodes.Schema;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOp;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpBase1;
import org.apache.jena.atlas.io.IndentedWriter;

public class SqlOpFilterExpr
extends SqlOpBase1 {
    private List<Expr> exprs;

    public SqlOpFilterExpr(Schema schema, SqlOp subOp, Expr expr) {
        this(schema, subOp, new ArrayList<Expr>(Collections.singleton(expr)));
    }

    public SqlOpFilterExpr(Schema schema, SqlOp subOp, List<Expr> exprs) {
        super(schema, subOp);
        assert (exprs != null) : "Null pointer exception";
        this.exprs = exprs;
    }

    public List<Expr> getExprs() {
        return this.exprs;
    }

    public static SqlOp createIfNeeded(SqlOp op, List<Expr> exprs) {
        SqlOp result = exprs.isEmpty() ? op : SqlOpFilterExpr.create(op, exprs);
        return result;
    }

    public static SqlOpFilterExpr create(SqlOp op, List<Expr> exprs) {
        SqlOpFilterExpr result = new SqlOpFilterExpr(op.getSchema(), op, exprs);
        return result;
    }

    @Override
    public void write(IndentedWriter writer) {
        writer.println((Object)("SqlOpFilterExpr" + this.exprs + "("));
        writer.incIndent();
        this.subOp.write(writer);
        writer.println();
        writer.decIndent();
        writer.print((Object)")");
    }

    @Override
    public boolean isEmpty() {
        return this.subOp.isEmpty();
    }
}

