/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.algebra.sql.exprs;

import com.hp.hpl.jena.sdb.core.sqlnode.SqlTable;
import org.aksw.sparqlify.algebra.sql.exprs.SqlExpr0;
import org.aksw.sparqlify.algebra.sql.exprs2.SqlExprVisitor;
import org.aksw.sparqlify.core.SqlDatatype;
import org.apache.jena.atlas.io.IndentedWriter;

public class SqlExprColumn
extends SqlExpr0 {
    private String tableName;
    private String columnName;
    SqlTable jenaTable = null;

    public SqlExprColumn(String tableName, String columnName, SqlDatatype datatype) {
        super(datatype);
        this.tableName = tableName;
        this.columnName = columnName;
        if (tableName != null) {
            this.jenaTable = new SqlTable(tableName);
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getFullColumnName() {
        if (this.tableName == null) {
            return this.columnName;
        }
        return this.tableName + "." + this.columnName;
    }

    public boolean isColumn() {
        return true;
    }

    public String asString() {
        return this.getFullColumnName();
    }

    public void visit(SqlExprVisitor visitor) {
        throw new RuntimeException("Something was messed up");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columnName == null ? 0 : this.columnName.hashCode());
        result = 31 * result + (this.tableName == null ? 0 : this.tableName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SqlExprColumn other = (SqlExprColumn)obj;
        if (this.columnName == null ? other.columnName != null : !this.columnName.equals(other.columnName)) {
            return false;
        }
        return !(this.tableName == null ? other.tableName != null : !this.tableName.equals(other.tableName));
    }

    @Override
    public void asString(IndentedWriter writer) {
        writer.print((Object)((this.tableName == null ? "" : this.tableName + ".") + this.columnName));
    }

    @Override
    public String toString() {
        return this.tableName + "." + this.columnName;
    }
}

