/*
 * Decompiled with CFR 0.152.
 */
package sparql;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Quad;

public class FilterCompiler {
    public static String askForQuad(Quad quad) {
        return "Ask { ?s ?p ?o . " + FilterCompiler.wrapFilter(FilterCompiler.compileFilter(quad.getSubject(), "?s")) + FilterCompiler.wrapFilter(FilterCompiler.compileFilter(quad.getPredicate(), "?p")) + FilterCompiler.wrapFilter(FilterCompiler.compileFilter(quad.getObject(), "?o")) + "}";
    }

    public static String wrapFilter(String expr) {
        return expr != null && !expr.isEmpty() ? "Filter(" + expr + ") ." : "";
    }

    public static String compileFilter(Node node, String columnName) {
        if (node.isURI()) {
            return columnName + " = <" + node.getURI() + ">";
        }
        if (node.isLiteral()) {
            String result = "str(" + columnName + ") = '" + node.getLiteralLexicalForm() + "'";
            if (!node.getLiteralLanguage().isEmpty()) {
                result = result + " && langMatches(lang(" + columnName + "), '" + node.getLiteralLanguage() + "')";
            } else if (node.getLiteralDatatypeURI() != null) {
                result = result + " && datatype(" + columnName + ") = <" + node.getLiteralDatatypeURI() + ">";
            }
            return result;
        }
        throw new RuntimeException("Should never come here - maybe a blank node of evilness?");
    }
}

