/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.restriction.experiment;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingHashMap;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.expr.E_Equals;
import com.hp.hpl.jena.sparql.expr.E_LogicalNot;
import com.hp.hpl.jena.sparql.expr.E_StrConcat;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.util.ExprUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.util.Pair;
import org.aksw.sparqlify.algebra.sparql.expr.E_StrConcatPermissive;
import org.aksw.sparqlify.config.lang.PrefixSet;
import org.aksw.sparqlify.database.Clause;
import org.aksw.sparqlify.database.IndirectEquiMap;
import org.aksw.sparqlify.database.NestedNormalForm;
import org.aksw.sparqlify.restriction.RdfTermType;
import org.aksw.sparqlify.restriction.Restriction;
import org.aksw.sparqlify.restriction.RestrictionImpl;
import org.aksw.sparqlify.restriction.RestrictionManager;
import org.apache.commons.lang.NotImplementedException;
import sparql.CnfUtils;

public class RestrictionManagerBeforeChangingToMap
implements RestrictionManager {
    private RestrictionManagerBeforeChangingToMap parent;
    private IndirectEquiMap<Var, RestrictionImpl> restrictions = new IndirectEquiMap();
    private Set<Clause> unsatisfiableClauses = new HashSet<Clause>();
    private NestedNormalForm cnf;
    private Map<Expr, RestrictionImpl> exprToRestriction = new HashMap<Expr, RestrictionImpl>();
    private Map<Var, Node> binding = new HashMap<Var, Node>();
    private BindingMap bindingMap = new BindingHashMap();
    private Boolean satisfiability = Boolean.TRUE;

    public RestrictionManagerBeforeChangingToMap() {
        this.cnf = new NestedNormalForm(null, false);
        Set<Expr> emptyExprSet = Collections.emptySet();
        this.cnf.add(new Clause(emptyExprSet));
        this.satisfiability = Boolean.TRUE;
    }

    public RestrictionManagerBeforeChangingToMap(RestrictionManagerBeforeChangingToMap parent) {
        this.parent = parent;
        this.cnf = new NestedNormalForm(parent.getCnf(), true);
    }

    public RestrictionManagerBeforeChangingToMap(NestedNormalForm cnf) {
        this.cnf = cnf;
        this.deriveRestrictions(cnf);
    }

    public NestedNormalForm getCnf() {
        return this.cnf;
    }

    public Boolean getSatisfiability() {
        return this.satisfiability;
    }

    public static RestrictionImpl deriveRestriction(Expr expr) {
        if (expr instanceof E_StrConcat || expr instanceof E_StrConcatPermissive) {
            return RestrictionManagerBeforeChangingToMap.deriveRestriction(expr);
        }
        if (expr.isConstant()) {
            RestrictionImpl result = new RestrictionImpl();
            result.stateNode(expr.getConstant().asNode());
            return result;
        }
        return null;
    }

    public static RestrictionImpl deriveRestriction(E_StrConcat expr) {
        return RestrictionManagerBeforeChangingToMap.deriveRestrictionConcat((ExprFunction)expr);
    }

    public static RestrictionImpl deriveRestriction(E_StrConcatPermissive expr) {
        return RestrictionManagerBeforeChangingToMap.deriveRestrictionConcat((ExprFunction)expr);
    }

    public static RestrictionImpl deriveRestrictionConcat(ExprFunction concat) {
        Expr arg;
        String prefix = "";
        Iterator iterator = concat.getArgs().iterator();
        while (iterator.hasNext() && (arg = (Expr)iterator.next()).isConstant()) {
            prefix = prefix + arg.getConstant().asUnquotedString();
        }
        RestrictionImpl result = new RestrictionImpl();
        result.stateUriPrefixes(new PrefixSet(prefix));
        return result;
    }

    public void deriveRestrictions(Set<Clause> cnf) {
        for (Clause clause : cnf) {
            if (clause.getExprs().size() != 1) continue;
            for (Map.Entry<Var, RestrictionImpl> entry : clause.getRestrictions().entrySet()) {
                this.stateRestriction(entry.getKey(), entry.getValue());
            }
        }
    }

    public boolean stateRestriction(Var var, RestrictionImpl restriction) {
        RestrictionImpl r = this.getOrCreateLocalRestriction(var);
        if (r.stateRestriction(restriction)) {
            if (r.isUnsatisfiable()) {
                this.satisfiability = Boolean.FALSE;
            } else {
                this.check(var);
            }
            return true;
        }
        return false;
    }

    public void check(Var var) {
        Collection<Var> vars = this.restrictions.getEquivalences(var);
        this.check(vars);
    }

    public Set<Clause> getClausesForVars(Collection<Var> vars) {
        HashSet<Clause> result = new HashSet<Clause>();
        for (Var var : vars) {
            Set<Clause> tmp = this.cnf.getClausesByVar(var);
            if (tmp == null) continue;
            result.addAll(tmp);
        }
        return result;
    }

    public void check(Collection<Var> vars) {
        Set<Clause> clauses = this.getClausesForVars(vars);
        this.checkClauses(clauses);
    }

    public void checkClauses(Collection<Clause> clauses) {
        for (Clause clause : clauses) {
            this.check(clause);
            if (this.satisfiability != Boolean.FALSE) continue;
            return;
        }
    }

    public void check(Clause clause) {
        HashSet<Expr> modify = new HashSet<Expr>();
        Boolean isClauseSat = true;
        for (Expr expr : clause.getExprs()) {
            Boolean satisfiability = this.determineSatisfiability(expr);
            if (satisfiability == null) {
                modify.add(expr);
                continue;
            }
            if (satisfiability.booleanValue()) continue;
            isClauseSat = false;
            break;
        }
        if (!isClauseSat.booleanValue()) {
            this.satisfiability = Boolean.FALSE;
            return;
        }
        if (modify != null) {
            this.cnf.remove(clause);
            this.cnf.add(new Clause(modify));
        }
    }

    @Override
    public Boolean determineSatisfiability(Expr expr) {
        if (this.binding.keySet().containsAll(expr.getVarsMentioned())) {
            try {
                NodeValue value = ExprUtils.eval((Expr)expr, (Binding)this.bindingMap);
                return value.getBoolean();
            }
            catch (Exception e) {
                System.err.println(e);
                return null;
            }
        }
        if (expr instanceof E_LogicalNot) {
            Boolean tmp = this.determineSatisfiability(((E_LogicalNot)expr).getArg());
            return tmp == null ? null : Boolean.valueOf(tmp == false);
        }
        if (expr instanceof E_Equals) {
            E_Equals e = (E_Equals)expr;
            RestrictionImpl a = this.getRestriction(e.getArg1());
            RestrictionImpl b = this.getRestriction(e.getArg2());
            return RestrictionManagerBeforeChangingToMap.determineSatisfiabilityEquals(a, b);
        }
        return null;
    }

    @Override
    public RestrictionImpl getRestriction(Expr expr) {
        if (expr.isVariable()) {
            return this.restrictions.get(expr.asVar());
        }
        return this.exprToRestriction.get(expr);
    }

    public static Boolean determineSatisfiabilityEquals(RestrictionImpl a, RestrictionImpl b) {
        if (a == null || b == null) {
            return null;
        }
        RestrictionImpl tmp = new RestrictionImpl(a);
        tmp.stateRestriction(b);
        if (!tmp.isConsistent()) {
            return false;
        }
        return null;
    }

    public boolean isEqual(Var a, Var b) {
        boolean e = this.restrictions.isEqual(a, b);
        if (e) {
            return true;
        }
        return this.parent != null ? this.parent.isEqual(a, b) : false;
    }

    public Collection<Var> getEquivalences(Var a) {
        Collection<Var> result = this.restrictions.getEquivalences(a);
        if (result.isEmpty() && this.parent != null) {
            return this.parent.getEquivalences(a);
        }
        return result;
    }

    public void stateEqual(Var a, Var b) {
        boolean didCopy = false;
        if (this.restrictions.isEqual(a, b)) {
            return;
        }
        if (this.parent != null && this.parent.isEqual(a, b)) {
            return;
        }
        Collection<Var> ae = this.getEquivalences(a);
        RestrictionImpl ar = this.getRestriction(a);
        Collection<Var> be = this.getEquivalences(b);
        RestrictionImpl br = this.getRestriction(b);
        this.restrictions.stateEqual(new HashSet<Var>(ae), ar);
        this.restrictions.stateEqual(new HashSet<Var>(be), br);
        didCopy = true;
        Pair<RestrictionImpl, RestrictionImpl> conflict = this.restrictions.stateEqual(a, b);
        if (conflict != null) {
            RestrictionImpl r = (RestrictionImpl)conflict.getKey();
            if (didCopy) {
                r = r.clone();
            }
            r.stateRestriction((Restriction)conflict.getValue());
            this.restrictions.stateEqual(a, b, r);
        }
        this.check(a);
    }

    @Override
    public RestrictionImpl getRestriction(Var a) {
        RestrictionImpl result = this.restrictions.get(a);
        if (result == null && this.parent != null) {
            return this.parent.getRestriction(a);
        }
        return result;
    }

    @Override
    public RestrictionImpl getOrCreateLocalRestriction(Var a) {
        RestrictionImpl toCopy;
        RestrictionImpl result = this.restrictions.get(a);
        if (result == null && this.parent != null && (toCopy = this.parent.getRestriction(a)) != null) {
            result = toCopy.clone();
        }
        if (result == null) {
            result = new RestrictionImpl();
            this.restrictions.put(a, result);
        }
        return result;
    }

    @Override
    public void stateType(Var a, RdfTermType type) {
        RestrictionImpl r = this.getOrCreateLocalRestriction(a);
        if (r.stateType(type)) {
            if (r.isUnsatisfiable()) {
                this.satisfiability = false;
            } else {
                this.check(a);
            }
        }
    }

    @Override
    public void stateNode(Var a, Node b) {
        RestrictionImpl r = this.getOrCreateLocalRestriction(a);
        if (r.stateNode(b)) {
            if (!r.isConsistent()) {
                this.satisfiability = Boolean.FALSE;
                return;
            }
            this.check(a);
            if (this.satisfiability != Boolean.FALSE) {
                for (Var v : this.restrictions.getEquivalences(a)) {
                    this.binding.put(v, b);
                    this.bindingMap.add(v, b);
                }
            }
        }
    }

    @Override
    public void stateUri(Var a, String uri) {
        this.stateNode(a, Node.createURI((String)uri));
    }

    @Override
    public void stateLiteral(Var a, NodeValue b) {
        this.stateNode(a, b.asNode());
    }

    public void stateExpr(Expr expr) {
        NestedNormalForm newCnf = CnfUtils.toCnf(expr);
        this.stateCnf(newCnf);
    }

    public void stateCnf(NestedNormalForm newCnf) {
        this.deriveRestrictions(newCnf);
        if (this.satisfiability == Boolean.FALSE) {
            return;
        }
        this.cnf.addAll(newCnf);
        this.checkClauses(newCnf);
    }

    @Override
    public void stateNonEqual(Var a, Var b) {
        throw new NotImplementedException();
    }

    public boolean stateRestriction(RestrictionManagerBeforeChangingToMap rm) {
        if (this.isUnsatisfiable()) {
            return false;
        }
        throw new RuntimeException("Not implemented yet");
    }

    public Set<Clause> getEffectiveDnf(Collection<Var> vars) {
        ArrayList<Clause> clauses = new ArrayList<Clause>(this.getClausesForVars(vars));
        Collections.sort(clauses, new Comparator<Clause>(){

            @Override
            public int compare(Clause a, Clause b) {
                return a.size() - b.size();
            }
        });
        HashSet<Clause> result = new HashSet<Clause>();
        this.getEffectiveDnf(0, clauses, null, result);
        return result;
    }

    public void getEffectiveDnf(int index, List<Clause> cnfs, Clause parentClause, Set<Clause> result) {
        if (index >= cnfs.size()) {
            if (parentClause != null) {
                result.add(parentClause);
            }
            return;
        }
        Clause clause = cnfs.get(index);
        for (Expr expr : clause.getExprs()) {
            HashSet<Expr> exprs = new HashSet<Expr>();
            if (parentClause != null) {
                exprs.addAll(parentClause.getExprs());
            }
            exprs.add(expr);
            Clause merged = new Clause(exprs);
            this.getEffectiveDnf(index + 1, cnfs, merged, result);
        }
    }

    public String toString() {
        if (this.satisfiability == Boolean.FALSE) {
            return "inconsistent";
        }
        return this.restrictions + " " + this.cnf.toString();
    }

    public void stateUriPrefixes(Var a, PrefixSet prefixes) {
        RestrictionImpl r = this.getOrCreateLocalRestriction(a);
        if (r.stateUriPrefixes(prefixes)) {
            if (!r.isConsistent()) {
                this.satisfiability = Boolean.FALSE;
                return;
            }
            this.check(a);
        }
    }

    public boolean isUnsatisfiable() {
        return this.satisfiability == Boolean.FALSE;
    }
}

