/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.restriction;

import com.hp.hpl.jena.graph.Node;
import com.karneim.util.collection.regex.PatternPro;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.aksw.sparqlify.config.lang.PrefixSet;
import org.aksw.sparqlify.restriction.RdfTermType;
import org.aksw.sparqlify.restriction.Restriction;
import org.aksw.sparqlify.restriction.RestrictionImpl;
import org.apache.commons.lang.NotImplementedException;

public class RestrictionSetImpl {
    private List<RestrictionImpl> restrictions;

    public PrefixSet getUriPrefixes() {
        PrefixSet result = null;
        for (RestrictionImpl r : this.restrictions) {
            if (result == null) {
                result = r.getUriPrefixes();
                continue;
            }
            PrefixSet tmp = r.getUriPrefixes();
            result.addAll(tmp);
        }
        return result;
    }

    public RdfTermType getType() {
        RdfTermType t = null;
        for (RestrictionImpl r : this.restrictions) {
            if (t == null) {
                t = r.getType();
                continue;
            }
            if (r.getType() == t) continue;
            return RdfTermType.UNKNOWN;
        }
        if (t == null) {
            return RdfTermType.UNKNOWN;
        }
        return t;
    }

    public Collection<RestrictionImpl> getRestrictions() {
        return this.restrictions;
    }

    public boolean addAlternatives(RestrictionSetImpl rs) {
        if (rs.restrictions == null) {
            return rs.addAlternative(new RestrictionImpl());
        }
        boolean result = false;
        for (RestrictionImpl r : rs.restrictions) {
            boolean change = this.addAlternative(r);
            result = result || change;
        }
        return result;
    }

    public boolean addAlternative(RestrictionImpl r) {
        if (r.getSatisfiability() == Boolean.TRUE) {
            return false;
        }
        if (!r.isUnsatisfiable()) {
            if (this.restrictions == null) {
                this.restrictions = new ArrayList<RestrictionImpl>();
            }
            Iterator<RestrictionImpl> it = this.restrictions.iterator();
            while (it.hasNext()) {
                RestrictionImpl x = it.next();
                if (x.subsumesOrIsEqual(r)) {
                    return false;
                }
                if (!r.subsumesOrIsEqual(x)) continue;
                it.remove();
            }
            this.restrictions.add(r);
            return true;
        }
        return false;
    }

    public RestrictionSetImpl() {
        this.restrictions = null;
    }

    public RestrictionSetImpl(boolean value) {
        this.restrictions = !value ? new ArrayList() : null;
    }

    public RestrictionSetImpl(RestrictionImpl restriction) {
        if (restriction.isUnsatisfiable()) {
            this.restrictions = Collections.emptyList();
        } else {
            this.restrictions = new ArrayList<RestrictionImpl>();
            this.restrictions.add(restriction);
        }
    }

    public RestrictionSetImpl(List<RestrictionImpl> restrictions) {
        Iterator<RestrictionImpl> it = restrictions.iterator();
        while (it.hasNext()) {
            if (!it.next().isUnsatisfiable()) continue;
            it.remove();
        }
        this.restrictions = restrictions;
    }

    public RestrictionSetImpl(RestrictionSetImpl other) {
        this.restrictions = new ArrayList<RestrictionImpl>(other.restrictions);
    }

    public boolean stateRestriction(RestrictionImpl other) {
        if (this.restrictions == null) {
            this.restrictions = new ArrayList<RestrictionImpl>();
            this.restrictions.add(other.clone());
            return true;
        }
        boolean result = false;
        Iterator<RestrictionImpl> it = this.restrictions.iterator();
        while (it.hasNext()) {
            RestrictionImpl r = it.next();
            boolean change = r.stateRestriction(other);
            boolean bl = result = result || change;
            if (!r.isUnsatisfiable()) continue;
            it.remove();
        }
        return result;
    }

    public boolean stateRestriction(RestrictionSetImpl other) {
        if (other.restrictions == null) {
            return false;
        }
        if (this.restrictions == null) {
            this.restrictions = new ArrayList<RestrictionImpl>();
            for (RestrictionImpl _a : other.restrictions) {
                this.restrictions.add(_a.clone());
            }
            return true;
        }
        ArrayList<RestrictionImpl> joined = new ArrayList<RestrictionImpl>();
        boolean result = false;
        for (RestrictionImpl _a : this.restrictions) {
            for (RestrictionImpl b : other.restrictions) {
                RestrictionImpl a = _a.clone();
                boolean change = a.stateRestriction(b);
                boolean bl = result = result || change;
                if (a.isUnsatisfiable()) continue;
                joined.add(a);
            }
        }
        this.restrictions = joined;
        return result;
    }

    public boolean isUnsatisfiable() {
        return this.restrictions != null && this.restrictions.isEmpty();
    }

    public RestrictionSetImpl clone() {
        if (this.restrictions == null) {
            return new RestrictionSetImpl();
        }
        ArrayList<RestrictionImpl> copy = new ArrayList<RestrictionImpl>();
        for (RestrictionImpl r : this.restrictions) {
            copy.add(r.clone());
        }
        return new RestrictionSetImpl(copy);
    }

    public boolean stateType(RdfTermType newType) {
        if (this.restrictions == null) {
            return this.stateRestriction(new RestrictionImpl(newType));
        }
        Iterator<RestrictionImpl> it = this.restrictions.iterator();
        boolean result = false;
        while (it.hasNext()) {
            Restriction r = it.next();
            boolean change = r.stateType(newType);
            boolean bl = result = result || change;
            if (!r.isUnsatisfiable()) continue;
            it.remove();
        }
        return result;
    }

    public boolean stateNode(Node newNode) {
        if (this.restrictions == null) {
            return this.stateRestriction(new RestrictionImpl(newNode));
        }
        Iterator<RestrictionImpl> it = this.restrictions.iterator();
        boolean result = false;
        while (it.hasNext()) {
            Restriction r = it.next();
            boolean change = r.stateNode(newNode);
            boolean bl = result = result || change;
            if (!r.isUnsatisfiable()) continue;
            it.remove();
        }
        return result;
    }

    public boolean stateUriPrefixes(PrefixSet prefixes) {
        if (this.restrictions == null) {
            return this.stateRestriction(new RestrictionImpl(prefixes));
        }
        Iterator<RestrictionImpl> it = this.restrictions.iterator();
        boolean result = false;
        while (it.hasNext()) {
            Restriction r = it.next();
            boolean change = r.stateUriPrefixes(prefixes);
            boolean bl = result = result || change;
            if (!r.isUnsatisfiable()) continue;
            it.remove();
        }
        return result;
    }

    public void statePattern(PatternPro pattern) {
        throw new NotImplementedException();
    }

    public String toString() {
        return this.restrictions == null ? "true" : (this.restrictions.isEmpty() ? "false" : this.restrictions.toString());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.restrictions == null ? 0 : this.restrictions.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RestrictionSetImpl other = (RestrictionSetImpl)obj;
        return !(this.restrictions == null ? other.restrictions != null : !this.restrictions.equals(other.restrictions));
    }
}

