/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.csv;

import java.io.IOException;
import java.io.Reader;

public abstract class ReaderStringBase
extends Reader {
    private String line;
    private int offset = 0;

    @Override
    public int read(char[] cbuf, int dstBegin, int len) throws IOException {
        if (this.offset < 0) {
            return -1;
        }
        int initOff = dstBegin;
        while (len > 0) {
            int lineLen = this.line == null ? 0 : this.line.length();
            int lineAvailLen = lineLen - this.offset;
            int readLen = Math.min(lineAvailLen, len);
            if (readLen > 0) {
                int srcEnd = this.offset + readLen;
                this.line.getChars(this.offset, srcEnd, cbuf, dstBegin);
                this.offset = srcEnd;
                dstBegin += readLen;
                len -= readLen;
                lineAvailLen -= readLen;
            }
            if (len <= 0 || lineAvailLen > 0) continue;
            this.line = this.nextString();
            if (this.line == null) {
                this.offset = -1;
                break;
            }
            this.offset = 0;
        }
        int result = dstBegin - initOff;
        return result;
    }

    protected abstract String nextString() throws IOException;
}

