/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.transformations;

import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import java.util.ArrayList;
import java.util.List;
import org.aksw.sparqlify.algebra.sparql.expr.E_RdfTerm;
import org.aksw.sparqlify.core.transformations.ExprTransformer;
import org.aksw.sparqlify.core.transformations.SqlTranslationUtils;
import org.aksw.sparqlify.trash.ExprCopy;

public class ExprTransformerRdfTermCtor
implements ExprTransformer {
    boolean hasRdfTermCtorArgument(ExprFunction fn) {
        return this.hasRdfTermCtorArgument(fn.getArgs());
    }

    boolean hasRdfTermCtorArgument(Iterable<Expr> exprs) {
        for (Expr expr : exprs) {
            if (!(expr instanceof E_RdfTerm)) continue;
            return true;
        }
        return false;
    }

    @Override
    public E_RdfTerm transform(Expr orig, List<E_RdfTerm> terms) {
        ArrayList<Expr> args = new ArrayList<Expr>(terms.size());
        for (E_RdfTerm term : terms) {
            Expr tmp = term.getLexicalValue();
            args.add(tmp);
        }
        Expr newExpr = ExprCopy.getInstance().copy(orig, args);
        E_RdfTerm result = SqlTranslationUtils.expandRdfTerm(newExpr);
        return result;
    }
}

