/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.interfaces;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sparql.algebra.Op;
import java.util.List;
import org.aksw.commons.util.jdbc.Schema;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOp;
import org.aksw.sparqlify.core.algorithms.SparqlSqlStringRewriterImpl;
import org.aksw.sparqlify.core.algorithms.SqlOptimizerImpl;
import org.aksw.sparqlify.core.domain.input.Mapping;
import org.aksw.sparqlify.core.domain.input.SparqlSqlOpRewrite;
import org.aksw.sparqlify.core.domain.input.VarDefinition;
import org.aksw.sparqlify.core.interfaces.CandidateViewSelector;
import org.aksw.sparqlify.core.interfaces.IViewDef;
import org.aksw.sparqlify.core.interfaces.OpMappingRewriter;
import org.aksw.sparqlify.core.interfaces.SparqlSqlOpRewriter;
import org.aksw.sparqlify.core.interfaces.SqlOpSelectBlockCollector;
import org.apache.commons.lang.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparqlSqlOpRewriterImpl
implements SparqlSqlOpRewriter {
    private static final Logger logger = LoggerFactory.getLogger(SparqlSqlStringRewriterImpl.class);
    private CandidateViewSelector<? extends IViewDef> candidateViewSelector;
    private OpMappingRewriter opMappingRewriter;
    private SqlOpSelectBlockCollector sqlOpSelectBlockCollector;
    private SqlOptimizerImpl sqlOptimizer;

    public SparqlSqlOpRewriterImpl(CandidateViewSelector<? extends IViewDef> candidateViewSelector, OpMappingRewriter opMappingRewriter, SqlOpSelectBlockCollector sqlOpSelectBlockCollector, Schema databaseSchema) {
        this.candidateViewSelector = candidateViewSelector;
        this.opMappingRewriter = opMappingRewriter;
        this.sqlOpSelectBlockCollector = sqlOpSelectBlockCollector;
        this.sqlOptimizer = new SqlOptimizerImpl(databaseSchema);
    }

    public CandidateViewSelector<? extends IViewDef> getCandidateViewSelector() {
        return this.candidateViewSelector;
    }

    public OpMappingRewriter getOpMappingRewriter() {
        return this.opMappingRewriter;
    }

    public SqlOpSelectBlockCollector getSqlOpSelectBlockCollector() {
        return this.sqlOpSelectBlockCollector;
    }

    public SqlOptimizerImpl getSqlOptimizer() {
        return this.sqlOptimizer;
    }

    @Override
    public SparqlSqlOpRewrite rewrite(Query query) {
        StopWatch sw = new StopWatch();
        sw.start();
        logger.info("[" + sw.getTime() + "] Rewrite started.");
        Op opViewInstance = this.candidateViewSelector.getApplicableViews(query);
        logger.info("[" + sw.getTime() + "] Candidate selection completed");
        List projectionOrder = null;
        projectionOrder = query.isSelectType() && query.isQueryResultStar() ? query.getProjectVars() : query.getProjectVars();
        Mapping mapping = this.opMappingRewriter.rewrite(opViewInstance);
        logger.info("[" + sw.getTime() + "] Mapping rewrite completed");
        SqlOp sqlOp = mapping.getSqlOp();
        logger.info("[" + sw.getTime() + "] Sql translation completed");
        if (this.sqlOpSelectBlockCollector != null) {
            sqlOp = this.sqlOpSelectBlockCollector.transform(sqlOp);
            this.sqlOptimizer.optimize(sqlOp);
            logger.info("[" + sw.getTime() + "] Sql optimization completed");
        }
        sw.stop();
        logger.info("[" + sw.getTime() + "] Done (excluding serialization)");
        boolean isEmpty = sqlOp.isEmpty();
        VarDefinition varDefinition = mapping.getVarDefinition();
        SparqlSqlOpRewrite result = new SparqlSqlOpRewrite(sqlOp, isEmpty, varDefinition, projectionOrder);
        return result;
    }
}

