/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.datatypes;

import java.util.List;
import org.aksw.sparqlify.core.datatypes.Invocable;
import org.aksw.sparqlify.core.datatypes.InvocableComposite;
import org.aksw.sparqlify.core.datatypes.XMethod;

public class SqlMethodCandidate {
    private XMethod method;
    private List<XMethod> argCoercions;

    public SqlMethodCandidate(XMethod method, List<XMethod> argCoercions) {
        this.method = method;
        this.argCoercions = argCoercions;
    }

    public XMethod getMethod() {
        return this.method;
    }

    public List<XMethod> getArgCoercions() {
        return this.argCoercions;
    }

    public Invocable getInvocable() {
        Invocable[] invocables = null;
        if (this.argCoercions != null) {
            invocables = new Invocable[this.argCoercions.size()];
            for (int i = 0; i < this.argCoercions.size(); ++i) {
                XMethod argCoercion = this.argCoercions.get(i);
                if (argCoercion == null) continue;
                invocables[i] = argCoercion.getInvocable();
            }
        }
        InvocableComposite result = new InvocableComposite(this.method.getInvocable(), invocables);
        return result;
    }

    public String toString() {
        return "MethodCandidate [method=" + this.method + ", argCoercions=" + this.argCoercions + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.argCoercions == null ? 0 : this.argCoercions.hashCode());
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SqlMethodCandidate other = (SqlMethodCandidate)obj;
        if (this.argCoercions == null ? other.argCoercions != null : !this.argCoercions.equals(other.argCoercions)) {
            return false;
        }
        return !(this.method == null ? other.method != null : !this.method.equals(other.method));
    }
}

