/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.algorithms;

import com.google.common.base.Joiner;
import com.hp.hpl.jena.sdb.core.JoinType;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aksw.commons.util.reflect.MultiMethod;
import org.aksw.sparqlify.algebra.sql.exprs2.S_Constant;
import org.aksw.sparqlify.algebra.sql.exprs2.SqlExpr;
import org.aksw.sparqlify.algebra.sql.nodes.Projection;
import org.aksw.sparqlify.algebra.sql.nodes.Schema;
import org.aksw.sparqlify.algebra.sql.nodes.SqlNodeEmpty;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOp;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpEmpty;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpJoin;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpJoinN;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpQuery;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpSelectBlock;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpTable;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpUnionN;
import org.aksw.sparqlify.algebra.sql.nodes.SqlSortCondition;
import org.aksw.sparqlify.algebra.sql.nodes.SqlUnion;
import org.aksw.sparqlify.core.TypeToken;
import org.aksw.sparqlify.core.cast.SqlValue;
import org.aksw.sparqlify.core.interfaces.SqlExprSerializer;
import org.aksw.sparqlify.core.interfaces.SqlOpSerializer;
import org.aksw.sparqlify.util.SparqlifyUtils;
import org.apache.jena.atlas.io.IndentedWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlOpSerializerImpl
implements SqlOpSerializer {
    private static final Logger logger = LoggerFactory.getLogger(SqlOpSerializerImpl.class);
    private SqlExprSerializer exprSerializer;

    public SqlOpSerializerImpl(SqlExprSerializer exprSerializer) {
        this.exprSerializer = exprSerializer;
    }

    @Override
    public String serialize(SqlOp op) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IndentedWriter writer = new IndentedWriter((OutputStream)out);
        this.serialize(op, writer);
        writer.flush();
        writer.close();
        String result = SparqlifyUtils.toUtf8String(out);
        return result;
    }

    public void serialize(SqlOp op, IndentedWriter writer) {
        MultiMethod.invoke((Object)this, (String)"_serialize", (Object[])new Object[]{op, writer});
    }

    public String projection(Projection projection) {
        String result = this.projection(projection.getNames(), projection.getNameToExpr());
        return result;
    }

    public String projection(List<String> columnNames, Map<String, SqlExpr> map) {
        if (columnNames.isEmpty()) {
            return "true";
        }
        String result = "";
        ArrayList<String> strs = new ArrayList<String>();
        for (String columnName : columnNames) {
            SqlExpr value = map.get(columnName);
            String exprStr = "";
            if (value != null) {
                exprStr = this.exprSerializer.serialize(value);
            }
            String asSeparator = " ";
            strs.add(exprStr + asSeparator + SqlOpSerializerImpl.escapeAlias(columnName));
        }
        result = Joiner.on((String)", ").join(strs);
        return result;
    }

    public static String escapeAlias(String columnName) {
        return "\"" + columnName + "\"";
    }

    public void _serialize(SqlOpEmpty node, IndentedWriter writer) {
        writer.print("(SELECT ");
        HashMap<String, SqlExpr> proj = new HashMap<String, SqlExpr>();
        S_Constant sqlExpr = S_Constant.create(new SqlValue(TypeToken.Int, null));
        Schema schema = node.getSchema();
        List<String> columnNames = schema.getColumnNames();
        for (String columnName : columnNames) {
            proj.put(columnName, sqlExpr);
        }
        String projStr = this.projection(columnNames, proj);
        writer.print(projStr);
        writer.print(" WHERE FALSE)");
        if (node.getAliasName() != null) {
            writer.print(" " + node.getAliasName());
        }
    }

    public void _serializeOld(SqlOpEmpty node, IndentedWriter writer) {
        writer.print("(SELECT NULL WHERE FALSE)");
        if (node.getAliasName() != null) {
            writer.print(" " + node.getAliasName());
        }
    }

    public void _serialize(SqlOpJoinN node, IndentedWriter writer) {
        List<SqlOp> subOps = node.getSubOps();
        boolean isFirst = true;
        for (SqlOp subOp : subOps) {
            boolean needsGrouping;
            if (!isFirst) {
                writer.println(", ");
            }
            isFirst = false;
            boolean isSubSelect = subOp instanceof SqlOpSelectBlock;
            boolean isUnion = subOp instanceof SqlOpUnionN;
            boolean bl = needsGrouping = isSubSelect || isUnion;
            if (needsGrouping) {
                writer.print("(");
                writer.incIndent();
            }
            this.serialize(subOp, writer);
            if (!needsGrouping) continue;
            writer.decIndent();
            writer.print(") " + SqlOpSelectBlock.getAliasName(subOp));
        }
    }

    public void _serialize(SqlNodeEmpty node, IndentedWriter writer) {
        writer.print("EMPTY_SQL_NODE");
    }

    public void _serialize(SqlOpQuery node, IndentedWriter writer) {
        if (node.getAliasName() == null) {
            writer.print(node.getQueryString());
        } else {
            writer.print("(" + node.getQueryString() + ") " + node.getAliasName());
        }
    }

    public static String getAliasNameNotNull(SqlOp op) {
        String aliasName = SqlOpSelectBlock.getAliasName(op);
        if (aliasName == null || aliasName.isEmpty()) {
            return "";
        }
        return " " + aliasName;
    }

    public void _serialize(SqlOpSelectBlock op, IndentedWriter writer) {
        boolean needsGrouping;
        writer.print("SELECT ");
        if (op.isDistinct()) {
            writer.print("DISTINCT ");
        }
        String projectionStr = this.projection(op.getProjection());
        writer.println(projectionStr);
        writer.println("FROM");
        boolean bl = needsGrouping = op.getSubOp() instanceof SqlOpUnionN || op.getSubOp() instanceof SqlOpSelectBlock;
        if (needsGrouping) {
            writer.print("(");
        }
        writer.incIndent();
        this.serialize(op.getSubOp(), writer);
        writer.decIndent();
        if (needsGrouping) {
            String aliasName = SqlOpSerializerImpl.getAliasNameNotNull(op.getSubOp());
            writer.print(")" + aliasName);
        }
        if (!writer.atLineStart()) {
            // empty if block
        }
        ArrayList<String> strs = new ArrayList<String>();
        for (SqlExpr sqlExpr : op.getConditions()) {
            if (sqlExpr == null) {
                logger.error("Null expression in: " + op);
                continue;
            }
            String str = this.exprSerializer.serialize(sqlExpr);
            assert (str != null) : "An expression was serialized as null: " + sqlExpr;
            strs.add(str);
        }
        if (!strs.isEmpty()) {
            writer.println();
            writer.print("WHERE ");
        }
        writer.println(Joiner.on((String)" AND ").join(strs));
        ArrayList<String> groupByExprStrs = new ArrayList<String>();
        for (SqlExpr sqlExpr : op.getGroupByExprs()) {
            String exprStr = this.exprSerializer.serialize(sqlExpr);
            groupByExprStrs.add(exprStr);
        }
        if (!groupByExprStrs.isEmpty()) {
            String groupByStr = "GROUP BY " + Joiner.on((String)", ").join(groupByExprStrs);
            writer.println(groupByStr);
        }
        ArrayList<String> sortColumnExprStrs = new ArrayList<String>();
        for (SqlSortCondition condition : op.getSortConditions()) {
            String dirStr = null;
            if (condition.getDirection() == 1) {
                dirStr = "ASC";
            } else if (condition.getDirection() == -1) {
                dirStr = "DESC";
            }
            String exprStr = this.exprSerializer.serialize(condition.getExpression());
            if (dirStr != null) {
                exprStr = exprStr + " " + dirStr;
            }
            sortColumnExprStrs.add(exprStr);
        }
        String string = "";
        if (!sortColumnExprStrs.isEmpty()) {
            String string2 = "ORDER BY " + Joiner.on((String)", ").join(sortColumnExprStrs);
            writer.println(string2);
        }
        if (op.getLimit() != null) {
            writer.println("LIMIT " + op.getLimit());
        }
        if (op.getOffset() != null) {
            writer.println("OFFSET " + op.getOffset());
        }
    }

    public void _serialize(SqlUnion node, IndentedWriter writer) {
        throw new RuntimeException("SqlUnion is deprecated. Use SqlUnionN instead.");
    }

    public void _serialize(SqlOpUnionN op, IndentedWriter writer) {
        writer.incIndent();
        ArrayList parts = new ArrayList();
        List<SqlOp> members = op.getSubOps();
        for (int i = 0; i < members.size(); ++i) {
            SqlOp arg = members.get(i);
            boolean needsGrouping = false;
            if (arg instanceof SqlOpSelectBlock) {
                SqlOpSelectBlock block = (SqlOpSelectBlock)arg;
                boolean bl = needsGrouping = block.getLimit() != null || block.getOffset() != null || !block.getSortConditions().isEmpty() || !block.getGroupByExprs().isEmpty();
            }
            if (needsGrouping) {
                writer.print("(");
                writer.newline();
            }
            writer.incIndent();
            this.serialize(arg, writer);
            writer.decIndent();
            if (needsGrouping) {
                writer.print(")");
                writer.newline();
            }
            if (i == op.getSubOps().size() - 1) continue;
            writer.println("UNION ALL");
        }
        writer.decIndent();
    }

    public void serializeJoinU(SqlOp op, String aliasName, IndentedWriter writer) {
        boolean isSubSelect;
        boolean bl = isSubSelect = op instanceof SqlOpSelectBlock || op instanceof SqlOpUnionN;
        if (isSubSelect) {
            writer.println("(");
            writer.incIndent();
        }
        this.serialize(op, writer);
        if (isSubSelect) {
            writer.decIndent();
            if (!writer.atLineStart()) {
                writer.println();
            }
            writer.print(") " + aliasName);
        }
    }

    public void _serialize(SqlOpJoin op, IndentedWriter writer) {
        this.serializeJoinU(op.getLeft(), SqlOpSelectBlock.getAliasName(op.getLeft()), writer);
        String restrictionStr = "";
        ArrayList<String> strs = new ArrayList<String>();
        for (SqlExpr expr : op.getConditions()) {
            strs.add(this.exprSerializer.serialize(expr));
        }
        restrictionStr = Joiner.on((String)" AND ").join(strs);
        if (!restrictionStr.isEmpty()) {
            restrictionStr = " ON (" + restrictionStr + ")";
        } else if (op.getJoinType().equals((Object)JoinType.LEFT)) {
            restrictionStr = " ON (TRUE)";
        }
        String joinOp = "";
        if (op.getJoinType().equals((Object)JoinType.INNER)) {
            if (strs.isEmpty()) {
                joinOp = ",";
                writer.println(joinOp);
            } else {
                joinOp = strs.isEmpty() ? ", " : "JOIN ";
                writer.println();
                writer.print(joinOp);
            }
        } else if (op.getJoinType().equals((Object)JoinType.LEFT)) {
            joinOp = "LEFT JOIN ";
            writer.println();
            writer.print(joinOp);
        } else {
            throw new RuntimeException("Join type not supported");
        }
        this.serializeJoinU(op.getRight(), SqlOpSelectBlock.getAliasName(op.getRight()), writer);
        if (!restrictionStr.isEmpty()) {
            writer.println(restrictionStr);
        }
    }

    public static void _serialize(SqlOpTable op, IndentedWriter writer) {
        String encTableName = "\"" + op.getTableName() + "\"";
        writer.print(encTableName);
        writer.print(SqlOpSerializerImpl.getAliasNameNotNull(op));
    }
}

