/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.algorithms;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Sets;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Var;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.collections.multimaps.IBiSetMultimap;
import org.aksw.sparqlify.core.algorithms.VarBinding;
import org.aksw.sparqlify.core.algorithms.ViewInstance;
import org.aksw.sparqlify.core.algorithms.ViewInstanceJoin;

public class SelfJoinEliminator {
    public static ViewInstance merge(ViewInstance a, ViewInstance b) {
        if (((ViewInstance)a).getViewDefinition() != ((ViewInstance)b).getViewDefinition()) {
            System.out.println(((ViewInstance)a).getViewDefinition());
            System.out.println(((ViewInstance)b).getViewDefinition());
            return null;
        }
        IBiSetMultimap<Var, Var> backA = ((ViewInstance)a).getBinding().getViewVarToQueryVars();
        IBiSetMultimap<Var, Var> backB = ((ViewInstance)b).getBinding().getViewVarToQueryVars();
        if (backB.keySet().size() > backA.keySet().size()) {
            Object t = a;
            a = b;
            b = t;
            IBiSetMultimap<Var, Var> backT = backA;
            backA = backB;
            backB = backT;
        }
        for (Var varA : backA.keySet()) {
            Set varsA = backA.get((Object)varA);
            Set set = backB.get((Object)varA);
            if (set.isEmpty() || !Sets.intersection((Set)varsA, (Set)set).isEmpty()) continue;
            return null;
        }
        Map<Var, Node> a_queryToConst = ((ViewInstance)a).getBinding().getQueryVarToConstant();
        Map<Var, Node> b_queryToConst = ((ViewInstance)b).getBinding().getQueryVarToConstant();
        for (Map.Entry entry : a_queryToConst.entrySet()) {
            Var a_queryVar;
            Var b_queryVar = a_queryVar = (Var)entry.getKey();
            Node a_value = (Node)entry.getValue();
            Node b_value = b_queryToConst.get(b_queryVar);
            if (b_value == null || a_value.equals((Object)b_value)) continue;
            return null;
        }
        VarBinding mergedBinding = new VarBinding();
        mergedBinding.putAll(((ViewInstance)a).getBinding());
        mergedBinding.putAll(((ViewInstance)b).getBinding());
        ViewInstance viewInstance = new ViewInstance(((ViewInstance)a).getViewDefinition(), mergedBinding);
        return viewInstance;
    }

    public static void merge(ViewInstanceJoin conjunction) {
        ListMultimap nameToInstance = conjunction.getInstancesGroupedByParent();
        for (Map.Entry entry : nameToInstance.asMap().entrySet()) {
            List list = (List)entry.getValue();
            SelfJoinEliminator.eliminateSelfJoins(list);
        }
    }

    public static void eliminateSelfJoins(List<ViewInstance> viewInstances) {
        for (int i = 0; i < viewInstances.size(); ++i) {
            ViewInstance a = viewInstances.get(i);
            for (int j = i + 1; j < viewInstances.size(); ++j) {
                ViewInstance b = viewInstances.get(j);
                ViewInstance view = SelfJoinEliminator.merge(a, b);
                if (view == null) continue;
                a = view;
                viewInstances.set(i, view);
                viewInstances.remove(j);
                --j;
            }
        }
    }
}

