/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.SortCondition;
import com.hp.hpl.jena.sdb.core.Generator;
import com.hp.hpl.jena.sdb.core.Gensym;
import com.hp.hpl.jena.sdb.core.JoinType;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.expr.E_Equals;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprAggregator;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.util.ExprUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.collections.CartesianProduct;
import org.aksw.commons.util.Pair;
import org.aksw.sparqlify.algebra.sparql.expr.E_RdfTerm;
import org.aksw.sparqlify.algebra.sparql.expr.old.ExprSqlBridge;
import org.aksw.sparqlify.algebra.sparql.transform.ConstantExpander;
import org.aksw.sparqlify.algebra.sparql.transform.ExprDatatypeHash;
import org.aksw.sparqlify.algebra.sparql.transform.FunctionExpander;
import org.aksw.sparqlify.algebra.sparql.transform.NodeExprSubstitutor;
import org.aksw.sparqlify.algebra.sparql.transform.SqlExprUtils;
import org.aksw.sparqlify.algebra.sql.exprs.SqlExpr;
import org.aksw.sparqlify.algebra.sql.exprs.SqlExprAggregator;
import org.aksw.sparqlify.algebra.sql.exprs.SqlExprBase;
import org.aksw.sparqlify.algebra.sql.exprs.SqlExprColumn;
import org.aksw.sparqlify.algebra.sql.exprs.SqlExprList;
import org.aksw.sparqlify.algebra.sql.exprs.SqlExprValue;
import org.aksw.sparqlify.algebra.sql.exprs.SqlSortCondition;
import org.aksw.sparqlify.algebra.sql.nodes.SqlAlias;
import org.aksw.sparqlify.algebra.sql.nodes.SqlDistinct;
import org.aksw.sparqlify.algebra.sql.nodes.SqlGroup;
import org.aksw.sparqlify.algebra.sql.nodes.SqlJoin;
import org.aksw.sparqlify.algebra.sql.nodes.SqlMyRestrict;
import org.aksw.sparqlify.algebra.sql.nodes.SqlNodeBase;
import org.aksw.sparqlify.algebra.sql.nodes.SqlNodeEmpty;
import org.aksw.sparqlify.algebra.sql.nodes.SqlNodeOld;
import org.aksw.sparqlify.algebra.sql.nodes.SqlNodeOrder;
import org.aksw.sparqlify.algebra.sql.nodes.SqlNodeUtil;
import org.aksw.sparqlify.algebra.sql.nodes.SqlProjection;
import org.aksw.sparqlify.algebra.sql.nodes.SqlQuery;
import org.aksw.sparqlify.algebra.sql.nodes.SqlSlice;
import org.aksw.sparqlify.algebra.sql.nodes.SqlTable;
import org.aksw.sparqlify.algebra.sql.nodes.SqlUnionN;
import org.aksw.sparqlify.algebra.sql.nodes.VarDef;
import org.aksw.sparqlify.compile.sparql.PushDown;
import org.aksw.sparqlify.compile.sparql.SqlAlgebraToString;
import org.aksw.sparqlify.compile.sparql.SqlExprOptimizer;
import org.aksw.sparqlify.compile.sparql.SqlSelectBlockCollector;
import org.aksw.sparqlify.core.ArgExpr;
import org.aksw.sparqlify.core.ColRelGenerator;
import org.aksw.sparqlify.core.RdfViewInstance;
import org.aksw.sparqlify.core.SqlDatatype;
import org.aksw.sparqlify.core.transformations.SqlTranslationUtils;
import org.aksw.sparqlify.expr.util.NodeValueUtils;
import org.aksw.sparqlify.restriction.RestrictionImpl;
import org.aksw.sparqlify.restriction.RestrictionSetImpl;
import org.aksw.sparqlify.trash.ExprCommonFactor;
import org.aksw.sparqlify.trash.ExprCopy;
import org.aksw.sparqlify.views.transform.SqlExprToExpr;
import org.apache.commons.lang.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sparql.DnfUtils;

@Deprecated
public class SqlNodeBinding {
    private static final Logger logger = LoggerFactory.getLogger(SqlNodeBinding.class);
    private String alias;
    public static int globalAliasId = 0;
    private Map<Node, Expr> sparqlVarToExpr = new HashMap<Node, Expr>();
    private Map<Var, Expr> sqlVarToExpr = new HashMap<Var, Expr>();
    private SqlExpr sqlNode;
    public static SqlExprOptimizer sqlTranslator = new SqlExprOptimizer();

    public SqlExpr getSqlNode() {
        return this.sqlNode;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setSqlNode(SqlExpr sqlNode) {
        this.sqlNode = sqlNode;
    }

    public Map<Node, Expr> getSparqlVarToExpr() {
        return this.sparqlVarToExpr;
    }

    public Map<Var, Expr> getSqlVarToExpr() {
        return this.sqlVarToExpr;
    }

    public Set<Node> getSparqlVarsMentioned() {
        return this.sparqlVarToExpr.keySet();
    }

    public static SqlNodeOld create(ColRelGenerator generator, RdfViewInstance viewInstance) {
        SqlNodeBase result;
        SqlNodeOld sqlNode = viewInstance.getParent().getSqlNode();
        String alias = generator.nextRelation();
        if (sqlNode instanceof SqlTable) {
            SqlTable tmp = (SqlTable)sqlNode;
            result = new SqlTable(alias, tmp.getTableName());
        } else if (sqlNode instanceof SqlQuery) {
            String outerAlias = generator.nextRelation();
            SqlQuery tmp = (SqlQuery)sqlNode;
            result = new SqlQuery(outerAlias, tmp.getQueryString(), alias);
            alias = outerAlias;
        } else {
            throw new NotImplementedException();
        }
        Multimap<Var, VarDef> sqlBinding = viewInstance.getSqlBinding();
        for (Map.Entry entry : viewInstance.getBinding().getEquiMap().getKeyToValue().entrySet()) {
            Var var = (Var)entry.getKey();
            if (sqlBinding.containsKey(entry.getKey())) continue;
            Expr expr = viewInstance.getDefiningExpr(var);
            RestrictionImpl r = viewInstance.getParent().getRestrictions().getRestriction(var);
            E_RdfTerm expand = SqlTranslationUtils.expandConstant((Node)entry.getValue());
            if (expr == null) {
                sqlBinding.put((Object)var, (Object)new VarDef((Expr)expand, new RestrictionImpl((Node)entry.getValue())));
                continue;
            }
            sqlBinding.put((Object)var, (Object)new VarDef(expr, r));
        }
        HashSet vars = new HashSet();
        for (Map.Entry entry : sqlBinding.asMap().entrySet()) {
            for (VarDef expr : (Collection)entry.getValue()) {
                vars.addAll(expr.getExpr().getVarsMentioned());
            }
        }
        for (Var var : vars) {
            SqlDatatype sqlDatatype = viewInstance.getParent().getColumnToDatatype().get(var.getName());
            if (sqlDatatype == null) {
                throw new RuntimeException("Datatype is null - no mapping for column named '" + var.getName() + "' in view " + viewInstance.getParent().getName());
            }
            SqlExprColumn column = new SqlExprColumn(alias, var.getName(), sqlDatatype);
            result.getAliasToColumn().put(var.getName(), column);
        }
        ArrayList<SqlExpr> arrayList = new ArrayList<SqlExpr>();
        for (Map.Entry entry : sqlBinding.asMap().entrySet()) {
            NodeExprSubstitutor substitutor = SqlNodeBinding.createSubstitutor(result.getAliasToColumn());
            Expr a = null;
            Expr b = null;
            for (VarDef def : (Collection)entry.getValue()) {
                b = def.getExpr();
                if (a != null) {
                    Expr tmp = SqlExprOptimizer.optimizeMM((Expr)new E_Equals(a, b));
                    if (tmp.equals(NodeValue.FALSE)) {
                        // empty if block
                    }
                    SqlExpr sqlExpr = SqlNodeBinding.forcePushDown(tmp, substitutor);
                    arrayList.add(sqlExpr);
                }
                a = b;
            }
            result.getSparqlVarToExprs().put(entry.getKey(), ((Collection)entry.getValue()).iterator().next());
        }
        if (!arrayList.isEmpty()) {
            SqlMyRestrict sqlMyRestrict = new SqlMyRestrict(result.getAliasName(), result);
            sqlMyRestrict.getConditions().addAll(arrayList);
            sqlMyRestrict.getSparqlVarToExprs().putAll(result.getSparqlVarToExprs());
            sqlMyRestrict.getAliasToColumn().putAll(result.getAliasToColumn());
            result = sqlMyRestrict;
        }
        return result;
    }

    public static SqlExpr forcePushDown(Expr expr, NodeExprSubstitutor substitutor) {
        Expr substituted = substitutor.transformMM(expr);
        Expr x = PushDown.pushDownMM(substituted);
        if (!(x instanceof ExprSqlBridge)) {
            throw new RuntimeException("Failed to push down '" + expr + "'");
        }
        SqlExpr result = ((ExprSqlBridge)x).getSqlExpr();
        return result;
    }

    public static SqlExprList forcePushDown(ExprList exprs, SqlNodeOld node) {
        SqlExprList result = new SqlExprList();
        for (Expr expr : exprs) {
            SqlExpr sqlExpr = SqlNodeBinding.forcePushDown(expr, node.getAliasToColumn());
            result.add(sqlExpr);
        }
        return result;
    }

    public static SqlExpr forcePushDown(Expr expr, Map<String, SqlExpr> aliasToColumn) {
        NodeExprSubstitutor substitutor = SqlNodeBinding.createSubstitutor(aliasToColumn);
        return SqlNodeBinding.forcePushDown(expr, substitutor);
    }

    public static SqlExpr forceShallowPushDown(Expr expr, Map<String, SqlExpr> aliasToColumn) {
        Map<String, SqlExpr> shallow = SqlNodeBinding.createShallowAliasToColumn(aliasToColumn);
        NodeExprSubstitutor substitutor = SqlNodeBinding.createSubstitutor(shallow);
        return SqlNodeBinding.forcePushDown(expr, substitutor);
    }

    public static SqlExpr rewriteExpr(SqlNodeBinding a, Expr expr) {
        return null;
    }

    public static String generateNextFreeId(String base, Set<String> used) {
        if (!used.contains(base)) {
            return base;
        }
        int i = 1;
        String id;
        while (used.contains(id = base + i)) {
            ++i;
        }
        return id;
    }

    /*
     * WARNING - void declaration
     */
    public static SqlNodeOld doJoinRename(ColRelGenerator generator, SqlNodeOld left, String leftAlias, SqlNodeOld right, String rightAlias) {
        SqlNodeEmpty result = new SqlNodeEmpty();
        if (leftAlias != null && leftAlias.equals(rightAlias)) {
            throw new RuntimeException("Two aliases equal - should not happen");
        }
        Set<String> colsA = left.getAliasToColumn().keySet();
        Set<String> colsB = right.getAliasToColumn().keySet();
        HashSet intersection = new HashSet(Sets.intersection(colsA, colsB));
        Sets.SetView union = Sets.union(colsA, colsB);
        HashMap<Object, String> colRefRenames = new HashMap<Object, String>();
        for (Object common : intersection) {
            SqlExpr sqlExpr = right.getAliasToColumn().get(common);
            String string = rightAlias + "_" + (String)common;
            String id = SqlNodeBinding.generateNextFreeId(string, (Set<String>)union);
            colRefRenames.put(common, id);
        }
        HashMap<void, SqlExpr> newBMap = new HashMap<void, SqlExpr>();
        for (String string : colsB) {
            void var14_22;
            String string2 = (String)colRefRenames.get(string);
            if (string2 == null) {
                String string3 = string;
            }
            SqlExpr sqlExpr = right.getAliasToColumn().get(string);
            newBMap.put(var14_22, sqlExpr);
        }
        result.getAliasToColumn().putAll(newBMap);
        HashMap<Var, ExprVar> exprMap = new HashMap<Var, ExprVar>();
        for (Map.Entry entry : colRefRenames.entrySet()) {
            exprMap.put(Var.alloc((String)((String)entry.getKey())), new ExprVar((String)entry.getValue()));
        }
        NodeExprSubstitutor nodeExprSubstitutor = new NodeExprSubstitutor(exprMap);
        HashMultimap hashMultimap = HashMultimap.create();
        for (Map.Entry entry : right.getSparqlVarToExprs().entries()) {
            VarDef before = (VarDef)entry.getValue();
            VarDef after = new VarDef(nodeExprSubstitutor.transformMM(before.getExpr()), before.getRestrictions());
            hashMultimap.put(entry.getKey(), (Object)after);
        }
        result.getSparqlVarToExprs().putAll((Multimap)hashMultimap);
        return result;
    }

    public static NodeExprSubstitutor createSubstitutor(Map<String, SqlExpr> aliasToColumn) {
        HashMap<Var, ExprSqlBridge> sqlSubstitutionMap = new HashMap<Var, ExprSqlBridge>();
        for (Map.Entry<String, SqlExpr> entry : aliasToColumn.entrySet()) {
            sqlSubstitutionMap.put(Var.alloc((String)entry.getKey()), new ExprSqlBridge(entry.getValue()));
        }
        NodeExprSubstitutor result = new NodeExprSubstitutor(sqlSubstitutionMap);
        return result;
    }

    public static NodeExprSubstitutor createSubstitutor(SqlNodeOld node) {
        return SqlNodeBinding.createSubstitutor(node.getAliasToColumn());
    }

    public static Pair<SqlNodeOld, SqlNodeOld> createJoinAlias(SqlNodeOld node, ColRelGenerator generator) {
        if (node instanceof SqlJoin || node.getAliasName() != null) {
            return Pair.create((Object)node, (Object)node);
        }
        String newAlias = generator.nextRelation();
        SqlAlias proj = SqlNodeBinding.createNewAlias(newAlias, node, generator);
        return Pair.create((Object)node, (Object)proj);
    }

    public static SqlNodeOld join(ColRelGenerator generator, SqlNodeOld _a, SqlNodeOld _b, JoinType joinType) {
        SqlNodeOld a = _a;
        SqlNodeOld b = _b;
        if (!(a instanceof SqlJoin) && !(a instanceof SqlTable) && !(a instanceof SqlQuery) || a instanceof SqlUnionN) {
            a = SqlNodeBinding.createNewAlias(generator.nextRelation(), a, generator);
        }
        if (!(b instanceof SqlJoin) && !(b instanceof SqlTable) && !(b instanceof SqlQuery) || b instanceof SqlUnionN) {
            b = SqlNodeBinding.createNewAlias(generator.nextRelation(), b, generator);
        }
        SqlNodeOld c = SqlNodeBinding.doJoinRename(generator, a, a.getAliasName(), b, b.getAliasName());
        SqlJoin result = SqlJoin.create(joinType, a, b);
        result.getAliasToColumn().putAll(a.getAliasToColumn());
        result.getAliasToColumn().putAll(c.getAliasToColumn());
        Sets.SetView cVars = Sets.difference(c.getSparqlVarsMentioned(), a.getSparqlVarsMentioned());
        result.getSparqlVarToExprs().putAll(a.getSparqlVarToExprs());
        for (Var var : cVars) {
            Collection exprC = c.getSparqlVarToExprs().get((Object)var);
            result.getSparqlVarToExprs().putAll((Object)var, (Iterable)exprC);
        }
        Sets.SetView commons = Sets.intersection(a.getSparqlVarsMentioned(), c.getSparqlVarsMentioned());
        NodeExprSubstitutor substitutor = SqlNodeBinding.createSubstitutor(result);
        for (Var var : commons) {
            ArrayList<SqlExpr> ors = new ArrayList<SqlExpr>();
            ArrayList<VarDef> newTermDefs = new ArrayList<VarDef>();
            Collection ebs = c.getSparqlVarToExprs().get((Object)var);
            boolean foundSatisfiableJoinCondition = false;
            RestrictionSetImpl ras = new RestrictionSetImpl(false);
            for (VarDef ea : a.getSparqlVarToExprs().get((Object)var)) {
                RestrictionSetImpl ra = ea.getRestrictions();
                for (VarDef eb : ebs) {
                    RestrictionSetImpl rc = ra.clone();
                    RestrictionSetImpl rb = eb.getRestrictions();
                    rc.stateRestriction(rb);
                    if (rc.isUnsatisfiable()) continue;
                    ras.addAlternatives(rc);
                    E_Equals tmp = new E_Equals(ea.getExpr(), eb.getExpr());
                    Expr optimized = SqlExprOptimizer.optimizeMM((Expr)tmp);
                    Expr substituted = substitutor.transformMM(optimized);
                    Expr pushedExpr = PushDown.pushDownMM(substituted);
                    SqlExpr sqlExpr = null;
                    if (!(pushedExpr instanceof ExprSqlBridge)) {
                        throw new RuntimeException("Could not push an expression");
                    }
                    sqlExpr = ((ExprSqlBridge)pushedExpr).getSqlExpr();
                    if (!SqlNodeBinding.isSatisfiable(sqlExpr)) continue;
                    ors.add(sqlExpr);
                    foundSatisfiableJoinCondition = true;
                }
                newTermDefs.add(new VarDef(ea.getExpr(), ras));
            }
            result.getSparqlVarToExprs().putAll((Object)var, newTermDefs);
            if (!foundSatisfiableJoinCondition) {
                SqlNodeEmpty x = new SqlNodeEmpty();
                x.getSparqlVarToExprs().putAll(result.getSparqlVarToExprs());
                x.getAliasToColumn().putAll(result.getAliasToColumn());
                return x;
            }
            if (ors.isEmpty()) continue;
            SqlExpr joinExpr = SqlExprUtils.orifyBalanced(ors);
            result.addCondition(joinExpr);
        }
        if (!SqlNodeBinding.isSatisfiable(result.getConditions())) {
            SqlNodeEmpty x = new SqlNodeEmpty();
            x.getSparqlVarToExprs().putAll(result.getSparqlVarToExprs());
            x.getAliasToColumn().putAll(result.getAliasToColumn());
            return x;
        }
        return result;
    }

    public static SqlNodeOld distinct(SqlNodeOld a) {
        SqlDistinct result = new SqlDistinct(a.getAliasName(), a);
        result.getAliasToColumn().putAll(a.getAliasToColumn());
        result.getSparqlVarToExprs().putAll(a.getSparqlVarToExprs());
        return result;
    }

    public static SqlNodeOld slice(SqlNodeOld a, ColRelGenerator generator, long start, long length) {
        SqlSlice result = new SqlSlice(a, start, length);
        result.getAliasToColumn().putAll(a.getAliasToColumn());
        result.getSparqlVarToExprs().putAll(a.getSparqlVarToExprs());
        return result;
    }

    public static void createNewAlias(String alias, SqlNodeOld target, SqlNodeOld source) {
        target.getSparqlVarToExprs().putAll(source.getSparqlVarToExprs());
        for (Map.Entry<String, SqlExpr> entry : source.getAliasToColumn().entrySet()) {
            target.getAliasToColumn().put(entry.getKey(), new SqlExprColumn(source.getAliasName(), entry.getKey(), entry.getValue().getDatatype()));
        }
    }

    public static void replaceAlias(String alias, SqlNodeOld node, ColRelGenerator columnNameColRelGenerator) {
        SqlAlias tmp = SqlNodeBinding.createNewAlias(alias, node, columnNameColRelGenerator);
        node.getAliasToColumn().clear();
        node.getSparqlVarToExprs().clear();
        node.getAliasToColumn().putAll(tmp.getAliasToColumn());
        node.getSparqlVarToExprs().putAll(tmp.getSparqlVarToExprs());
    }

    public static SqlAlias createNewAlias(String alias, SqlNodeOld node, ColRelGenerator generator) {
        SqlAlias result = new SqlAlias(alias, node);
        HashMap<Var, ExprVar> varRename = new HashMap<Var, ExprVar>();
        for (Map.Entry<String, SqlExpr> col : node.getAliasToColumn().entrySet()) {
            String newColumnName = col.getKey();
            varRename.put(Var.alloc((String)col.getKey()), new ExprVar(newColumnName));
            result.getAliasToColumn().put(newColumnName, new SqlExprColumn(alias, col.getKey(), col.getValue().getDatatype()));
        }
        NodeExprSubstitutor substitutor = new NodeExprSubstitutor(varRename);
        for (Map.Entry entry : node.getSparqlVarToExprs().entries()) {
            Expr newExpr = substitutor.transformMM(((VarDef)entry.getValue()).getExpr());
            result.getSparqlVarToExprs().put(entry.getKey(), (Object)new VarDef(newExpr, ((VarDef)entry.getValue()).getRestrictions()));
        }
        return result;
    }

    public static SqlProjection wrapWithProjection(String newAlias, SqlNodeOld tmp, ColRelGenerator generator) {
        SqlProjection node = new SqlProjection(newAlias, tmp);
        node.getAliasToColumn().putAll(tmp.getAliasToColumn());
        node.getSparqlVarToExprs().putAll(tmp.getSparqlVarToExprs());
        SqlProjection result = new SqlProjection(newAlias, node);
        SqlAlias newProj = SqlNodeBinding.createNewAlias(newAlias, (SqlNodeOld)node, generator);
        result.getAliasToColumn().putAll(newProj.getAliasToColumn());
        result.getSparqlVarToExprs().putAll(newProj.getSparqlVarToExprs());
        return result;
    }

    public static SqlNodeOld extend(SqlNodeOld node, VarExprList varExprList) {
        for (Map.Entry entry : varExprList.getExprs().entrySet()) {
            Var var = (Var)entry.getKey();
            Expr expr = (Expr)entry.getValue();
            if (expr.isVariable()) {
                Var otherVar = expr.asVar();
                node.getSparqlVarToExprs().putAll((Object)var, (Iterable)node.getSparqlVarToExprs().get((Object)otherVar));
                continue;
            }
            throw new RuntimeException("Implement me");
        }
        return node;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SqlExprList shallowPushX(Expr expr, Multimap<Var, VarDef> sparqlVarToExprs, Map<String, SqlExpr> aliasToColumn) {
        SqlExprList result = new SqlExprList();
        if (!expr.isVariable()) return SqlNodeBinding.shallowPush(new ExprList(expr), sparqlVarToExprs, aliasToColumn);
        Var v = expr.asVar();
        Collection defs = sparqlVarToExprs.get((Object)v);
        if (defs.isEmpty()) {
            logger.warn("Variable does not exist for sorting");
            return null;
        }
        if (defs.size() > 1) {
            throw new RuntimeException("Should not happen");
        }
        VarDef def = (VarDef)defs.iterator().next();
        Expr e = def.getExpr();
        if (!(e instanceof E_RdfTerm)) throw new RuntimeException("Should not happen");
        E_RdfTerm term = (E_RdfTerm)e;
        result = new SqlExprList();
        int i = 0;
        while (i < 4) {
            Expr arg = (Expr)term.getArgs().get(i);
            SqlExpr sqlExpr = SqlNodeBinding.forceShallowPushDown(arg, aliasToColumn);
            result.add(sqlExpr);
            ++i;
        }
        return result;
    }

    public static SqlNodeOld order(SqlNodeOld a, List<SortCondition> conditions, ColRelGenerator generator) {
        SqlAlias subSelect;
        ArrayList<SqlSortCondition> sqlConditions = new ArrayList<SqlSortCondition>();
        SqlAlias groupByNode = subSelect = SqlNodeBinding.createNewAlias(generator.nextRelation(), a, generator);
        SqlAlias tmp = SqlNodeBinding.createNewAlias(groupByNode.getAliasName(), (SqlNodeOld)subSelect, generator);
        Gensym genG = Gensym.create((String)"s");
        for (SortCondition condition : conditions) {
            for (Var var : condition.getExpression().getVarsMentioned()) {
                SqlAlgebraToString.groupBy(var, groupByNode, tmp, (Generator)genG);
            }
        }
        SqlProjection orderByNode = new SqlProjection(generator.nextRelation(), groupByNode);
        SqlAlias tmp2 = SqlNodeBinding.createNewAlias(orderByNode.getAliasName(), (SqlNodeOld)groupByNode, generator);
        SqlSelectBlockCollector.copyProjection(orderByNode, tmp2);
        SqlNodeOrder result = new SqlNodeOrder(orderByNode.getAliasName(), orderByNode, sqlConditions);
        Gensym gen = Gensym.create((String)"o");
        for (SortCondition condition : conditions) {
            SqlExprList pushed = SqlNodeBinding.shallowPushX(condition.getExpression(), orderByNode.getSparqlVarToExprs(), orderByNode.getAliasToColumn());
            if (pushed == null) continue;
            for (SqlExpr sqlExpr : pushed) {
                Set<SqlExprColumn> columnsMentioned = SqlExprBase.getColumnsMentioned(sqlExpr);
                if (columnsMentioned.isEmpty()) continue;
                boolean allowExprsInOrderByClause = false;
                if (allowExprsInOrderByClause) {
                    sqlConditions.add(new SqlSortCondition(sqlExpr, condition.getDirection()));
                    continue;
                }
                String dummyColumn = gen.next();
                orderByNode.getAliasToColumn().put(dummyColumn, sqlExpr);
                sqlConditions.add(new SqlSortCondition(new SqlExprColumn(null, dummyColumn, sqlExpr.getDatatype()), condition.getDirection()));
            }
        }
        result.getAliasToColumn().putAll(orderByNode.getAliasToColumn());
        result.getSparqlVarToExprs().putAll(orderByNode.getSparqlVarToExprs());
        return result;
    }

    public static Map<String, SqlExpr> createShallowAliasToColumn(Map<String, SqlExpr> aliasToColumn) {
        HashMap<String, SqlExpr> result = new HashMap<String, SqlExpr>();
        for (Map.Entry<String, SqlExpr> entry : aliasToColumn.entrySet()) {
            result.put(entry.getKey(), new SqlExprColumn(null, entry.getKey(), entry.getValue().getDatatype()));
        }
        return result;
    }

    public static SqlExprList shallowPush(ExprList exprs, Multimap<Var, VarDef> sparqlVarToExprs, Map<String, SqlExpr> aliasToColumn) {
        Map<String, SqlExpr> shallowAliasToColumn = SqlNodeBinding.createShallowAliasToColumn(aliasToColumn);
        return SqlNodeBinding.fullPush(exprs, shallowAliasToColumn, sparqlVarToExprs);
    }

    public static SqlExpr fullPush(Expr expr, SqlNodeOld node) {
        SqlExprList tmp = SqlNodeBinding.fullPush(new ExprList(expr), node);
        if (tmp.isEmpty()) {
            throw new RuntimeException("Should not happen");
        }
        return tmp.get(0);
    }

    public static SqlExprList fullPush(ExprList exprs, SqlNodeOld node) {
        return SqlNodeBinding.fullPush(exprs, node.getAliasToColumn(), node.getSparqlVarToExprs());
    }

    public static SqlExprList fullPush(ExprList exprs, Map<String, SqlExpr> aliasToColumn, Multimap<Var, VarDef> sparqlVarToExprs) {
        NodeExprSubstitutor substitutor = aliasToColumn == null ? null : SqlNodeBinding.createSubstitutor(aliasToColumn);
        SqlExprList result = new SqlExprList();
        for (Expr expr : exprs) {
            ArrayList vars = new ArrayList(expr.getVarsMentioned());
            ArrayList cartesianBase = new ArrayList();
            for (Var var : vars) {
                Collection varExprs = sparqlVarToExprs.get((Object)var);
                cartesianBase.add(new ArrayList(varExprs));
            }
            CartesianProduct cartesian = new CartesianProduct(cartesianBase);
            ArrayList<SqlExpr> ors = new ArrayList<SqlExpr>();
            for (List items : cartesian) {
                HashMap<Var, Expr> expanderMap = new HashMap<Var, Expr>();
                for (int i = 0; i < vars.size(); ++i) {
                    Var var = (Var)vars.get(i);
                    VarDef item = (VarDef)items.get(i);
                    expanderMap.put(var, item.getExpr());
                }
                NodeExprSubstitutor expander = new NodeExprSubstitutor(expanderMap);
                Expr functionExpand = FunctionExpander.transform(expr);
                Expr constantExpand = ConstantExpander.transform(functionExpand);
                Expr expand = expander.transformMM(constantExpand);
                Expr simplified = SqlExprOptimizer.optimizeMM(expand);
                Expr subbed = substitutor == null ? simplified : substitutor.transformMM(simplified);
                Expr pushed = PushDown.pushDownMM(subbed);
                SqlExpr sqlExpr = null;
                if (!(pushed instanceof ExprSqlBridge)) {
                    throw new RuntimeException("Could not push expressions");
                }
                sqlExpr = ((ExprSqlBridge)pushed).getSqlExpr();
                ors.add(sqlExpr);
            }
            SqlExpr orified = SqlExprUtils.orifyBalanced(ors);
            if (orified == null) continue;
            result.add(orified);
        }
        if (!SqlNodeBinding.isSatisfiable(result)) {
            return new SqlExprList(SqlExprValue.FALSE);
        }
        Iterator<SqlExpr> it = result.iterator();
        while (it.hasNext()) {
            SqlExpr item = it.next();
            if (!item.equals(SqlExprValue.TRUE)) continue;
            it.remove();
        }
        return result;
    }

    public static boolean isSatisfiable(SqlExpr sqlExpr) {
        Expr expr = SqlExprToExpr.convert(sqlExpr);
        if (expr.equals(SqlExprToExpr.UNKNOWN)) {
            return true;
        }
        Set<Set<Expr>> dnf = DnfUtils.toSetDnf(expr);
        return DnfUtils.isSatisfiable(dnf);
    }

    public static boolean isSatisfiable(SqlExprList sqlExprs) {
        if (sqlExprs.isEmpty()) {
            return true;
        }
        for (SqlExpr sqlExpr : sqlExprs) {
            if (SqlNodeBinding.isSatisfiable(sqlExpr)) continue;
            return false;
        }
        return true;
    }

    public static SqlNodeOld group(SqlNodeOld a, VarExprList groupVars, List<ExprAggregator> exprAggregator, Generator colGenerator) {
        NodeExprSubstitutor substitutor = SqlNodeBinding.createSubstitutor(a.getAliasToColumn());
        ArrayList<SqlExprAggregator> sqlAggregators = new ArrayList<SqlExprAggregator>();
        SqlGroup result = new SqlGroup(a, sqlAggregators);
        for (ExprAggregator item : exprAggregator) {
            Expr expr = item.getExpr();
            SqlExprAggregator sqlExpr = (SqlExprAggregator)SqlNodeBinding.forcePushDown(expr, substitutor);
            sqlAggregators.add(sqlExpr);
            String newColAlias = colGenerator.next();
            ExprVar exprVar = new ExprVar(Var.alloc((String)newColAlias));
            E_RdfTerm rdfTerm = E_RdfTerm.createTypedLiteral((Expr)exprVar, (Expr)NodeValue.makeNode((Node)sqlExpr.getDatatype().getXsd()));
            result.getSparqlVarToExprs().put((Object)item.getVar(), (Object)new VarDef((Expr)rdfTerm));
            result.getAliasToColumn().put(newColAlias, sqlExpr);
        }
        return result;
    }

    public static void updateProjection(SqlNodeOld a, String newAlias, ColRelGenerator generator) {
        SqlAlias newProj = SqlNodeBinding.createNewAlias(newAlias, a, generator);
        a = new SqlProjection(newAlias, a);
        a.getAliasToColumn().putAll(newProj.getAliasToColumn());
        a.getSparqlVarToExprs().putAll(newProj.getSparqlVarToExprs());
    }

    public static SqlNodeOld project(SqlNodeOld a, List<Var> vars, ColRelGenerator generator) {
        return SqlNodeBinding.projectWrap(a, vars, generator);
    }

    public static SqlNodeOld projectInPlace(SqlNodeOld result, List<Var> vars, ColRelGenerator generator) {
        HashSet<String> referencedColumns = new HashSet<String>();
        for (Var var : vars) {
            for (VarDef def : result.getSparqlVarToExprs().get((Object)var)) {
                for (Var item : def.getExpr().getVarsMentioned()) {
                    referencedColumns.add(item.getName());
                }
            }
        }
        result.getAliasToColumn().keySet().retainAll(referencedColumns);
        result.getSparqlVarToExprs().keySet().retainAll(vars);
        return result;
    }

    public static SqlNodeOld projectWrap(SqlNodeOld a, List<Var> vars, ColRelGenerator generator) {
        String newAlias = generator.nextRelation();
        SqlAlias newProj = SqlNodeBinding.createNewAlias(newAlias, a, generator);
        SqlProjection result = new SqlProjection(newAlias, a);
        result.getAliasToColumn().putAll(newProj.getAliasToColumn());
        result.getSparqlVarToExprs().putAll(newProj.getSparqlVarToExprs());
        HashSet<String> referencedColumns = new HashSet<String>();
        for (Var var : vars) {
            for (VarDef def : result.getSparqlVarToExprs().get((Object)var)) {
                for (Var item : def.getExpr().getVarsMentioned()) {
                    referencedColumns.add(item.getName());
                }
            }
        }
        result.getAliasToColumn().keySet().retainAll(referencedColumns);
        result.getSparqlVarToExprs().keySet().retainAll(vars);
        return result;
    }

    public static SqlNodeOld filter(SqlNodeOld a, ExprList exprs, ColRelGenerator generator) {
        SqlNodeBase result;
        SqlExprList sqlExprs = SqlNodeBinding.fullPush(exprs, a);
        if (a instanceof SqlNodeEmpty || !SqlNodeBinding.isSatisfiable(sqlExprs)) {
            SqlNodeBinding.fullPush(exprs, a);
            result = new SqlNodeEmpty();
        } else {
            SqlMyRestrict tmp = a instanceof SqlMyRestrict ? (SqlMyRestrict)a : new SqlMyRestrict(null, a);
            tmp.getConditions().addAll(sqlExprs);
            result = tmp;
        }
        result.getAliasToColumn().putAll(a.getAliasToColumn());
        result.getSparqlVarToExprs().putAll(a.getSparqlVarToExprs());
        return result;
    }

    public void unifyCommonExpression(Expr a, Expr b) {
    }

    /*
     * WARNING - void declaration
     */
    public static SqlNodeOld unionNew(ColRelGenerator generator, List<SqlNodeOld> sqlNodes) {
        void var8_14;
        HashMultimap commons = HashMultimap.create();
        ArrayList<HashMultimap> projections = new ArrayList<HashMultimap>();
        for (int i = 0; i < sqlNodes.size(); ++i) {
            HashMultimap tmp = HashMultimap.create();
            projections.add(tmp);
        }
        HashMultimap varToSqlNode = HashMultimap.create();
        for (int i = 0; i < sqlNodes.size(); ++i) {
            SqlNodeOld sqlNode = sqlNodes.get(i);
            for (Node node : sqlNode.getSparqlVarsMentioned()) {
                varToSqlNode.put((Object)((Var)node), (Object)i);
            }
        }
        Gensym aliasGen = Gensym.create((String)"c");
        ExprCommonFactor factorizer = new ExprCommonFactor((Generator)aliasGen);
        HashMap<String, SqlDatatype> allColumnsToDatatype = new HashMap<String, SqlDatatype>();
        for (Map.Entry entry : varToSqlNode.asMap().entrySet()) {
            Var var = (Var)entry.getKey();
            HashMultimap cluster = HashMultimap.create();
            Iterator<Object> iterator = ((Collection)entry.getValue()).iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                SqlNodeOld sqlNode = sqlNodes.get(n);
                Collection exprsForVar = sqlNode.getSparqlVarToExprs().get((Object)var);
                for (VarDef def : exprsForVar) {
                    Map<String, SqlDatatype> columnToDatatype = SqlNodeUtil.getColumnToDatatype(sqlNode);
                    Integer hash = ExprDatatypeHash.hash(def.getExpr(), columnToDatatype);
                    cluster.put((Object)hash, (Object)new ArgExpr(def.getExpr(), n));
                }
            }
            for (Map.Entry entry2 : cluster.asMap().entrySet()) {
                Collection argExprs = (Collection)entry2.getValue();
                ArrayList<Expr> exprs = new ArrayList<Expr>();
                HashMap<Integer, Integer> exprToNode = new HashMap<Integer, Integer>();
                int i = 0;
                for (ArgExpr argExpr : argExprs) {
                    exprs.add(argExpr.getExpr());
                    exprToNode.put(i, argExpr.getIndex());
                    ++i;
                }
                ArrayList<Map<Var, Expr>> partialProjections = new ArrayList<Map<Var, Expr>>();
                Expr common = factorizer.transform(exprs, partialProjections);
                commons.put((Object)var, (Object)new VarDef(common));
                for (int j = 0; j < partialProjections.size(); ++j) {
                    int originalIndex = (Integer)exprToNode.get(j);
                    Multimap projection = (Multimap)projections.get(originalIndex);
                    Map partialProjection = (Map)partialProjections.get(j);
                    for (Map.Entry ppEntry : partialProjection.entrySet()) {
                        projection.put(ppEntry.getKey(), (Object)new VarDef((Expr)ppEntry.getValue()));
                    }
                }
            }
        }
        boolean bl = false;
        while (var8_14 < projections.size()) {
            SqlNodeOld sqlNodeOld = sqlNodes.get((int)var8_14);
            Multimap projection = (Multimap)projections.get((int)var8_14);
            NodeExprSubstitutor substitutor = SqlNodeBinding.createSubstitutor(sqlNodeOld);
            HashMap<String, SqlExpr> subbedProj = new HashMap<String, SqlExpr>();
            for (Map.Entry entry : projection.entries()) {
                Expr subbed = substitutor.transformMM(((VarDef)entry.getValue()).getExpr());
                Expr pushed = PushDown.pushDownMM(subbed);
                if (!(pushed instanceof ExprSqlBridge)) {
                    throw new RuntimeException("Could not push down common sub expression");
                }
                SqlExpr sqlExpr = ((ExprSqlBridge)pushed).getSqlExpr();
                subbedProj.put(((Var)entry.getKey()).getName(), sqlExpr);
                allColumnsToDatatype.put(((Var)entry.getKey()).getName(), sqlExpr.getDatatype());
            }
            sqlNodeOld.getAliasToColumn().clear();
            sqlNodeOld.getAliasToColumn().putAll(subbedProj);
            sqlNodeOld.getSparqlVarToExprs().clear();
            sqlNodeOld.getSparqlVarToExprs().putAll((Multimap)commons);
            ++var8_14;
        }
        for (SqlNodeOld sqlNodeOld : sqlNodes) {
            Sets.SetView unboundColumns = Sets.difference(allColumnsToDatatype.keySet(), sqlNodeOld.getAliasToColumn().keySet());
            for (String columnName : unboundColumns) {
                SqlDatatype sqlDatatype = (SqlDatatype)allColumnsToDatatype.get(columnName);
                sqlNodeOld.getAliasToColumn().put(columnName, SqlExprValue.createNull(sqlDatatype));
            }
        }
        String string = generator.nextRelation();
        SqlUnionN sqlUnionN = new SqlUnionN(string, sqlNodes);
        sqlUnionN.getSparqlVarToExprs().putAll((Multimap)commons);
        for (Map.Entry entry : allColumnsToDatatype.entrySet()) {
            String columnName;
            columnName = (String)entry.getKey();
            SqlDatatype sqlDatatype = (SqlDatatype)entry.getValue();
            sqlUnionN.getAliasToColumn().put(columnName, new SqlExprColumn(string, columnName, sqlDatatype));
        }
        return sqlUnionN;
    }

    public static SqlNodeOld union(ColRelGenerator generator, List<SqlNodeOld> sqlNodes) {
        SqlDatatype datatype;
        Var var;
        SqlNodeOld sqlNode;
        int i;
        if (sqlNodes.isEmpty()) {
            return new SqlNodeEmpty();
        }
        if (sqlNodes.size() == 1) {
            return sqlNodes.get(0);
        }
        HashMultimap commons = HashMultimap.create();
        ArrayList<HashMultimap> projections = new ArrayList<HashMultimap>();
        for (int i2 = 0; i2 < sqlNodes.size(); ++i2) {
            HashMultimap tmp = HashMultimap.create();
            projections.add(tmp);
        }
        HashMultimap varToSqlNode = HashMultimap.create();
        Gensym aliasGen = Gensym.create((String)"c");
        for (i = 0; i < sqlNodes.size(); ++i) {
            sqlNode = sqlNodes.get(i);
            Iterator vars = new HashSet<Var>(sqlNode.getSparqlVarsMentioned());
            Iterator iterator = vars.iterator();
            while (iterator.hasNext()) {
                var = (Var)iterator.next();
                ArrayList termDefs = new ArrayList(sqlNode.getSparqlVarToExprs().get((Object)var));
                for (Iterator<Object> termDef : termDefs) {
                    Expr expr = ((VarDef)((Object)termDef)).getExpr();
                    if (!((VarDef)((Object)termDef)).getExpr().isConstant()) continue;
                    sqlNode.getSparqlVarToExprs().remove((Object)var, termDef);
                    NodeValue nv = ExprUtils.eval((Expr)expr);
                    Object o = NodeValueUtils.getValue(nv);
                    SqlExprValue sv = new SqlExprValue(o);
                    String columnAlias = aliasGen.next();
                    ArrayList<Expr> newArgs = new ArrayList<Expr>(expr.getFunction().getArgs());
                    newArgs.set(1, (Expr)new ExprVar(columnAlias));
                    Expr newExpr = ExprCopy.getInstance().copy(expr, newArgs);
                    VarDef newTermDef = new VarDef(newExpr);
                    sqlNode.getSparqlVarToExprs().put((Object)var, (Object)newTermDef);
                    sqlNode.getAliasToColumn().put(columnAlias, sv);
                    sqlNode.getSparqlVarToExprs().put((Object)var, (Object)newTermDef);
                }
            }
        }
        for (i = 0; i < sqlNodes.size(); ++i) {
            sqlNode = sqlNodes.get(i);
            for (Node node : sqlNode.getSparqlVarsMentioned()) {
                varToSqlNode.put((Object)((Var)node), (Object)i);
            }
        }
        ExprCommonFactor factorizer = new ExprCommonFactor((Generator)aliasGen);
        HashMap<String, SqlDatatype> allColumnsToDatatype = new HashMap<String, SqlDatatype>();
        for (Map.Entry entry : varToSqlNode.asMap().entrySet()) {
            Iterator<Object> termDef;
            var = (Var)entry.getKey();
            HashMultimap cluster = HashMultimap.create();
            RestrictionSetImpl restrictionsForVar = new RestrictionSetImpl(false);
            termDef = ((Collection)entry.getValue()).iterator();
            while (termDef.hasNext()) {
                int n = (Integer)termDef.next();
                SqlNodeOld sqlNode2 = sqlNodes.get(n);
                Collection exprsForVar = sqlNode2.getSparqlVarToExprs().get((Object)var);
                for (VarDef def : exprsForVar) {
                    restrictionsForVar.addAlternatives(def.getRestrictions());
                    Map<String, SqlDatatype> columnToDatatype = SqlNodeUtil.getColumnToDatatype(sqlNode2);
                    Integer hash = ExprDatatypeHash.hash(def.getExpr(), columnToDatatype);
                    cluster.put((Object)hash, (Object)new ArgExpr(def.getExpr(), n));
                }
            }
            for (Map.Entry entry2 : cluster.asMap().entrySet()) {
                Collection argExprs = (Collection)entry2.getValue();
                ArrayList<Expr> exprs = new ArrayList<Expr>();
                HashMap<Integer, Integer> exprToNode = new HashMap<Integer, Integer>();
                int i3 = 0;
                for (ArgExpr argExpr : argExprs) {
                    exprs.add(argExpr.getExpr());
                    exprToNode.put(i3, argExpr.getIndex());
                    ++i3;
                }
                ArrayList<Map<Var, Expr>> partialProjections = new ArrayList<Map<Var, Expr>>();
                Expr common = factorizer.transform(exprs, partialProjections);
                commons.put((Object)var, (Object)new VarDef(common, restrictionsForVar));
                for (int j = 0; j < partialProjections.size(); ++j) {
                    int originalIndex = (Integer)exprToNode.get(j);
                    Multimap projection = (Multimap)projections.get(originalIndex);
                    Map partialProjection = (Map)partialProjections.get(j);
                    for (Map.Entry ppEntry : partialProjection.entrySet()) {
                        projection.put(ppEntry.getKey(), (Object)new VarDef((Expr)ppEntry.getValue()));
                    }
                }
            }
        }
        for (int i4 = 0; i4 < projections.size(); ++i4) {
            SqlNodeOld sqlNodeOld = sqlNodes.get(i4);
            Multimap projection = (Multimap)projections.get(i4);
            NodeExprSubstitutor substitutor = SqlNodeBinding.createSubstitutor(sqlNodeOld);
            HashMap<String, SqlExpr> subbedProj = new HashMap<String, SqlExpr>();
            for (Map.Entry entry : projection.entries()) {
                Expr subbed = substitutor.transformMM(((VarDef)entry.getValue()).getExpr());
                Expr pushed = PushDown.pushDownMM(subbed);
                if (!(pushed instanceof ExprSqlBridge)) {
                    throw new RuntimeException("Could not push down common sub expression");
                }
                SqlExpr sqlExpr = ((ExprSqlBridge)pushed).getSqlExpr();
                subbedProj.put(((Var)entry.getKey()).getName(), sqlExpr);
                allColumnsToDatatype.put(((Var)entry.getKey()).getName(), sqlExpr.getDatatype());
            }
            sqlNodeOld.getAliasToColumn().clear();
            sqlNodeOld.getAliasToColumn().putAll(subbedProj);
            sqlNodeOld.getSparqlVarToExprs().clear();
            sqlNodeOld.getSparqlVarToExprs().putAll((Multimap)commons);
        }
        for (SqlNodeOld sqlNodeOld : sqlNodes) {
            Sets.SetView unboundColumns = Sets.difference(allColumnsToDatatype.keySet(), sqlNodeOld.getAliasToColumn().keySet());
            for (String columnName : unboundColumns) {
                datatype = (SqlDatatype)allColumnsToDatatype.get(columnName);
                sqlNodeOld.getAliasToColumn().put(columnName, SqlExprValue.createNull(datatype));
            }
        }
        String unionAlias = generator.nextRelation();
        SqlUnionN sqlUnionN = new SqlUnionN(unionAlias, sqlNodes);
        sqlUnionN.getSparqlVarToExprs().putAll((Multimap)commons);
        for (Map.Entry entry : allColumnsToDatatype.entrySet()) {
            String columnName;
            columnName = (String)entry.getKey();
            datatype = (SqlDatatype)entry.getValue();
            sqlUnionN.getAliasToColumn().put(columnName, new SqlExprColumn(unionAlias, columnName, datatype));
        }
        return sqlUnionN;
    }

    public void alignSql() {
    }
}

