/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.QuadPattern;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.E_Equals;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.collections.multimaps.IBiSetMultimap;
import org.aksw.sparqlify.algebra.sql.nodes.VarDef;
import org.aksw.sparqlify.core.ConstraintContainer;
import org.aksw.sparqlify.core.RdfView;
import org.aksw.sparqlify.core.RdfViewSystemOld;
import org.aksw.sparqlify.restriction.RestrictionImpl;
import sparql.TwoWayBinding;

public class RdfViewInstance {
    private Quad queryQuad;
    private Quad viewQuad;
    private QuadPattern queryQuads = new QuadPattern();
    private QuadPattern viewQuads = new QuadPattern();
    private int instanceId;
    private int subId;
    private RdfView instance;
    private BiMap<Node, Node> renamer;
    private RdfView parent;
    private TwoWayBinding binding;
    private ConstraintContainer constraints;

    public RdfViewInstance copy() {
        return new RdfViewInstance(this.queryQuad, this.viewQuad, this.instanceId, this.subId, this.parent, this.binding.copySubstitute(null));
    }

    public RdfViewInstance(Quad queryQuad, Quad viewQuad, int instanceId, int subId, RdfView parent, TwoWayBinding binding) {
        this.queryQuad = queryQuad;
        this.viewQuad = viewQuad;
        this.queryQuads.add(queryQuad);
        this.viewQuads.add(viewQuad);
        this.instanceId = instanceId;
        this.subId = subId;
        this.parent = parent;
        this.renamer = RdfViewSystemOld.createVariableMappingInstance(parent, instanceId);
        this.binding = binding.copySubstitute((Map<? extends Node, Node>)this.renamer);
        this.instance = parent.copySubstitute((Map)this.renamer);
        this.constraints = parent.getConstraints().copySubstitute((Map<Node, Node>)this.renamer);
    }

    public Expr getDefiningExpr(Var var) {
        Node parentName = (Node)this.renamer.inverse().get((Object)var);
        return this.parent.getBinding().get(parentName);
    }

    public List<Expr> getInferredDefiningExprs(Var var) {
        ArrayList<Expr> result = new ArrayList<Expr>();
        for (Var e : this.binding.getEquiMap().getEquivalences(var, true)) {
            Expr definingExpr = this.getDefiningExpr(e);
            if (definingExpr == null) continue;
            result.add(definingExpr);
        }
        Node constant = this.binding.getEquiMap().getKeyToValue().get(var);
        if (constant != null) {
            result.add((Expr)new E_Equals((Expr)new ExprVar(var), (Expr)NodeValue.makeNode((Node)constant)));
        }
        return result;
    }

    public boolean isViewVariable(Var var) {
        return var.getName().startsWith("view");
    }

    public SetMultimap<Var, Var> getQueryToParentBinding() {
        HashMultimap result = HashMultimap.create();
        for (Map.Entry entry : this.binding.getEquiMap().getEquivalences().entries()) {
            Var back = (Var)this.renamer.inverse().get(entry.getValue());
            if (back == null) continue;
            result.put(entry.getKey(), (Object)back);
        }
        return result;
    }

    public SetMultimap<Var, Var> getParentToQueryBinding() {
        HashMultimap result = HashMultimap.create();
        for (Map.Entry entry : this.binding.getEquiMap().getEquivalences().entries()) {
            Var back = (Var)this.renamer.inverse().get(entry.getValue());
            if (back == null) continue;
            result.put((Object)back, entry.getKey());
        }
        return result;
    }

    public QuadPattern getQueryQuads() {
        return this.queryQuads;
    }

    public QuadPattern getViewQuads() {
        return this.viewQuads;
    }

    public Quad getQueryQuad() {
        return this.queryQuad;
    }

    public Quad getViewQuad() {
        return this.queryQuad;
    }

    public int getInstanceId() {
        return this.instanceId;
    }

    public RdfView getInstance() {
        return this.instance;
    }

    public RdfView getParent() {
        return this.parent;
    }

    public BiMap<Node, Node> getRenamer() {
        return this.renamer;
    }

    public TwoWayBinding getBinding() {
        return this.binding;
    }

    public Multimap<Var, VarDef> getSqlBinding() {
        HashMultimap result = HashMultimap.create();
        Map<Node, Expr> parentBinding = this.parent.getBinding();
        for (Map.Entry<Node, Expr> entry : parentBinding.entrySet()) {
            Var node = (Var)this.renamer.get((Object)entry.getKey());
            RestrictionImpl r = this.parent.getRestrictions().getRestriction((Var)entry.getKey());
            IBiSetMultimap reverse = this.binding.getEquiMap().getEquivalences().getInverse();
            Set queryVars = reverse.get((Object)node);
            for (Var queryVar : queryVars) {
                result.put((Object)queryVar, (Object)new VarDef(entry.getValue(), r));
            }
        }
        return result;
    }

    public String toString() {
        return this.parent.getName() + " " + this.queryQuad + " " + this.binding;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.instanceId;
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        result = 31 * result + this.subId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RdfViewInstance other = (RdfViewInstance)obj;
        if (this.instanceId != other.instanceId) {
            return false;
        }
        if (this.parent == null ? other.parent != null : !this.parent.equals(other.parent)) {
            return false;
        }
        return this.subId == other.subId;
    }
}

