/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.QuadPattern;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.E_Equals;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.graph.NodeTransform;
import com.hp.hpl.jena.sparql.util.ExprUtils;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.XSD;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.sparqlify.algebra.sparql.transform.SparqlSubstitute;
import org.aksw.sparqlify.algebra.sql.nodes.SqlNodeOld;
import org.aksw.sparqlify.algebra.sql.nodes.SqlQuery;
import org.aksw.sparqlify.algebra.sql.nodes.SqlTable;
import org.aksw.sparqlify.config.lang.Constraint;
import org.aksw.sparqlify.config.syntax.QueryString;
import org.aksw.sparqlify.config.syntax.Relation;
import org.aksw.sparqlify.config.syntax.RelationRef;
import org.aksw.sparqlify.config.syntax.ViewDefinition;
import org.aksw.sparqlify.core.ConstraintContainer;
import org.aksw.sparqlify.core.RdfTermPattern;
import org.aksw.sparqlify.core.RdfTermPatternDerivation;
import org.aksw.sparqlify.core.RdfViewTemplate;
import org.aksw.sparqlify.core.SqlDatatype;
import org.aksw.sparqlify.restriction.RestrictionManagerImpl;
import org.aksw.sparqlify.sparqlview.View;
import org.aksw.sparqlify.trash.RenamerNodes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sparql.FilterUtils;
import sparql.PatternUtils;

public class RdfView
implements View {
    private static final Logger logger = LoggerFactory.getLogger(RdfView.class);
    private String name;
    private RdfViewTemplate template;
    private ExprList filter;
    private ConstraintContainer constraints;
    private RestrictionManagerImpl restrictions;
    private SqlNodeOld sqlNode;
    private Map<String, SqlDatatype> columnToDatatype = new HashMap<String, SqlDatatype>();
    private Map<Var, RdfTermPattern> varToPattern = new HashMap<Var, RdfTermPattern>();

    public RestrictionManagerImpl getRestrictions() {
        return this.restrictions;
    }

    public void setRestrictions(RestrictionManagerImpl restrictions) {
        this.restrictions = restrictions;
    }

    public Map<Var, RdfTermPattern> getVarToPattern() {
        return this.varToPattern;
    }

    @Override
    public Set<Var> getVarsMentioned() {
        return this.template.getVarsMentioned();
    }

    public Map<String, SqlDatatype> getColumnToDatatype() {
        return this.columnToDatatype;
    }

    @Override
    public RdfView copySubstitute(Map<Node, Node> map) {
        ExprList tmpFilter = new ExprList();
        RenamerNodes rename = new RenamerNodes(map);
        for (Expr expr : this.filter) {
            tmpFilter.add(expr.applyNodeTransform((NodeTransform)rename));
        }
        RdfView result = new RdfView(this.name, this.template.copySubstitute(map), tmpFilter, this.constraints.copySubstitute(map), this.sqlNode);
        return result;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static RdfView create(String str) {
        HashMap<String, String> defaultPrefixes = new HashMap<String, String>();
        defaultPrefixes.put("bif", "http://bif/");
        defaultPrefixes.put("rdf", RDF.getURI());
        defaultPrefixes.put("rdfs", RDFS.getURI());
        defaultPrefixes.put("geo", "http://ex.org/");
        defaultPrefixes.put("xsd", XSD.getURI());
        defaultPrefixes.put("spy", "http://aksw.org/sparqlify/");
        defaultPrefixes.put("wso", "http://aksw.org/wortschatz/ontology/");
        defaultPrefixes.put("rdf", RDF.getURI());
        defaultPrefixes.put("owl", OWL.getURI());
        return RdfView.create("unnamed", str, defaultPrefixes);
    }

    public static RdfView create(ViewDefinition definition) {
        throw new RuntimeException("Dont use anymore");
    }

    /*
     * WARNING - void declaration
     */
    public static RdfView create(String name, QuadPattern quadPattern, ExprList filters, List<Expr> bindings, List<Constraint> rawConstraints, Relation relation) {
        void var8_13;
        if (bindings == null) {
            bindings = new ArrayList<Expr>();
        }
        HashMap<Node, Expr> bindingMap = new HashMap<Node, Expr>();
        for (Expr expr : bindings) {
            if (!(expr instanceof E_Equals)) {
                throw new RuntimeException("Binding expr must have form ?var = ... --- instead got: " + expr);
            }
            Expr expr3 = expr.getFunction().getArg(2);
            expr3 = SparqlSubstitute.substituteExpr(expr3);
            Var var = expr.getFunction().getArg(1).asVar();
            bindingMap.put((Node)var, expr3);
        }
        if (rawConstraints == null) {
            rawConstraints = Collections.emptyList();
        }
        ConstraintContainer constraints = new ConstraintContainer(rawConstraints);
        for (Map.Entry entry : bindingMap.entrySet()) {
            if (constraints.getVarPatternConstraints().containsKey(entry.getKey())) continue;
            RdfTermPattern derivedPattern = RdfTermPatternDerivation.deriveRegex((Expr)entry.getValue());
            constraints.getVarPatternConstraints().put((Var)entry.getKey(), derivedPattern);
        }
        if (relation == null) {
            logger.warn("No relation given for view '" + name + "', using Select 1");
            SqlQuery sqlQuery = new SqlQuery(null, "SELECT 1");
        } else if (relation instanceof QueryString) {
            SqlQuery sqlQuery = new SqlQuery(null, ((QueryString)relation).getQueryString());
        } else if (relation instanceof RelationRef) {
            SqlTable sqlTable = new SqlTable(((RelationRef)relation).getRelationName());
        } else {
            throw new RuntimeException("Unsupported relation type: " + relation);
        }
        return new RdfView(name, quadPattern, filters, bindingMap, constraints, (SqlNodeOld)var8_13);
    }

    /*
     * WARNING - void declaration
     */
    public static RdfView create(String name, String str, Map<String, String> defaultPrefixes) {
        void var13_17;
        PrefixMappingImpl defaultPrefixMapping = new PrefixMappingImpl();
        defaultPrefixMapping.setNsPrefixes(defaultPrefixes);
        String[] parts1 = str.split("\\swith\\s", 2);
        String[] parts2 = parts1[1].split(";");
        String sqlStr = parts2[parts2.length - 1].trim();
        String queryStr = "Select * " + parts1[0];
        String[] bindingStrs = Arrays.copyOf(parts2, parts2.length - 1);
        Query query = new Query();
        query.setPrefixMapping((PrefixMapping)defaultPrefixMapping);
        QueryFactory.parse((Query)query, (String)queryStr, null, (Syntax)Syntax.syntaxSPARQL);
        Op op = Algebra.compile((Query)query);
        op = Algebra.toQuadForm((Op)op);
        QuadPattern quadPattern = new QuadPattern();
        for (Quad quad : PatternUtils.collectQuads(op)) {
            quadPattern.add(quad);
        }
        HashMap<Node, Expr> binding = new HashMap<Node, Expr>();
        for (String bindingStr : bindingStrs) {
            Expr expr = ExprUtils.parse((String)bindingStr, (PrefixMapping)defaultPrefixMapping);
            if (!(expr instanceof E_Equals)) {
                throw new RuntimeException("Binding expr must have form ?var = ... --- instead got: " + bindingStr);
            }
            Expr definition = expr.getFunction().getArg(2);
            definition = SparqlSubstitute.substituteExpr(definition);
            Var var = expr.getFunction().getArg(1).asVar();
            binding.put((Node)var, definition);
        }
        if (sqlStr.startsWith("select")) {
            SqlQuery sqlQuery = new SqlQuery(null, sqlStr);
        } else {
            SqlTable sqlTable = new SqlTable(sqlStr);
        }
        ExprList filter = FilterUtils.collectExprs(op, new ExprList());
        return new RdfView(name, quadPattern, filter, binding, new ConstraintContainer(), (SqlNodeOld)var13_17);
    }

    public RdfView(String name, RdfViewTemplate template, ExprList filter, ConstraintContainer constraints, SqlNodeOld sqlExpr) {
        this.name = name;
        this.template = template;
        this.filter = filter;
        this.constraints = constraints;
        this.sqlNode = sqlExpr;
    }

    public RdfView(String name, QuadPattern quadPattern, ExprList filter, Map<Node, Expr> binding, ConstraintContainer constraints, SqlNodeOld sqlExpr) {
        this.name = name;
        this.template = new RdfViewTemplate(quadPattern, binding);
        this.filter = filter;
        this.constraints = constraints;
        this.sqlNode = sqlExpr;
    }

    @Deprecated
    public QuadPattern getQuadPattern() {
        return this.template.getQuadPattern();
    }

    public ExprList getFilter() {
        return this.filter;
    }

    @Deprecated
    public Map<Node, Expr> getBinding() {
        return this.template.getBinding();
    }

    public SqlNodeOld getSqlNode() {
        return this.sqlNode;
    }

    public ConstraintContainer getConstraints() {
        return this.constraints;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RdfView other = (RdfView)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

