/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.compile.sparql;

import com.hp.hpl.jena.sdb.sql.SQLUtils;
import java.sql.Timestamp;
import java.util.Calendar;
import org.aksw.commons.factory.Factory1;
import org.aksw.sparqlify.compile.sparql.DatatypeToStringPostgres;
import org.aksw.sparqlify.compile.sparql.SqlExprSerializerDefault;
import org.aksw.sparqlify.core.SqlDatatype;
import org.postgis.PGgeometry;

class SqlExprSerializerPostgres
extends SqlExprSerializerDefault {
    public SqlExprSerializerPostgres() {
        super(new DatatypeToStringPostgres());
    }

    @Override
    public String serializeConstant(Object value, SqlDatatype datatype) {
        if (value == null) {
            Factory1<String> caster = this.datatypeSerializer.asString(datatype);
            return caster.create("NULL");
        }
        if (value instanceof String) {
            return SQLUtils.quoteStr((String)value.toString());
        }
        if (value instanceof Number) {
            return value.toString();
        }
        if (value instanceof Calendar) {
            Timestamp sqlDateTime = new Timestamp(((Calendar)value).getTime().getTime());
            return SQLUtils.quoteStr((String)sqlDateTime.toString());
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof PGgeometry) {
            return "'SRID=4326;" + value.toString() + "'";
        }
        throw new RuntimeException("Don't know how to serialize " + value + " to an SQL string");
    }
}

