/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections.iterators;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class StackCartesianProductIterator<T>
implements Iterator<List<T>> {
    private List<? extends Iterable<? extends T>> collections;
    private List<Iterator<? extends T>> iterators;
    private List<T> current;
    private List<T> result;
    private List<T> resultView;
    private boolean hasNext = true;

    public StackCartesianProductIterator(T[] ... collections) {
        ArrayList<Iterable<T>> tmp = new ArrayList<Iterable<T>>(collections.length);
        for (T[] item : collections) {
            tmp.add(Arrays.asList(item));
        }
        this.collections = tmp;
        this.init();
    }

    public StackCartesianProductIterator(Iterable<? extends T> ... collections) {
        this.collections = Arrays.asList(collections);
        this.init();
    }

    public StackCartesianProductIterator(List<? extends Iterable<? extends T>> collections) {
        this.collections = collections;
        this.init();
    }

    private void init() {
        List<Integer> indexesOfEmptySubIterables = StackCartesianProductIterator.getIndexesOfEmptySubIterables(this.collections);
        if (!indexesOfEmptySubIterables.isEmpty()) {
            throw new RuntimeException("Cannot create a iterator when there exists an empty sub-iterables at indexes " + indexesOfEmptySubIterables);
        }
        this.iterators = new ArrayList<Iterator<? extends T>>();
        this.current = new ArrayList<T>();
        this.result = new ArrayList<T>();
        Iterator<T> it = this.collections.get(0).iterator();
        this.iterators.add(it);
        this.current.add(it.next());
        this.result.add(null);
        this.resultView = Collections.unmodifiableList(this.result);
    }

    public static <T> List<Integer> getIndexesOfEmptySubIterables(List<? extends Iterable<? extends T>> iterables) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < iterables.size(); ++i) {
            Iterable<? extends T> iterable = iterables.get(i);
            if (!Iterables.isEmpty(iterable)) continue;
            result.add(i);
        }
        return result;
    }

    public boolean canDescend() {
        return this.iterators.size() < this.collections.size();
    }

    public void descend() {
        int index = this.iterators.size();
        if (index >= this.collections.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + " Size: " + this.collections.size());
        }
        Iterator<T> it = this.collections.get(index).iterator();
        this.iterators.add(it);
        this.current.add(it.next());
        this.result.add(null);
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    public List<T> peek() {
        this.adjustResultSize();
        for (int i = 0; i < this.current.size(); ++i) {
            this.result.set(i, this.current.get(i));
        }
        return this.result;
    }

    private void adjustResultSize() {
        while (this.result.size() < this.current.size()) {
            this.result.add(null);
        }
        while (this.result.size() > this.current.size()) {
            this.result.remove(this.result.size() - 1);
        }
    }

    @Override
    public List<T> next() {
        int i;
        if (!this.hasNext) {
            return null;
        }
        this.adjustResultSize();
        for (i = 0; i < this.current.size(); ++i) {
            this.result.set(i, this.current.get(i));
        }
        for (i = this.iterators.size() - 1; i >= 0; --i) {
            Iterator<T> it = this.iterators.get(i);
            if (!it.hasNext()) {
                if (i == 0) {
                    this.hasNext = false;
                    break;
                }
            } else {
                this.current.set(i, it.next());
                break;
            }
            this.iterators.remove(i);
            this.current.remove(i);
        }
        return this.resultView;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Operation not supported");
    }

    public static void main(String[] args) {
        List<String> a = Arrays.asList("a", "b");
        List<String> b = Arrays.asList("1", "2", "3");
        List<String> c = Arrays.asList("this", "is", "a", "test");
        List<String> d = Arrays.asList("x", "y");
        StackCartesianProductIterator it = new StackCartesianProductIterator(a, b, c, d);
        while (it.hasNext()) {
            List<String> current = it.peek();
            if (!StackCartesianProductIterator.isAccepted(current)) {
                it.next();
                continue;
            }
            System.out.println("Accepted Path: " + current);
            if (!it.canDescend()) {
                it.next();
                continue;
            }
            it.descend();
        }
    }

    public static boolean isAccepted(List<String> list) {
        return !list.contains("y") && !list.contains("1");
    }
}

