/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.changesets;

import com.google.common.collect.Sets;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.changesets.CollectionDecorator;
import org.aksw.changesets.FileLinePartition;
import org.aksw.changesets.Partition;
import org.aksw.changesets.Partitioner;
import org.aksw.commons.collections.diff.Diff;
import org.aksw.commons.collections.diff.HashSetDiff;
import org.aksw.commons.collections.diff.IDiff;

public class DiffPartitionMerger {
    private File baseDir;
    private int numPartitions;

    public static FileLinePartition asFilePartition(Partition<String> partition) {
        Object decoratee;
        if (partition instanceof CollectionDecorator && (decoratee = ((CollectionDecorator)((Object)partition)).getDecoratee()) instanceof FileLinePartition) {
            return (FileLinePartition)decoratee;
        }
        return null;
    }

    public DiffPartitionMerger(File baseDir, int numPartitions) {
        this.numPartitions = numPartitions;
        this.baseDir = baseDir;
    }

    public IDiff<Map<Integer, Partition<String>>> merge(List<IDiff<File>> diffs) throws IOException {
        ArrayList<Diff> partitions = new ArrayList<Diff>();
        Diff result = new Diff(new HashMap(), new HashMap(), null);
        HashSet<Object> usedPartitions = new HashSet<Object>();
        File tmpBaseDir = File.createTempFile("partition", "");
        int index = 0;
        for (IDiff<File> iDiff : diffs) {
            String tmpDir = tmpBaseDir.getAbsoluteFile() + "/" + index;
            Map<Integer, Partition<String>> a = Partitioner.partitionFile((File)iDiff.getAdded(), tmpDir, this.numPartitions);
            Map<Integer, Partition<String>> map = Partitioner.partitionFile((File)iDiff.getRemoved(), tmpDir, this.numPartitions);
            partitions.add(new Diff((Object)a, map, null));
            usedPartitions.addAll(a.keySet());
            usedPartitions.addAll(map.keySet());
            ++index;
        }
        for (Integer n : usedPartitions) {
            HashSetDiff mainDiff = new HashSetDiff();
            for (Diff diff : partitions) {
                Partition pa = (Partition)((Map)diff.getAdded()).get(n);
                Partition pb = (Partition)((Map)diff.getRemoved()).get(n);
                HashSet added = pa == null ? new HashSet() : new HashSet(pa);
                HashSet removed = pb == null ? new HashSet() : new HashSet(pb);
                HashSet intersectionA = new HashSet(Sets.intersection(added, (Set)((Set)mainDiff.getRemoved())));
                HashSet intersectionB = new HashSet(Sets.intersection(removed, (Set)((Set)mainDiff.getAdded())));
                added.remove(intersectionA);
                ((Set)mainDiff.getRemoved()).remove(intersectionA);
                removed.removeAll(intersectionB);
                ((Set)mainDiff.getAdded()).removeAll(intersectionB);
                ((Set)mainDiff.getAdded()).addAll(added);
                ((Set)mainDiff.getRemoved()).addAll(removed);
            }
            if (((Set)mainDiff.getAdded()).isEmpty() && ((Set)mainDiff.getRemoved()).isEmpty()) continue;
            Partition<String> added = this.getTargetPartition((Map)result.getAdded(), n, "added");
            added.open();
            for (String item : (Set)mainDiff.getAdded()) {
                added.add(item);
            }
            added.flush();
            added.close();
            Partition<String> partition = this.getTargetPartition((Map)result.getRemoved(), n, "removed");
            partition.open();
            for (String item : (Set)mainDiff.getRemoved()) {
                partition.add(item);
            }
            partition.flush();
            partition.close();
        }
        return result;
    }

    public Partition<String> getTargetPartition(Map<Integer, Partition<String>> map, int id, String suffix) {
        FileLinePartition result = map.get(id);
        if (result == null) {
            File file = new File(this.baseDir.getAbsoluteFile() + "/" + suffix + "/" + id + ".part");
            file.getParentFile().mkdirs();
            result = new FileLinePartition(file);
            map.put(id, result);
        }
        return result;
    }

    public static void writePartitions(Map<Integer, Partition<String>> map, PrintStream printer) {
        for (Partition<String> partition : map.values()) {
            for (String item : partition) {
                printer.println(item);
            }
        }
    }

    public static void writePartitions(Map<Integer, Partition<String>> map, File file) throws FileNotFoundException {
        PrintStream printer = new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));
        DiffPartitionMerger.writePartitions(map, printer);
        printer.flush();
        printer.close();
    }
}

