/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.update;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.graph.GraphFactory;
import com.hp.hpl.jena.sparql.modify.request.UpdateDataDelete;
import com.hp.hpl.jena.sparql.modify.request.UpdateDataInsert;
import com.hp.hpl.jena.sparql.modify.request.UpdateModify;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.update.Update;
import com.hp.hpl.jena.update.UpdateFactory;
import com.hp.hpl.jena.update.UpdateRequest;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.jena.util.QueryUtils;
import org.aksw.commons.util.reflect.MultiMethod;
import org.aksw.update.GraphListener;
import org.aksw.update.ModelSparqlEndpoint;

public class UpdateGraph {
    private Set<GraphListener> graphListeners = new HashSet<GraphListener>();
    private ModelSparqlEndpoint endpoint;
    private int batchSize = 128;

    public Set<GraphListener> getPreUpdateListeners() {
        return this.graphListeners;
    }

    public UpdateGraph(ModelSparqlEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public static Map<Node, Graph> quadsToGraphs(Collection<Quad> quads) {
        HashMap<Node, Graph> result = new HashMap<Node, Graph>();
        for (Quad quad : quads) {
            Triple triple = quad.asTriple();
            Node graphName = quad.getGraph();
            Graph graph = (Graph)result.get(graphName);
            if (graph == null) {
                graph = GraphFactory.createDefaultGraph();
                result.put(graphName, graph);
            }
            graph.add(triple);
        }
        return result;
    }

    private void insert(Collection<Quad> quads) {
        if (quads.isEmpty()) {
            return;
        }
        this.notifyPreUpdate(quads, null);
        for (Map.Entry<Node, Graph> entry : UpdateGraph.quadsToGraphs(quads).entrySet()) {
            Model model = ModelFactory.createModelForGraph((Graph)entry.getValue());
            this.endpoint.insert(model, entry.getKey().toString());
        }
        this.notifyPostUpdate(quads, null);
    }

    private void notifyPreUpdate(Collection<Quad> inserts, Collection<Quad> deletes) {
        for (GraphListener graphListener : this.graphListeners) {
            graphListener.onPreBatchStart();
            if (inserts != null) {
                for (Quad quad : inserts) {
                    graphListener.onPreInsert(quad);
                }
            }
            if (deletes != null) {
                for (Quad quad : deletes) {
                    graphListener.onPreDelete(quad);
                }
            }
            graphListener.onPreBatchEnd();
        }
    }

    private void notifyPostUpdate(Collection<Quad> inserts, Collection<Quad> deletes) {
        for (GraphListener graphListener : this.graphListeners) {
            graphListener.onPostBatchStart();
            if (inserts != null) {
                for (Quad quad : inserts) {
                    graphListener.onPostInsert(quad);
                }
            }
            if (deletes != null) {
                for (Quad quad : deletes) {
                    graphListener.onPostDelete(quad);
                }
            }
            graphListener.onPostBatchEnd();
        }
    }

    private void delete(Collection<Quad> quads) {
        if (quads.isEmpty()) {
            return;
        }
        this.notifyPreUpdate(null, quads);
        for (Map.Entry<Node, Graph> entry : UpdateGraph.quadsToGraphs(quads).entrySet()) {
            Model model = ModelFactory.createModelForGraph((Graph)entry.getValue());
            this.endpoint.remove(model, entry.getKey().toString());
        }
        this.notifyPostUpdate(null, quads);
    }

    private void _update(UpdateModify update) {
        Element wherePattern = update.getWherePattern();
        Query query = QueryUtils.elementToQuery((Element)wherePattern);
        String queryStr = query.toString();
        ResultSet rs = this.endpoint.createQueryExecution(queryStr).execSelect();
        HashSet<Quad> inserts = new HashSet<Quad>();
        HashSet<Quad> deletes = new HashSet<Quad>();
        while (rs.hasNext()) {
            Binding binding = rs.nextBinding();
            Set i = QueryUtils.instanciate((Iterable)update.getInsertQuads(), (Binding)binding);
            Set d = QueryUtils.instanciate((Iterable)update.getDeleteQuads(), (Binding)binding);
            inserts.addAll(i);
            deletes.addAll(d);
            if (inserts.size() > this.batchSize) {
                this.insert(inserts);
                inserts.clear();
            }
            if (deletes.size() <= this.batchSize) continue;
            this.delete(deletes);
            deletes.clear();
        }
        this.insert(inserts);
        this.delete(deletes);
    }

    private void _update(UpdateDataInsert update) {
        this.insert(update.getQuads());
    }

    private void _update(UpdateDataDelete update) {
        this.delete(update.getQuads());
    }

    public void executeUpdate(String queryStr) {
        UpdateRequest request = new UpdateRequest();
        UpdateFactory.parse((UpdateRequest)request, (String)queryStr);
        for (Update update : request.getOperations()) {
            MultiMethod.invoke((Object)this, (String)"_update", (Object[])new Object[]{update});
        }
    }
}

