/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.web;

import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.jolbox.bonecp.BoneCPConfig;
import com.jolbox.bonecp.BoneCPDataSource;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.Iterator;
import java.util.Map;
import javax.sql.DataSource;
import org.aksw.commons.sparql.api.core.QueryExecutionStreaming;
import org.aksw.commons.util.MapReader;
import org.aksw.sparqlify.config.lang.ConfigParser;
import org.aksw.sparqlify.config.syntax.Config;
import org.aksw.sparqlify.config.v0_2.bridge.ConfiguratorCandidateSelector;
import org.aksw.sparqlify.config.v0_2.bridge.SchemaProviderImpl;
import org.aksw.sparqlify.config.v0_2.bridge.SyntaxBridge;
import org.aksw.sparqlify.core.RdfViewSystemOld;
import org.aksw.sparqlify.core.algorithms.CandidateViewSelectorImpl;
import org.aksw.sparqlify.core.algorithms.OpMappingRewriterImpl;
import org.aksw.sparqlify.core.algorithms.ViewDefinitionNormalizerImpl;
import org.aksw.sparqlify.core.cast.NewWorldTest;
import org.aksw.sparqlify.core.cast.TypeSystem;
import org.aksw.sparqlify.core.interfaces.MappingOps;
import org.aksw.sparqlify.core.sparql.QueryEx;
import org.aksw.sparqlify.core.sparql.QueryExecutionFactoryEx;
import org.aksw.sparqlify.core.sparql.QueryFactoryEx;
import org.aksw.sparqlify.util.SparqlifyUtils;
import org.aksw.sparqlify.validation.LoggerCount;
import org.aksw.sparqlify.web.HttpSparqlEndpoint;
import org.aksw.sparqlify.web.SparqlFormatterUtils;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.postgresql.ds.PGSimpleDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger logger = LoggerFactory.getLogger(HttpSparqlEndpoint.class);
    private static final Options cliOptions = new Options();

    public static void printHelpAndExit(int exitCode) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(HttpSparqlEndpoint.class.getName(), cliOptions);
        System.exit(exitCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Config config;
        File configFile;
        String maxQueryExecutionTimeStr;
        boolean isQuery;
        LoggerCount loggerCount = new LoggerCount(logger);
        Class.forName("org.postgresql.Driver");
        GnuParser cliParser = new GnuParser();
        cliOptions.addOption("P", "port", true, "Server port");
        cliOptions.addOption("C", "context", true, "Context e.g. /sparqlify");
        cliOptions.addOption("B", "backlog", true, "Maximum number of connections");
        cliOptions.addOption("t", "type", true, "Database type (posgres, mysql,...)");
        cliOptions.addOption("d", "database", true, "Database name");
        cliOptions.addOption("u", "username", true, "");
        cliOptions.addOption("p", "password", true, "");
        cliOptions.addOption("h", "hostname", true, "");
        cliOptions.addOption("Q", "query", true, "");
        cliOptions.addOption("D", "dump", false, "");
        cliOptions.addOption("m", "mapping", true, "Sparqlify mapping file");
        cliOptions.addOption("t", "timeout", true, "Maximum query execution timeout");
        cliOptions.addOption("n", "resultsetsize", true, "Maximum result set size");
        cliOptions.addOption("c", "class", true, "JDBC driver class");
        cliOptions.addOption("j", "jdbcurl", true, "JDBC URL");
        CommandLine commandLine = cliParser.parse(cliOptions, args);
        String portStr = commandLine.getOptionValue("P", "7531");
        int port = Integer.parseInt(portStr);
        String hostName = commandLine.getOptionValue("h", "");
        String dbName = commandLine.getOptionValue("d", "");
        String userName = commandLine.getOptionValue("u", "");
        String passWord = commandLine.getOptionValue("p", "");
        String jdbcUrl = commandLine.getOptionValue("j", "");
        boolean isDump = commandLine.hasOption("D");
        String queryString = commandLine.getOptionValue("Q", "");
        boolean bl = isQuery = !queryString.isEmpty();
        if (!isQuery) {
            queryString = null;
        }
        if (isDump && isQuery) {
            loggerCount.error("Options D and Q are mutually exclusive");
        }
        if (isDump) {
            queryString = "Construct { ?s ?p ?o } { ?s ?p ?o }";
        }
        Integer maxQueryExecutionTime = (maxQueryExecutionTimeStr = commandLine.getOptionValue("t", null)) == null ? null : Integer.valueOf(Integer.parseInt(maxQueryExecutionTimeStr));
        String maxResultSetSizeStr = commandLine.getOptionValue("n", null);
        Long maxResultSetSize = maxResultSetSizeStr == null ? null : Long.valueOf(Long.parseLong(maxResultSetSizeStr));
        String configFileStr = commandLine.getOptionValue("m");
        if (configFileStr == null) {
            loggerCount.error("No mapping file given");
            Main.printHelpAndExit(-1);
        }
        if (!(configFile = new File(configFileStr)).exists()) {
            loggerCount.error("File does not exist: " + configFileStr);
            Main.printHelpAndExit(-1);
        }
        ConfigParser parser = new ConfigParser();
        FileInputStream in = new FileInputStream(configFile);
        try {
            config = parser.parse(in, (Logger)loggerCount);
        }
        finally {
            ((InputStream)in).close();
        }
        if (!(jdbcUrl.isEmpty() || hostName.isEmpty() && dbName.isEmpty())) {
            loggerCount.error("Option 'j' is mutually exclusive with 'h' and 'd'");
        }
        if (jdbcUrl.isEmpty() && hostName.isEmpty()) {
            hostName = "localhost";
        }
        PGSimpleDataSource dataSourceBean = null;
        if (jdbcUrl.isEmpty()) {
            dataSourceBean = new PGSimpleDataSource();
            dataSourceBean.setDatabaseName(dbName);
            dataSourceBean.setServerName(hostName);
            dataSourceBean.setUser(userName);
            dataSourceBean.setPassword(passWord);
        }
        BoneCPConfig cpConfig = new BoneCPConfig();
        if (jdbcUrl.isEmpty()) {
            cpConfig.setDatasourceBean((DataSource)dataSourceBean);
        } else {
            cpConfig.setJdbcUrl(jdbcUrl);
            cpConfig.setUsername(userName);
            cpConfig.setPassword(passWord);
        }
        cpConfig.setMinConnectionsPerPartition(1);
        cpConfig.setMaxConnectionsPerPartition(3);
        cpConfig.setPartitionCount(1);
        BoneCPDataSource dataSource = new BoneCPDataSource(cpConfig);
        RdfViewSystemOld.initSparqlifyFunctions();
        Connection conn = dataSource.getConnection();
        TypeSystem typeSystem = NewWorldTest.createDefaultDatatypeSystem();
        Map typeAlias = MapReader.readFromResource((String)"/type-map.h2.tsv");
        SchemaProviderImpl schemaProvider = new SchemaProviderImpl(conn, typeSystem, typeAlias);
        SyntaxBridge syntaxBridge = new SyntaxBridge(schemaProvider);
        MappingOps mappingOps = SparqlifyUtils.createDefaultMappingOps(typeSystem);
        OpMappingRewriterImpl opMappingRewriter = new OpMappingRewriterImpl(mappingOps);
        CandidateViewSelectorImpl candidateViewSelector = new CandidateViewSelectorImpl(mappingOps, new ViewDefinitionNormalizerImpl());
        ConfiguratorCandidateSelector.configure(config, syntaxBridge, candidateViewSelector, (Logger)loggerCount);
        logger.info("Errors: " + loggerCount.getErrorCount() + ", Warnings: " + loggerCount.getWarningCount());
        if (loggerCount.getErrorCount() > 0) {
            throw new RuntimeException("Encountered " + loggerCount.getErrorCount() + " errors that need to be fixed first.");
        }
        QueryExecutionFactoryEx qef = SparqlifyUtils.createDefaultSparqlifyEngine((DataSource)dataSource, config, maxResultSetSize, maxQueryExecutionTime);
        if (queryString != null) {
            QueryEx queryEx = QueryFactoryEx.create(queryString);
            if (queryEx.isSelectType()) {
                QueryExecutionStreaming qe = qef.createQueryExecution(queryEx);
                ResultSet rs = qe.execSelect();
                System.out.println(ResultSetFormatter.asText((ResultSet)rs));
            } else if (queryEx.isConstructType()) {
                QueryExecutionStreaming qe = qef.createQueryExecution(queryString);
                Iterator it = qe.execConstructStreaming();
                SparqlFormatterUtils.writeText((OutputStream)System.out, it);
            } else {
                throw new RuntimeException("Query type not supported: " + queryString);
            }
            return;
        }
        HttpSparqlEndpoint.sparqler = qef;
        ServletHolder sh = new ServletHolder(ServletContainer.class);
        sh.setInitParameter("com.sun.jersey.config.property.resourceConfigClass", "com.sun.jersey.api.core.PackagesResourceConfig");
        sh.setInitParameter("com.sun.jersey.config.property.packages", "org.aksw.sparqlify.web");
        Server server = new Server(port);
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)server, "/", 1);
        context.getServletContext().setAttribute("queryExecutionFactory", (Object)qef);
        context.addServlet(sh, "/*");
        server.start();
    }
}

