/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.web;

import javax.annotation.Resource;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.StreamingOutput;
import org.aksw.commons.sparql.api.core.QueryExecutionFactory;
import org.aksw.sparqlify.core.sparql.QueryExecutionFactoryEx;
import org.aksw.sparqlify.web.ProcessQuery;
import org.aksw.sparqlify.web.StreamingOutputString;
import org.springframework.stereotype.Component;

@Component
@Path(value="/sparql")
public class HttpSparqlEndpoint {
    @Resource
    private QueryExecutionFactoryEx queryExecutionFactory;
    public static QueryExecutionFactoryEx sparqler = null;

    public void setQueryExecutionFactory(QueryExecutionFactoryEx queryExecutionFactory) {
        this.queryExecutionFactory = queryExecutionFactory;
    }

    public QueryExecutionFactory getQueryExecutionFactorys() {
        return this.queryExecutionFactory;
    }

    public HttpSparqlEndpoint() {
    }

    public HttpSparqlEndpoint(@Context ServletContext context) {
        QueryExecutionFactoryEx qef;
        this.queryExecutionFactory = qef = (QueryExecutionFactoryEx)context.getAttribute("queryExecutionFactory");
        this.init();
    }

    public void init() {
    }

    public QueryExecutionFactoryEx getSparqler() throws Exception {
        if (sparqler == null) {
            sparqler = this.queryExecutionFactory;
        }
        if (sparqler == null) {
            throw new NullPointerException("The query execution factory has not been set.");
        }
        return sparqler;
    }

    public StreamingOutput processQuery(String queryString, String format) throws Exception {
        return ProcessQuery.processQuery(queryString, format, this.getSparqler());
    }

    @GET
    @Produces(value={"application/xml"})
    public StreamingOutput executeQueryXml(@QueryParam(value="query") String queryString) throws Exception {
        if (queryString == null) {
            return StreamingOutputString.create("<error>No query specified. Append '?query=&lt;your SPARQL query&gt;'</error>");
        }
        return this.processQuery(queryString, "Xml");
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public StreamingOutput executeQueryXmlPost(@FormParam(value="query") String queryString) throws Exception {
        if (queryString == null) {
            return StreamingOutputString.create("<error>No query specified. Append '?query=&lt;your SPARQL query&gt;'</error>");
        }
        return this.processQuery(queryString, "Xml");
    }

    @GET
    @Produces(value={"application/json", "application/sparql-results+json"})
    public StreamingOutput executeQueryJson(@QueryParam(value="query") String queryString) throws Exception {
        return this.processQuery(queryString, "Json");
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json", "application/sparql-results+json"})
    public StreamingOutput executeQueryJsonPost(@FormParam(value="query") String queryString) throws Exception {
        return this.processQuery(queryString, "Json");
    }

    @GET
    @Produces(value={"application/rdf+xml"})
    public StreamingOutput executeQueryRdfXml(@QueryParam(value="query") String queryString) throws Exception {
        return this.processQuery(queryString, "RdfXml");
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/rdf+xml"})
    public StreamingOutput executeQueryRdfXmlPost(@FormParam(value="query") String queryString) throws Exception {
        return this.processQuery(queryString, "RdfXml");
    }

    @GET
    @Produces(value={"application/sparql-results+xml"})
    public StreamingOutput executeQueryResultSetXml(@QueryParam(value="query") String queryString) throws Exception {
        return this.processQuery(queryString, "Xml");
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/sparql-results+xml"})
    public StreamingOutput executeQueryResultSetXmlPost(@FormParam(value="query") String queryString) throws Exception {
        return this.processQuery(queryString, "Xml");
    }

    @GET
    @Produces(value={"text/plain"})
    public StreamingOutput executeQueryText(@QueryParam(value="query") String queryString) throws Exception {
        return this.processQuery(queryString, "Text");
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/plain"})
    public StreamingOutput executeQueryTextPost(@FormParam(value="query") String queryString) throws Exception {
        return this.processQuery(queryString, "Text");
    }
}

